/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.ruby.RbSpyCallStackElement;
import com.intellij.profiler.ruby.RbSpyParser;
import com.intellij.profiler.ui.NativeCallStackElementRenderer;
import com.intellij.profiler.ui.flamechart.ColorType;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.ui.JBColor;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class RubyCellChartRenderer
extends NativeCallStackElementRenderer {
    @NotNull
    public static final RubyCellChartRenderer INSTANCE = new RubyCellChartRenderer();

    protected RubyCellChartRenderer() {
    }

    @NotNull
    public String fillTextInsideNode(@NotNull BaseCallStackElement node, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        String dir;
        String dirWithSeparator;
        String currString;
        if (node == null) {
            RubyCellChartRenderer.$$$reportNull$$$0(0);
        }
        if (rect == null) {
            RubyCellChartRenderer.$$$reportNull$$$0(1);
        }
        if (fontMetrics == null) {
            RubyCellChartRenderer.$$$reportNull$$$0(2);
        }
        double maxWidth = rect.getWidth() - 0.0;
        String text = this.getText(node);
        if ((double)fontMetrics.stringWidth(text) < maxWidth) {
            String string = text;
            if (string == null) {
                RubyCellChartRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (!(node instanceof RbSpyCallStackElement)) {
            String string = super.fillTextInsideNode(node, rect, fontMetrics);
            if (string == null) {
                RubyCellChartRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }
        RbSpyCallStackElement rbSpyCallStackElement = (RbSpyCallStackElement)node;
        String methodName = rbSpyCallStackElement.getMethodName();
        if ((double)fontMetrics.stringWidth(methodName) >= maxWidth) {
            String string = super.fillTextInsideNode(node, rect, fontMetrics);
            if (string == null) {
                RubyCellChartRenderer.$$$reportNull$$$0(5);
            }
            return string;
        }
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = rbSpyCallStackElement.getElementPathParts().iterator();
        while (iterator.hasNext() && !((double)fontMetrics.stringWidth(currString = RubyCellChartRenderer.getStackElementPresentationString(rbSpyCallStackElement, (dirWithSeparator = File.separatorChar + (dir = iterator.next())) + String.valueOf(result))) >= maxWidth)) {
            result.insert(0, dirWithSeparator);
        }
        String resultString = result.toString();
        if (resultString.isEmpty()) {
            String string = methodName;
            if (string == null) {
                RubyCellChartRenderer.$$$reportNull$$$0(6);
            }
            return string;
        }
        return RubyCellChartRenderer.getStackElementPresentationString(rbSpyCallStackElement, resultString);
    }

    @NotNull
    public FlameChartColorScheme getColorScheme(@NotNull BaseCallStackElement node) {
        RbSpyCallStackElement rbSpyElement;
        if (node == null) {
            RubyCellChartRenderer.$$$reportNull$$$0(7);
        }
        if (node instanceof RbSpyParser.CFunctionStackElement) {
            FlameChartColors.DEFAULT dEFAULT = FlameChartColors.DEFAULT.INSTANCE;
            if (dEFAULT == null) {
                RubyCellChartRenderer.$$$reportNull$$$0(8);
            }
            return dEFAULT;
        }
        if (node instanceof RbSpyCallStackElement && (rbSpyElement = (RbSpyCallStackElement)node).isInProject()) {
            FlameChartColors.JAVA jAVA = FlameChartColors.JAVA.INSTANCE;
            if (jAVA == null) {
                RubyCellChartRenderer.$$$reportNull$$$0(9);
            }
            return jAVA;
        }
        GemFrameChartColorScheme gemFrameChartColorScheme = GemFrameChartColorScheme.INSTANCE;
        if (gemFrameChartColorScheme == null) {
            RubyCellChartRenderer.$$$reportNull$$$0(10);
        }
        return gemFrameChartColorScheme;
    }

    @NotNull
    private static String getStackElementPresentationString(@NotNull RbSpyCallStackElement rbSpyCallStackElement, @NotNull String pathSubstring) {
        if (rbSpyCallStackElement == null) {
            RubyCellChartRenderer.$$$reportNull$$$0(11);
        }
        if (pathSubstring == null) {
            RubyCellChartRenderer.$$$reportNull$$$0(12);
        }
        String string = rbSpyCallStackElement.getMethodName() + " ..." + pathSubstring + ":" + rbSpyCallStackElement.getLineNo();
        if (string == null) {
            RubyCellChartRenderer.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ruby/RubyCellChartRenderer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rbSpyCallStackElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathSubstring";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ruby/RubyCellChartRenderer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fillTextInsideNode";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackElementPresentationString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillTextInsideNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getColorScheme";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getStackElementPresentationString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 9, 10, 13 -> new IllegalStateException(string);
        };
    }

    private static class GemFrameChartColorScheme
    extends FlameChartColorScheme {
        static final GemFrameChartColorScheme INSTANCE = new GemFrameChartColorScheme();

        private GemFrameChartColorScheme() {
        }

        @NotNull
        protected JBColor produce(@NotNull ColorType type) {
            if (type == null) {
                GemFrameChartColorScheme.$$$reportNull$$$0(0);
            }
            JBColor jBColor = switch (type) {
                case ColorType.FOREGROUND, ColorType.FOREGROUND_HOVER -> this.colorize(ColorType.BACKGROUND);
                case ColorType.FOREGROUND_INACTIVE -> this.colorize(ColorType.BACKGROUND_INACTIVE);
                case ColorType.FOREGROUND_HOVER_INACTIVE -> this.colorize(ColorType.BACKGROUND_HOVER_INACTIVE);
                case ColorType.BACKGROUND, ColorType.SEARCH_OK -> new JBColor(15778438, 10912597);
                case ColorType.BACKGROUND_HOVER, ColorType.BACKGROUND_HOVER_GROUP, ColorType.SEARCH_OK_HOVER -> new JBColor(14727040, 9533009);
                case ColorType.BACKGROUND_INACTIVE -> this.shadow(ColorType.BACKGROUND);
                case ColorType.BACKGROUND_HOVER_INACTIVE, ColorType.BACKGROUND_HOVER_INACTIVE_GROUP -> this.shadow(ColorType.BACKGROUND_HOVER);
                case ColorType.SEARCH_OK_INACTIVE -> this.shadow(ColorType.SEARCH_OK);
                case ColorType.SEARCH_OK_HOVER_INACTIVE -> this.shadow(ColorType.SEARCH_OK_INACTIVE);
                case ColorType.SEARCH_FAIL -> new JBColor(12755834, 6903875);
                case ColorType.SEARCH_FAIL_HOVER, ColorType.SEARCH_FAIL_HOVER_GROUP -> new JBColor(10060906, 5721410);
                case ColorType.SEARCH_FAIL_INACTIVE -> this.shadow(ColorType.SEARCH_FAIL);
                case ColorType.SEARCH_FAIL_HOVER_INACTIVE, ColorType.SEARCH_FAIL_HOVER_INACTIVE_GROUP -> this.shadow(ColorType.SEARCH_FAIL_HOVER);
                default -> this.colorize(ColorType.BACKGROUND);
            };
            if (jBColor == null) {
                GemFrameChartColorScheme.$$$reportNull$$$0(1);
            }
            return jBColor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profiler/ruby/RubyCellChartRenderer$GemFrameChartColorScheme";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profiler/ruby/RubyCellChartRenderer$GemFrameChartColorScheme";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "produce";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "produce";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

