/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.FileBasedProfilerProcess;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.api.AttachCanceledException;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.CopyFileDumpWriter;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ruby.RbSpyProfilerDumpParserProvider;
import com.intellij.profiler.ruby.RubyNativeTargetProcess;
import com.intellij.profiler.ruby.RubyProfilerBundle;
import com.intellij.profiler.ruby.configuration.RbSpyConfigurationType;
import com.intellij.profiler.ruby.configuration.RbSpyProfilerConfigurationState;
import com.intellij.profiler.sudo.SudoProcessHandler;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.osHandlers.AttachOSHandler;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class RbSpyProfilerProcess
extends FileBasedProfilerProcess<AttachableTargetProcess> {
    private static final Logger LOG = Logger.getInstance(RbSpyProfilerProcess.class);
    private static final String RB_SPY_STARTUP_TEXT = "Press Ctrl+C to stop";
    private static final String RB_SPY_RUBY_VERSION_NOT_SUPPORTED = "Ruby version not supported yet";
    private final long myAttachedTimestamp;
    @NotNull
    private final RbSpyProfilerConfigurationState myProfilerConfiguration;
    @NotNull
    private final BaseProcessHandler myProcessHandler;
    @NotNull
    private final File myFile;

    public RbSpyProfilerProcess(@NotNull RbSpyProfilerConfigurationState profilerConfiguration, @NotNull BaseProcessHandler processHandler, @NotNull File outputFile, @NotNull String processName, @NotNull Project project, long attachedTimestamp) {
        if (profilerConfiguration == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(1);
        }
        if (outputFile == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(2);
        }
        if (processName == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(3);
        }
        if (project == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(4);
        }
        this(profilerConfiguration, processHandler, outputFile, project, attachedTimestamp, new RubyNativeTargetProcess(OSProcessUtil.getProcessID((Process)processHandler.getProcess()), processName, (EnvironmentAwareHost)LocalAttachHost.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    public RbSpyProfilerProcess(@NotNull RbSpyProfilerConfigurationState profilerConfiguration, @NotNull BaseProcessHandler processHandler, @NotNull File outputFile, @NotNull Project project, long attachedTimestamp, @NotNull AttachableTargetProcess attachableTargetProcess) {
        void targetProcess;
        if (profilerConfiguration == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(5);
        }
        if (processHandler == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(6);
        }
        if (outputFile == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(7);
        }
        if (project == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(8);
        }
        if (attachableTargetProcess == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(9);
        }
        super(project, (ProfilerTargetProcess)targetProcess, outputFile);
        this.myProfilerConfiguration = profilerConfiguration;
        this.myProcessHandler = processHandler;
        this.myFile = outputFile;
        this.initTargetProcessLifecycleListener((ProcessHandler)processHandler);
        this.myAttachedTimestamp = attachedTimestamp;
    }

    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        RbSpyProfilerConfigurationState rbSpyProfilerConfigurationState = this.myProfilerConfiguration;
        if (rbSpyProfilerConfigurationState == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(10);
        }
        return rbSpyProfilerConfigurationState;
    }

    @NotNull
    protected ProfilerState readPreparedDump(@NotNull File dump, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
        if (dump == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(11);
        }
        if (indicator == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(12);
        }
        ProfilerDumpFileParser parser = new RbSpyProfilerDumpParserProvider().createParser(this.getProject());
        ProfilerState profilerState = this.asProfilerState(parser.parse(dump, indicator), (ProfilerDumpWriter)new CopyFileDumpWriter(this.myFile, ((AttachableTargetProcess)this.getTargetProcess()).getFullName(), this.myAttachedTimestamp, "gz"));
        if (profilerState == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(13);
        }
        return profilerState;
    }

    public long getAttachedTimestamp() {
        return this.myAttachedTimestamp;
    }

    @Nullable
    public String getHelpId() {
        return RbSpyConfigurationType.RUBY_PROFILER_HELP_TOPIC;
    }

    public boolean canBeStopped() {
        return true;
    }

    public boolean doStop() {
        if (this.myProcessHandler instanceof SudoProcessHandler) {
            ((SudoProcessHandler)this.myProcessHandler).sendSIGINT();
            return true;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)this.myProcessHandler, (long)1000L, null));
        return true;
    }

    public static Promise<RbSpyProfilerProcess> attach(final @NotNull RubyNativeTargetProcess targetProcess, final @NotNull RbSpyProfilerConfigurationState configurationState, final @NotNull Project project, final @NotNull File outputFile) {
        if (targetProcess == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(14);
        }
        if (configurationState == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(15);
        }
        if (project == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(16);
        }
        if (outputFile == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(17);
        }
        final AsyncPromise result = new AsyncPromise();
        final Runnable setWrongPasswordResult = () -> result.setError((Throwable)new AttachFailedException(CommonProfilerBundleKt.commonProfilerMessage((String)"profiler.valid.password.required", (Object[])new Object[0])));
        new Task.Backgroundable(project, RubyProfilerBundle.message("profiler.ruby.rbspy.attach.title", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                KillableColoredProcessHandler handler;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(RubyProfilerBundle.message("profiler.ruby.rbspy.attach.task.text", targetProcess.getFullName()));
                Semaphore semaphore = new Semaphore(1);
                final AtomicBoolean terminated = new AtomicBoolean(false);
                List<String> commandLine = RbSpyProfilerProcess.createCommandLine(configurationState, targetProcess.getPid(), outputFile);
                if (targetProcess.getHostInfo().getOsHandler().getOSType() == AttachOSHandler.OSType.WINDOWS) {
                    try {
                        handler = new KillableColoredProcessHandler(new GeneralCommandLine(commandLine));
                    }
                    catch (ExecutionException e) {
                        result.setError((Throwable)e);
                        return;
                    }
                } else {
                    String password = ProfilerManager.INSTANCE.getSudoPassword(project, indicator);
                    if (password == null) {
                        setWrongPasswordResult.run();
                        return;
                    }
                    handler = new SudoProcessHandler(commandLine, () -> password, () -> {
                        semaphore.up();
                        setWrongPasswordResult.run();
                        return Unit.INSTANCE;
                    }, signal -> {
                        LOG.error("can't send signal" + signal);
                        semaphore.up();
                        return Unit.INSTANCE;
                    });
                }
                ProcessListener adapter = new ProcessListener(){
                    final /* synthetic */ BaseProcessHandler val$handler;
                    final /* synthetic */ Semaphore val$semaphore;
                    {
                        this.val$handler = baseProcessHandler;
                        this.val$semaphore = semaphore;
                    }

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (terminated.get()) {
                            return;
                        }
                        String text = event.getText();
                        if (ProcessOutputType.isStderr((Key)outputType) && text.contains(RbSpyProfilerProcess.RB_SPY_STARTUP_TEXT)) {
                            result.setResult((Object)new RbSpyProfilerProcess(configurationState, this.val$handler, outputFile, project, System.currentTimeMillis(), targetProcess));
                            this.val$semaphore.up();
                            return;
                        }
                        if (ProcessOutputType.isStderr((Key)outputType) && text.contains(RbSpyProfilerProcess.RB_SPY_RUBY_VERSION_NOT_SUPPORTED)) {
                            this.val$handler.destroyProcess();
                            RbSpyProfilerProcess process = (RbSpyProfilerProcess)((Object)result.get());
                            if (process != null) {
                                process.changeStateAndNotifyAsync((ProfilerState)new ProfilerError(RubyProfilerBundle.message("profiler.ruby.rbspy.error", new Object[0]) + "\n" + text.replace("\n", "")));
                            }
                            this.val$semaphore.up();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/profiler/ruby/RbSpyProfilerProcess$1$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                handler.addProcessListener(adapter);
                handler.startNotify();
                while (!semaphore.waitFor(100L)) {
                    if (!indicator.isCanceled()) continue;
                    terminated.set(true);
                    handler.destroyProcess();
                    result.setError((Throwable)AttachCanceledException.INSTANCE);
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/profiler/ruby/RbSpyProfilerProcess$1", "run"));
            }
        }.queue();
        return result;
    }

    @NotNull
    static List<String> createCommandLine(@NotNull RbSpyProfilerConfigurationState state, int pid, @NotNull File outputFile) {
        if (state == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(18);
        }
        if (outputFile == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(19);
        }
        List<String> list = Arrays.asList(state.getExecutablePathOrFindInPath(), "record", "--pid=" + pid, "--rate=" + state.getSamplingFrequency(), "--raw-file=" + outputFile.getPath(), "--silent");
        if (list == null) {
            RbSpyProfilerProcess.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerConfiguration";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 7: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProcess";
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ruby/RbSpyProfilerProcess";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dump";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationState";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ruby/RbSpyProfilerProcess";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readPreparedDump";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readPreparedDump";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "attach";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13, 20 -> new IllegalStateException(string);
        };
    }
}

