/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby;

import com.intellij.profiler.MainCallTreeNode;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.profiler.ruby.RbSpyCallStackElement;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import com.intellij.profiler.ui.grouping.ProfilerNodesGrouper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0016J(\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u000b\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0016J \u0010\r\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0002J,\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00060\t0\u000f\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ruby/RbSpyProfilerExternalNodesGrouper;", "Lcom/intellij/profiler/ui/grouping/ProfilerNodesGrouper;", "<init>", "()V", "isApplicable", "", "Call", "Lcom/intellij/profiler/api/BaseCallStackElement;", "node", "Lcom/intellij/profiler/MainCallTreeNode;", "groupWithRootNode", "Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "root", "isInProject", "computeDeepestExternalChildren", "", "intellij.ruby.profiler"})
public final class RbSpyProfilerExternalNodesGrouper
implements ProfilerNodesGrouper {
    public <Call extends BaseCallStackElement> boolean isApplicable(@NotNull MainCallTreeNode<Call> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        CallWithValue callWithValue = node.getData();
        return (callWithValue != null ? (BaseCallStackElement)callWithValue.getCall() : null) instanceof RbSpyCallStackElement;
    }

    @Nullable
    public <Call extends BaseCallStackElement> FoldingNodesGroup<Call> groupWithRootNode(@NotNull MainCallTreeNode<Call> root) {
        Intrinsics.checkNotNullParameter(root, (String)"root");
        if (this.isInProject(root)) {
            return null;
        }
        List<MainCallTreeNode<Call>> deepestExternalChildren = this.computeDeepestExternalChildren(root);
        return deepestExternalChildren.isEmpty() ? null : new FoldingNodesGroup(root, deepestExternalChildren, 0, 4, null);
    }

    private final <Call extends BaseCallStackElement> boolean isInProject(MainCallTreeNode<Call> node) {
        CallWithValue callWithValue = node.getData();
        BaseCallStackElement baseCallStackElement = callWithValue != null ? (BaseCallStackElement)callWithValue.getCall() : null;
        RbSpyCallStackElement rbSpyCallStackElement = baseCallStackElement instanceof RbSpyCallStackElement ? (RbSpyCallStackElement)baseCallStackElement : null;
        return rbSpyCallStackElement != null ? rbSpyCallStackElement.isInProject() : false;
    }

    private final <Call extends BaseCallStackElement> List<MainCallTreeNode<Call>> computeDeepestExternalChildren(MainCallTreeNode<Call> root) {
        if (root.getChildren().size() > 100) {
            return CollectionsKt.emptyList();
        }
        List result = CollectionsKt.emptyList();
        List currentTails = CollectionsKt.listOf(root);
        block0: while (true) {
            List newTails = new ArrayList();
            for (MainCallTreeNode parent : currentTails) {
                if (parent.getChildren().isEmpty() || parent.getChildren().size() > 100) break block0;
                for (MainCallTreeNode child : parent.getChildren()) {
                    if (this.isInProject(child)) break block0;
                    newTails.add(child);
                }
                if (newTails.size() <= 100) continue;
                break block0;
            }
            result = currentTails = newTails;
        }
        return result;
    }
}

