/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ruby;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.NativeThread;
import com.intellij.profiler.model.NoThreadInfoInProfilerData;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ruby.RbSpyCallStackElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RbSpyParser
extends LineByLineParser {
    private static final Logger LOG = Logger.getInstance(RbSpyParser.class);
    @NotNull
    private static final String C_FUNCTION = "<c function>";
    @NotNull
    private static final CFunctionStackElement C_FUNCTION_STACK_ELEMENT = new CFunctionStackElement("<c function>");
    @NotNull
    private static final String C_FUNCTION_MARKER = "[c function]";
    @NotNull
    private static final String TRACE = "trace";
    @NotNull
    private final DummyCallTreeBuilder<BaseCallStackElement> myBuilder;
    @Nullable
    private final Project myProject;
    private final Map<String, BaseCallStackElement> myFramesInterner;
    private final Map<String, ThreadInfo> myThreadsInterner;
    private final Interner<String> myStringInterner;

    public RbSpyParser(@NotNull DummyCallTreeBuilder<BaseCallStackElement> builder, @Nullable Project project) {
        if (builder == null) {
            RbSpyParser.$$$reportNull$$$0(0);
        }
        this.myFramesInterner = ContainerUtil.createWeakValueMap();
        this.myThreadsInterner = ContainerUtil.createWeakValueMap();
        this.myStringInterner = Interner.createStringInterner();
        this.myBuilder = builder;
        this.myProject = project;
    }

    public void consumeLine(@Nullable String line) {
        if (line == null) {
            return;
        }
        if (!line.startsWith("{")) {
            return;
        }
        LinkedList<BaseCallStackElement> stackElements = new LinkedList<BaseCallStackElement>();
        JsonObject jsonObject = JsonParser.parseString((String)line).getAsJsonObject();
        if (!jsonObject.has(TRACE)) {
            return;
        }
        JsonArray traceArray = jsonObject.get(TRACE).getAsJsonArray();
        for (JsonElement element : traceArray) {
            int lineNumber;
            assert (element instanceof JsonObject);
            JsonObject elementObject = (JsonObject)element;
            String nameElement = StringUtil.notNullize((String)RbSpyParser.getField(elementObject, "name"), (String)"Unknown name");
            if (C_FUNCTION.equals(nameElement)) {
                stackElements.add(C_FUNCTION_STACK_ELEMENT);
                continue;
            }
            if (nameElement.contains(C_FUNCTION_MARKER)) {
                stackElements.add(this.myFramesInterner.computeIfAbsent(nameElement, CFunctionStackElement::new));
                continue;
            }
            String relativePathElement = RbSpyParser.getField(elementObject, "relative_path");
            assert (relativePathElement != null);
            String absolutePathElement = RbSpyParser.getField(elementObject, "absolute_path");
            if (absolutePathElement != null && absolutePathElement.endsWith("rubymine_profiler_pid_logger.rb")) {
                return;
            }
            String linenoElement = (String)ObjectUtils.coalesce((Object)RbSpyParser.getField(elementObject, "lineno"), (Object)"0");
            try {
                lineNumber = Integer.parseInt(linenoElement);
            }
            catch (NumberFormatException e) {
                LOG.debug("Error parsing line number ", new Object[]{linenoElement});
                lineNumber = 0;
            }
            String frameKey = String.join((CharSequence)":", nameElement, relativePathElement, linenoElement);
            int finalLineNumber = lineNumber;
            stackElements.add(this.myFramesInterner.computeIfAbsent(frameKey, it -> new RbSpyCallStackElement(nameElement, relativePathElement, absolutePathElement, finalLineNumber, this.myProject, this.myStringInterner)));
        }
        this.myBuilder.addStack(this.computeThreadInfo(jsonObject), ContainerUtil.reverse(stackElements), 1L);
    }

    @NotNull
    private ThreadInfo computeThreadInfo(@NotNull JsonObject jsonObject) {
        NoThreadInfoInProfilerData threadInfo;
        if (jsonObject == null) {
            RbSpyParser.$$$reportNull$$$0(1);
        }
        JsonElement pidElement = jsonObject.get("pid");
        JsonElement tidElement = jsonObject.get("thread_id");
        if (tidElement == null && pidElement == null) {
            threadInfo = NoThreadInfoInProfilerData.INSTANCE;
        } else {
            Object tidString;
            String pidString = pidElement == null ? null : "pid=" + pidElement.getAsString();
            Object object = tidString = tidElement == null ? null : tidElement.getAsString();
            if (tidString != null) {
                try {
                    long tid = Long.parseLong((String)tidString);
                    tidString = "tid=0x" + Long.toHexString(tid);
                }
                catch (NumberFormatException e) {
                    LOG.debug("Error parsing long thread id: ", new Object[]{tidString});
                    tidString = "tid=" + (String)tidString;
                }
            }
            String rubyThreadName = pidString == null ? tidString : (tidString == null ? pidString : String.join((CharSequence)", ", new CharSequence[]{pidString, tidString}));
            threadInfo = this.myThreadsInterner.computeIfAbsent(rubyThreadName, it -> new NativeThread(it, it));
        }
        NoThreadInfoInProfilerData noThreadInfoInProfilerData = threadInfo;
        if (noThreadInfoInProfilerData == null) {
            RbSpyParser.$$$reportNull$$$0(2);
        }
        return noThreadInfoInProfilerData;
    }

    @Nullable
    private static String getField(@NotNull JsonObject jsonObject, @NotNull String fieldName) {
        JsonElement element;
        if (jsonObject == null) {
            RbSpyParser.$$$reportNull$$$0(3);
        }
        if (fieldName == null) {
            RbSpyParser.$$$reportNull$$$0(4);
        }
        if ((element = jsonObject.get(fieldName)).isJsonNull()) {
            return null;
        }
        return element.getAsString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ruby/RbSpyParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ruby/RbSpyParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeThreadInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeThreadInfo";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static class CFunctionStackElement
    extends BaseCallStackElement {
        @NotNull
        private final String myName;

        CFunctionStackElement(@NotNull String name) {
            if (name == null) {
                CFunctionStackElement.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String fullName() {
            String string = this.myName;
            if (string == null) {
                CFunctionStackElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/profiler/ruby/RbSpyParser$CFunctionStackElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/profiler/ruby/RbSpyParser$CFunctionStackElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fullName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

