/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests.bazel;

import com.intellij.tests.bazel.SafeXml;
import com.intellij.tests.bazel.TestCaseXmlRenderer;
import com.intellij.tests.bazel.TestData;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.junit.platform.launcher.TestPlan;

class TestSuiteXmlRenderer {
    private final TestCaseXmlRenderer testRenderer;

    public TestSuiteXmlRenderer(TestPlan testPlan) {
        this.testRenderer = new TestCaseXmlRenderer(testPlan);
    }

    public void toXml(XMLStreamWriter xml, TestData suite, Collection<TestData> tests) throws XMLStreamException {
        xml.writeStartElement("testsuite");
        xml.writeAttribute("name", SafeXml.escapeIllegalCharacters(suite.getId().getLegacyReportingName()));
        xml.writeAttribute("timestamp", DateTimeFormatter.ISO_INSTANT.format(suite.getStarted()));
        xml.writeAttribute("tests", String.valueOf(tests.size()));
        DecimalFormat decimalFormat = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ROOT));
        Duration maybeDuration = suite.getDuration();
        Duration duration = maybeDuration == null ? Duration.between(suite.getStarted(), Instant.now()) : maybeDuration;
        xml.writeAttribute("time", decimalFormat.format((float)duration.toMillis() / 1000.0f));
        int errors = 0;
        int failures = 0;
        int disabled = 0;
        int skipped = 0;
        for (TestData result : tests) {
            if (result.getDuration() == null) {
                ++failures;
                continue;
            }
            if (result.isError()) {
                ++errors;
            }
            if (result.isFailure()) {
                ++failures;
            }
            if (result.isDisabled()) {
                ++disabled;
            }
            if (!result.isSkipped()) continue;
            ++skipped;
        }
        xml.writeAttribute("failures", String.valueOf(failures));
        xml.writeAttribute("errors", String.valueOf(errors));
        xml.writeAttribute("disabled", String.valueOf(disabled));
        xml.writeAttribute("skipped", String.valueOf(skipped));
        xml.writeAttribute("package", "");
        xml.writeEmptyElement("properties");
        for (TestData testCase : tests) {
            this.testRenderer.toXml(xml, testCase);
        }
        SafeXml.writeTextElement(xml, "system-out", suite.getStdOut());
        SafeXml.writeTextElement(xml, "system-err", suite.getStdErr());
        xml.writeEndElement();
    }
}

