/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.beanproperty;

import org.assertj.swing.dependency.fest_reflect.beanproperty.PropertyType;
import org.assertj.swing.dependency.fest_reflect.beanproperty.PropertyTypeRef;
import org.assertj.swing.dependency.fest_reflect.reference.TypeRef;
import org.assertj.swing.dependency.fest_util.Strings;

public final class PropertyName {
    private final String name;

    public static PropertyName startPropertyAccess(String name) {
        PropertyName.validateIsNotNullOrEmpty(name);
        return new PropertyName(name);
    }

    private static void validateIsNotNullOrEmpty(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the property to access should not be null");
        }
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of the property to access should not be empty");
        }
    }

    private PropertyName(String name) {
        this.name = name;
    }

    public <T> PropertyType<T> ofType(Class<T> type) {
        return PropertyType.newPropertyType(this.name, type);
    }

    public <T> PropertyTypeRef<T> ofType(TypeRef<T> type) {
        return PropertyTypeRef.newPropertyTypeRef(this.name, type);
    }
}

