/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RubyVMOptions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyLanguageLevelService;", "", "languageLevel", "Lorg/jetbrains/plugins/ruby/ruby/sdk/LanguageLevel;", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.ruby.psi"})
public interface RubyLanguageLevelService {
    @NotNull
    public static final Companion Companion = org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService$Companion.$$INSTANCE;

    @Nullable
    public LanguageLevel languageLevel(@NotNull PsiElement var1);

    @JvmStatic
    @NotNull
    public static LanguageLevel getLanguageLevelByElementOrLatest(@Nullable PsiElement element) {
        return Companion.getLanguageLevelByElementOrLatest(element);
    }

    @JvmStatic
    @Nullable
    public static LanguageLevel getLanguageLevelByElement(@Nullable PsiElement element) {
        return Companion.getLanguageLevelByElement(element);
    }

    @JvmStatic
    @NotNull
    public static LanguageLevel getEffectiveLanguageLevel(@Nullable Sdk sdk) {
        return Companion.getEffectiveLanguageLevel(sdk);
    }

    @JvmStatic
    public static void setEffectiveLanguageLevel(@NotNull Sdk sdk, @NotNull LanguageLevel level) {
        Companion.setEffectiveLanguageLevel(sdk, level);
    }

    @JvmStatic
    @NotNull
    public static RubyLanguageLevelService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
        return Companion.getLanguageLevel(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyLanguageLevelService$Companion;", "", "<init>", "()V", "getLanguageLevelByElementOrLatest", "Lorg/jetbrains/plugins/ruby/ruby/sdk/LanguageLevel;", "element", "Lcom/intellij/psi/PsiElement;", "getLanguageLevelByElement", "getEffectiveLanguageLevel", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "setEffectiveLanguageLevel", "", "level", "getInstance", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyLanguageLevelService;", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageLevel", "intellij.ruby.psi"})
    @SourceDebugExtension(value={"SMAP\nRubyLanguageLevelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyLanguageLevelService.kt\norg/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyLanguageLevelService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,72:1\n30#2,2:73\n*S KotlinDebug\n*F\n+ 1 RubyLanguageLevelService.kt\norg/jetbrains/plugins/ruby/ruby/lang/psi/impl/RubyLanguageLevelService$Companion\n*L\n67#1:73,2\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LanguageLevel getLanguageLevelByElementOrLatest(@Nullable PsiElement element) {
            LanguageLevel languageLevel = this.getLanguageLevelByElement(element);
            if (languageLevel == null) {
                LanguageLevel languageLevel2 = LanguageLevel.latest();
                languageLevel = languageLevel2;
                Intrinsics.checkNotNullExpressionValue((Object)languageLevel2, (String)"latest(...)");
            }
            return languageLevel;
        }

        @JvmStatic
        @Nullable
        public final LanguageLevel getLanguageLevelByElement(@Nullable PsiElement element) {
            LanguageLevel forcedLanguageLevel = RubyVMOptions.getInstance().getForcedLanguageLevel();
            if (forcedLanguageLevel != null) {
                return forcedLanguageLevel;
            }
            PsiElement effectiveElement = element;
            if (effectiveElement instanceof PsiFile && ((PsiFile)effectiveElement).getContext() != null) {
                effectiveElement = ((PsiFile)effectiveElement).getContext();
            }
            if (effectiveElement instanceof RubyExpressionCodeFragment) {
                effectiveElement = ((RubyExpressionCodeFragment)effectiveElement).getContext();
            }
            if (effectiveElement == null) {
                return null;
            }
            Project project = effectiveElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.getInstance(project).languageLevel(effectiveElement);
        }

        @JvmStatic
        @NotNull
        public final LanguageLevel getEffectiveLanguageLevel(@Nullable Sdk sdk) {
            LanguageLevel languageLevel;
            if (sdk == null) {
                LanguageLevel languageLevel2 = LanguageLevel.latest();
                Intrinsics.checkNotNullExpressionValue((Object)languageLevel2, (String)"latest(...)");
                return languageLevel2;
            }
            SdkAdditionalData additionalData = sdk.getSdkAdditionalData();
            if (RubySdkAdditionalDataBase.Companion.isEmpty(additionalData)) {
                LanguageLevel languageLevel3 = LanguageLevel.latest();
                languageLevel = languageLevel3;
                Intrinsics.checkNotNullExpressionValue((Object)languageLevel3, (String)"latest(...)");
            } else {
                Intrinsics.checkNotNull((Object)additionalData, (String)"null cannot be cast to non-null type org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase");
                languageLevel = ((RubySdkAdditionalDataBase)additionalData).getLanguageLevel();
            }
            return languageLevel;
        }

        @JvmStatic
        public final void setEffectiveLanguageLevel(@NotNull Sdk sdk, @NotNull LanguageLevel level) {
            Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            RubySdkAdditionalDataBase.Companion.modify(sdk, arg_0 -> Companion.setEffectiveLanguageLevel$lambda$0(level, arg_0));
        }

        @JvmStatic
        @NotNull
        public final RubyLanguageLevelService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RubyLanguageLevelService> serviceClass$iv = RubyLanguageLevelService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RubyLanguageLevelService)object;
        }

        @JvmStatic
        @NotNull
        public final LanguageLevel getLanguageLevel(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            LanguageLevel languageLevel = this.getLanguageLevelByElement(element);
            if (languageLevel == null) {
                LanguageLevel languageLevel2 = LanguageLevel.latest();
                languageLevel = languageLevel2;
                Intrinsics.checkNotNullExpressionValue((Object)languageLevel2, (String)"latest(...)");
            }
            return languageLevel;
        }

        private static final void setEffectiveLanguageLevel$lambda$0(LanguageLevel $level, RubySdkAdditionalDataBase data) {
            data.setLanguageLevel($level);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

