/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;

public interface RubyTypeProvider {
    public static final ExtensionPointName<RubyTypeProvider> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.rubyTypeProvider");

    @Nullable
    default public RType createTypeBySymbol(@NotNull Symbol symbol, @NotNull List<RType> typeArguments) {
        if (symbol == null) {
            RubyTypeProvider.$$$reportNull$$$0(0);
        }
        if (typeArguments == null) {
            RubyTypeProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    default public RType createTypeByRExpression(@NotNull RExpression expression) {
        if (expression == null) {
            RubyTypeProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Nullable
    default public RType getBlockParameterType(RPsiElement parameter, RPsiElement scope) {
        return null;
    }

    @ApiStatus.Experimental
    @Nullable
    default public RType getBlockSelfType(@NotNull RBlockCall call) {
        if (call == null) {
            RubyTypeProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    public static RType createTypeByRExpressionFromProviders(@NotNull RExpression expression) {
        if (expression == null) {
            RubyTypeProvider.$$$reportNull$$$0(4);
        }
        for (RubyTypeProvider provider : EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            RType type = provider.createTypeByRExpression(expression);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public static RType createTypeBySymbolFromProviders(@NotNull Symbol symbol, @NotNull List<RType> typeArguments) {
        if (symbol == null) {
            RubyTypeProvider.$$$reportNull$$$0(5);
        }
        if (typeArguments == null) {
            RubyTypeProvider.$$$reportNull$$$0(6);
        }
        for (RubyTypeProvider provider : EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            RType type = provider.createTypeBySymbol(symbol, typeArguments);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @Nullable
    public static RType getBlockSelfTypeFromProviders(@NotNull RBlockCall call) {
        if (call == null) {
            RubyTypeProvider.$$$reportNull$$$0(7);
        }
        for (RubyTypeProvider provider : EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            RType type = provider.getBlockSelfType(call);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/RubyTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeBySymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeByRExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockSelfType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeByRExpressionFromProviders";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeBySymbolFromProviders";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockSelfTypeFromProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

