/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolInheritanceInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;

public interface Symbol {
    @Nullable
    public String getName();

    @NotNull
    public FQN getFQNWithNesting();

    @NotNull
    public Type getType();

    @Nullable
    public Symbol getParentSymbol();

    @Nullable
    default public Symbol getSingletonClassSymbol() {
        return null;
    }

    @NotNull
    default public SymbolInheritanceInfo getInheritanceInfo(@Nullable PsiElement invocationPoint) {
        SymbolInheritanceInfo symbolInheritanceInfo = SymbolInheritanceInfo.EMPTY;
        if (symbolInheritanceInfo == null) {
            Symbol.$$$reportNull$$$0(0);
        }
        return symbolInheritanceInfo;
    }

    @Nullable
    public Icon getExplicitIcon();

    @Nullable
    public PsiElement getPsiElement();

    @NotNull
    public Collection<? extends PsiElement> getAllDeclarations(@Nullable PsiElement var1);

    public boolean processChildren(SymbolPsiProcessor var1, PsiElement var2);

    @Nullable
    public Module getModule();

    @NotNull
    public Project getProject();

    default public boolean isCacheable() {
        return !this.isSynthetic();
    }

    default public boolean isResolvable() {
        return true;
    }

    default public boolean isSynthetic() {
        return false;
    }

    @Nullable
    public static Symbol getSymbolByFilter(@NotNull Symbol symbol, final @NotNull Predicate<Symbol> filter, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            Symbol.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            Symbol.$$$reportNull$$$0(2);
        }
        final Ref result = new Ref();
        symbol.processChildren(new SymbolPsiProcessor(){

            @Override
            public @Nullable Filter getFilter() {
                return (Filter)ObjectUtils.tryCast((Object)filter, Filter.class);
            }

            @Override
            @Nullable
            public String getName() {
                return (String)ObjectUtils.doIfCast((Object)filter, Filter.class, Filter::getName);
            }

            @Override
            public boolean process(@NotNull Symbol symbol) {
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (filter.test(symbol)) {
                    result.set((Object)symbol);
                }
                return result.isNull();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/Symbol$1", "process"));
            }
        }, invocationPoint);
        return (Symbol)result.get();
    }

    @NotNull
    public static List<Symbol> getSymbolsByFilter(@NotNull Symbol symbol, final @NotNull Predicate<Symbol> filter, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            Symbol.$$$reportNull$$$0(3);
        }
        if (filter == null) {
            Symbol.$$$reportNull$$$0(4);
        }
        SmartList result = new SmartList();
        symbol.processChildren(new SymbolPsiProcessor(){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            @Override
            @Nullable
            public Filter getFilter() {
                return (Filter)ObjectUtils.tryCast((Object)filter, Filter.class);
            }

            @Override
            @Nullable
            public String getName() {
                return (String)ObjectUtils.doIfCast((Object)filter, Filter.class, Filter::getName);
            }

            @Override
            public boolean process(@NotNull Symbol symbol) {
                if (symbol == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (filter.test(symbol)) {
                    this.val$result.add(symbol);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/Symbol$2", "process"));
            }
        }, invocationPoint);
        SmartList smartList = result;
        if (smartList == null) {
            Symbol.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    public static void processSymbolsByFilter(@NotNull Symbol symbol, final @NotNull Filter filter, @Nullable PsiElement invocationPoint, final @NotNull Consumer<Symbol> symbolConsumer) {
        if (symbol == null) {
            Symbol.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            Symbol.$$$reportNull$$$0(7);
        }
        if (symbolConsumer == null) {
            Symbol.$$$reportNull$$$0(8);
        }
        symbol.processChildren(new SymbolPsiProcessor(){

            @Override
            public @NotNull Filter getFilter() {
                Filter filter2 = filter;
                if (filter2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return filter2;
            }

            @Override
            @Nullable
            public String getName() {
                return filter.myName;
            }

            @Override
            public boolean process(@NotNull Symbol symbol) {
                if (symbol == null) {
                    3.$$$reportNull$$$0(1);
                }
                ProgressManager.checkCanceled();
                if (filter.test(symbol)) {
                    symbolConsumer.accept(symbol);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/Symbol$3";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbol";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFilter";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/Symbol$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }, invocationPoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/Symbol";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritanceInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/Symbol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolsByFilter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolByFilter";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolsByFilter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSymbolsByFilter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    public static final class Filter
    implements Predicate<Symbol> {
        public static final Predicate<Symbol> ACCEPT_ALL = Predicates.alwaysTrue();
        public static final Predicate<Symbol> ACCEPT_NONE = Predicates.alwaysFalse();
        @Nullable
        private final String myName;
        @Nullable
        private final TypeSet myTypes;
        @NotNull
        private final Predicate<Symbol> myPredicate;

        private Filter(@Nullable String name, @Nullable TypeSet types, @NotNull Predicate<Symbol> predicate) {
            if (predicate == null) {
                Filter.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myTypes = types;
            this.myPredicate = predicate;
        }

        public boolean accepts(@NotNull TypeSet types) {
            if (types == null) {
                Filter.$$$reportNull$$$0(1);
            }
            return this.myTypes == null || !this.myTypes.intersect(types).isEmpty();
        }

        @Override
        @NotNull
        public Predicate<Symbol> and(@NotNull Predicate<? super Symbol> predicate) {
            if (predicate == null) {
                Filter.$$$reportNull$$$0(2);
            }
            if (predicate instanceof Filter) {
                Filter filter = (Filter)predicate;
                if (this.myName != null && filter.myName != null && !this.myName.equals(filter.myName)) {
                    Predicate<Symbol> predicate2 = ACCEPT_NONE;
                    if (predicate2 == null) {
                        Filter.$$$reportNull$$$0(3);
                    }
                    return predicate2;
                }
                String name = (String)ObjectUtils.coalesce((Object)this.myName, (Object)filter.myName);
                TypeSet types = this.myTypes != null && filter.myTypes != null ? this.myTypes.intersect(filter.myTypes) : (TypeSet)ObjectUtils.coalesce((Object)this.myTypes, (Object)filter.myTypes);
                return new Filter(name, types, this.myPredicate.and(filter.myPredicate));
            }
            return new Filter(this.myName, this.myTypes, it -> this.test((Symbol)it) && predicate.test((Symbol)it));
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @Override
        @NotNull
        public Predicate<Symbol> negate() {
            return new Filter(null, (TypeSet)ObjectUtils.doIfNotNull((Object)this.myTypes, TypeSet::invert), it -> !this.myPredicate.test((Symbol)it));
        }

        @Override
        @NotNull
        public Predicate<Symbol> or(@NotNull Predicate<? super Symbol> predicate) {
            if (predicate == null) {
                Filter.$$$reportNull$$$0(4);
            }
            if (predicate instanceof Filter) {
                Filter filter = (Filter)predicate;
                String name = this.myName != null && filter.myName != null && this.myName.equals(filter.myName) ? this.myName : null;
                TypeSet types = this.myTypes != null && filter.myTypes != null ? this.myTypes.union(filter.myTypes) : null;
                return new Filter(name, types, this.myPredicate.or(filter.myPredicate));
            }
            Predicate<Symbol> predicate2 = this.myPredicate.or(predicate);
            if (predicate2 == null) {
                Filter.$$$reportNull$$$0(5);
            }
            return predicate2;
        }

        @Override
        public boolean test(@NotNull Symbol symbol) {
            if (symbol == null) {
                Filter.$$$reportNull$$$0(6);
            }
            return this.myPredicate.test(symbol);
        }

        @NotNull
        public static Filter byName(@NotNull String name) {
            if (name == null) {
                Filter.$$$reportNull$$$0(7);
            }
            return new Filter(name, null, it -> name.equals(it.getName()));
        }

        @NotNull
        public static Filter byTypes(@NotNull TypeSet types) {
            if (types == null) {
                Filter.$$$reportNull$$$0(8);
            }
            return new Filter(null, types, it -> types.contains(it.getType()));
        }

        @NotNull
        public static Filter byType(@NotNull Type type) {
            if (type == null) {
                Filter.$$$reportNull$$$0(9);
            }
            return Filter.byTypes(type.asSet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/Symbol$Filter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/Symbol$Filter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "and";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "or";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "and";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "or";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "test";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "byName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "byTypes";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "byType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 5 -> new IllegalStateException(string);
            };
        }
    }
}

