/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn;

class TByteArrayList {
    protected transient byte[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 4;

    public TByteArrayList(int capacity) {
        this._data = new byte[capacity];
        this._pos = 0;
    }

    public void ensureCapacity(int capacity) {
        if (this._data == null) {
            this._data = new byte[Math.max(4, capacity)];
        }
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            byte[] tmp = new byte[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void add(byte val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public byte[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public byte[] toNativeArray(int offset, int len) {
        byte[] rv = new byte[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(byte[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, dest, 0, len);
    }
}

