/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.Processor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.ConstantFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQNBase;

class MethodFQN
extends ConstantFQN {
    @NotNull
    private final String myMethodName;

    MethodFQN(@NotNull List<String> path, byte @NotNull [] colors, boolean isTopLevel, @NotNull String methodName) {
        if (path == null) {
            MethodFQN.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            MethodFQN.$$$reportNull$$$0(1);
        }
        if (colors == null) {
            MethodFQN.$$$reportNull$$$0(2);
        }
        super(path, colors, isTopLevel);
        this.myMethodName = methodName;
    }

    @Override
    @NotNull
    public String getFullPath() {
        String classFQN = super.getFullPath();
        if (classFQN.isEmpty()) {
            String string = this.myMethodName;
            if (string == null) {
                MethodFQN.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = classFQN + "." + this.myMethodName;
        if (string == null) {
            MethodFQN.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = this.myMethodName;
        if (string == null) {
            MethodFQN.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public MethodFQN normalize() {
        ConstantFQN fqn = super.normalize();
        if (fqn == this) {
            MethodFQN methodFQN = this;
            if (methodFQN == null) {
                MethodFQN.$$$reportNull$$$0(6);
            }
            return methodFQN;
        }
        return new MethodFQN(fqn.getRawPath(), fqn.getPathColors(), false, this.myMethodName);
    }

    @Override
    @NotNull
    public Stream<String> asStream() {
        Stream<String> stream = Stream.concat(super.asStream(), Stream.of(this.myMethodName));
        if (stream == null) {
            MethodFQN.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @Override
    @NotNull
    public List<String> asList() {
        List<String> list = this.asStream().collect(Collectors.toList());
        if (list == null) {
            MethodFQN.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public boolean processNestingResolution(@NotNull Processor<? super FQN> processor) {
        if (processor == null) {
            MethodFQN.$$$reportNull$$$0(9);
        }
        Logger.getInstance(MethodFQN.class).warn("Methods can't be used as parent containers for constant resolution. FQN=<" + this.toString() + ">");
        return true;
    }

    @Override
    @NotNull
    public FQN getCallerFQN() {
        if (this.getRawPath().isEmpty()) {
            FQN fQN = INVALID;
            if (fQN == null) {
                MethodFQN.$$$reportNull$$$0(10);
            }
            return fQN;
        }
        return new ConstantFQN(this);
    }

    @Override
    @NotNull
    public FQN getParentFqn() {
        return new ConstantFQN(this);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && Strings.areSameInstance((String)this.myMethodName, (String)((MethodFQN)o).myMethodName);
    }

    @Override
    @NotNull
    protected FQNBase.SerializationFactory getSerializationFactory() {
        SerializationFactory serializationFactory = SerializationFactory.INSTANCE;
        if (serializationFactory == null) {
            MethodFQN.$$$reportNull$$$0(11);
        }
        return serializationFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/MethodFQN";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/MethodFQN";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asStream";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asList";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallerFQN";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processNestingResolution";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 10, 11 -> new IllegalStateException(string);
        };
    }

    static enum SerializationFactory implements FQNBase.SerializationFactory
    {
        INSTANCE;


        @Override
        public void serialize(@NotNull FQN fqn, @NotNull DataOutput output) throws IllegalArgumentException, IOException {
            if (fqn == null) {
                SerializationFactory.$$$reportNull$$$0(0);
            }
            if (output == null) {
                SerializationFactory.$$$reportNull$$$0(1);
            }
            if (!(fqn instanceof MethodFQN)) {
                throw new IllegalArgumentException("unexpected class " + String.valueOf(fqn));
            }
            MethodFQN methodFqn = (MethodFQN)fqn;
            ConstantFQN.SerializationFactory.INSTANCE.serialize(fqn, output);
            output.writeUTF(methodFqn.myMethodName);
        }

        @Override
        public void serialize(@NotNull FQN fqn, @NotNull StubOutputStream stream) throws IllegalArgumentException, IOException {
            if (fqn == null) {
                SerializationFactory.$$$reportNull$$$0(2);
            }
            if (stream == null) {
                SerializationFactory.$$$reportNull$$$0(3);
            }
            if (!(fqn instanceof MethodFQN)) {
                throw new IllegalArgumentException("unexpected class " + String.valueOf(fqn));
            }
            MethodFQN methodFqn = (MethodFQN)fqn;
            ConstantFQN.SerializationFactory.INSTANCE.serialize(fqn, stream);
            stream.writeName(methodFqn.myMethodName);
        }

        @Override
        @NotNull
        public MethodFQN deserialize(@NotNull DataInput input) throws IllegalArgumentException, IOException {
            if (input == null) {
                SerializationFactory.$$$reportNull$$$0(4);
            }
            ConstantFQN fqn = ConstantFQN.SerializationFactory.INSTANCE.deserialize(input);
            String name = (String)FQNBase.INTERNER.intern((Object)StringUtil.notNullize((String)input.readUTF()));
            return new MethodFQN(fqn.getRawPath(), ConstantFQN.createSameColors(fqn.getRawPath().size()), fqn.isToplevel(), name);
        }

        @Override
        @NotNull
        public MethodFQN deserialize(@NotNull StubInputStream stream) throws IllegalArgumentException, IOException {
            if (stream == null) {
                SerializationFactory.$$$reportNull$$$0(5);
            }
            ConstantFQN fqn = ConstantFQN.SerializationFactory.INSTANCE.deserialize(stream);
            String name = (String)FQNBase.INTERNER.intern((Object)StringUtil.notNullize((String)stream.readNameString()));
            return new MethodFQN(fqn.getRawPath(), ConstantFQN.createSameColors(fqn.getRawPath().size()), fqn.isToplevel(), name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/MethodFQN$SerializationFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "serialize";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deserialize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

