/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.ConstantFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQNBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.MethodFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.TByteArrayList;

public interface FQN {
    public static final FQN INVALID = new ConstantFQN(Collections.emptyList(), new byte[0], false);
    public static final String SYMBOL_DELIMITER = "::";

    @NotNull
    @NlsSafe
    public String getFullPath();

    @NotNull
    @NlsSafe
    public String getShortName();

    @NotNull
    public FQN normalize();

    public boolean isToplevel();

    public boolean processNestingResolution(@NotNull Processor<? super FQN> var1);

    @NotNull
    public FQN getCallerFQN();

    @NotNull
    public FQN getParentFqn();

    @NotNull
    public List<String> asList();

    @NotNull
    public Stream<String> asStream();

    @NlsSafe
    public String toString();

    public static boolean same(@NotNull FQN fqn, @Nullable String fqnAsString) {
        if (fqn == null) {
            FQN.$$$reportNull$$$0(0);
        }
        return fqn.getFullPath().equals(fqnAsString);
    }

    @NotNull
    public static FQN of(@NotNull String fqn) {
        if (fqn == null) {
            FQN.$$$reportNull$$$0(1);
        }
        FQN fQN = Builder.fromString(fqn);
        if (fQN == null) {
            FQN.$$$reportNull$$$0(2);
        }
        return fQN;
    }

    @NotNull
    public static FQN of(@NlsSafe @NotNull String first, String ... rest) {
        if (first == null) {
            FQN.$$$reportNull$$$0(3);
        }
        if (rest == null || ArrayUtil.contains(null, (String[])rest)) {
            FQN fQN = INVALID;
            if (fQN == null) {
                FQN.$$$reportNull$$$0(4);
            }
            return fQN;
        }
        if (first.isBlank() || ContainerUtil.or((Object[])rest, String::isBlank)) {
            FQN fQN = INVALID;
            if (fQN == null) {
                FQN.$$$reportNull$$$0(5);
            }
            return fQN;
        }
        if (rest.length == 0) {
            FQN fQN = Builder.fromString(first);
            if (fQN == null) {
                FQN.$$$reportNull$$$0(6);
            }
            return fQN;
        }
        List<String> components = List.of((String[])ArrayUtil.prepend((Object)Strings.trimStart((String)first, (String)SYMBOL_DELIMITER), (Object[])rest));
        boolean isTopLevel = first.startsWith(SYMBOL_DELIMITER);
        FQN fQN = Builder.create(components, isTopLevel);
        if (fQN == null) {
            FQN.$$$reportNull$$$0(7);
        }
        return fQN;
    }

    @NotNull
    public static FQN ofNullable(@Nullable String fqn) {
        FQN fQN = fqn != null ? FQN.of(fqn) : INVALID;
        if (fQN == null) {
            FQN.$$$reportNull$$$0(8);
        }
        return fQN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "ofNullable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "same";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static final class Builder {
        @NotNull
        public static FQN create(@NotNull List<String> fqns, boolean isToplevel) {
            if (fqns == null) {
                Builder.$$$reportNull$$$0(0);
            }
            ArrayList<String> splitted = new ArrayList<String>(fqns.size());
            TByteArrayList bytes = new TByteArrayList(fqns.size());
            byte currentColor = 0;
            for (String fqn : fqns) {
                for (String part : StringUtil.split((String)fqn, (String)FQN.SYMBOL_DELIMITER)) {
                    splitted.add((String)FQNBase.INTERNER.intern((Object)part.trim()));
                    bytes.add(currentColor);
                }
                currentColor = (byte)(currentColor + 1);
            }
            if (splitted.isEmpty()) {
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(1);
                }
                return fQN;
            }
            return new ConstantFQN(splitted, bytes.toNativeArray(), isToplevel);
        }

        @NotNull
        public static FQN fromString(@NotNull String fqn) {
            if (fqn == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (fqn.isEmpty()) {
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(3);
                }
                return fQN;
            }
            Pair<String, Boolean> fqnAndLeading = Builder.checkLeadingDelimiter(fqn);
            if (((String)fqnAndLeading.getFirst()).isEmpty()) {
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(4);
                }
                return fQN;
            }
            Pair<String, String> fqnAndMethod = Builder.checkMethodPresence((String)fqnAndLeading.getFirst());
            if (((Boolean)fqnAndLeading.getSecond()).booleanValue() && StringUtil.isEmpty((String)((String)fqnAndMethod.getFirst()))) {
                Logger.getInstance(Builder.class).warn("FQN can't start with :: and have no CONSTANT: " + fqn, new Throwable());
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(5);
                }
                return fQN;
            }
            if (fqnAndMethod.getSecond() != null) {
                if (fqnAndMethod.getFirst() != null) {
                    List<String> names = Builder.splitIncomingFQN((String)fqnAndMethod.getFirst());
                    return new MethodFQN(names, ConstantFQN.createSameColors(names.size()), (Boolean)fqnAndLeading.getSecond(), (String)FQNBase.INTERNER.intern((Object)((String)fqnAndMethod.getSecond()).trim()));
                }
                return new MethodFQN(Collections.emptyList(), ConstantFQN.createSameColors(0), false, (String)FQNBase.INTERNER.intern((Object)((String)fqnAndMethod.getSecond()).trim()));
            }
            List<String> names = Builder.splitIncomingFQN((String)fqnAndLeading.getFirst());
            return new ConstantFQN(names, ConstantFQN.createSameColors(names.size()), (Boolean)fqnAndLeading.getSecond());
        }

        @NotNull
        public static FQN forceConcat(@NotNull FQN fqn1, @NotNull FQN fqn2) {
            if (fqn1 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            if (fqn2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            if (fqn1 == INVALID) {
                FQN fQN = fqn2;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(8);
                }
                return fQN;
            }
            if (fqn2 == INVALID) {
                FQN fQN = fqn1;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(9);
                }
                return fQN;
            }
            List newPath = ContainerUtil.concat(Builder.getRawPath(fqn1), Builder.getRawPath(fqn2));
            byte[] newColors = Builder.concatColors(fqn1, fqn2);
            if (fqn2 instanceof MethodFQN) {
                return new MethodFQN(newPath, newColors, fqn1.isToplevel(), fqn2.getShortName());
            }
            return new ConstantFQN(newPath, newColors, fqn1.isToplevel());
        }

        @NotNull
        public static FQN concat(@NotNull FQN fqn1, @NotNull String fqnAsString) {
            if (fqn1 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            if (fqnAsString == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return Builder.concat(fqn1, Builder.fromString(fqnAsString));
        }

        @NotNull
        private static Pair<String, Boolean> checkLeadingDelimiter(@NotNull String fqn) {
            if (fqn == null) {
                Builder.$$$reportNull$$$0(12);
            }
            if (fqn.startsWith(FQN.SYMBOL_DELIMITER)) {
                Pair pair = Pair.create((Object)fqn.substring(2), (Object)true);
                if (pair == null) {
                    Builder.$$$reportNull$$$0(13);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)fqn, (Object)false);
            if (pair == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return pair;
        }

        @NotNull
        private static Pair<String, String> checkMethodPresence(@NotNull String fqn) {
            if (fqn == null) {
                Builder.$$$reportNull$$$0(15);
            }
            assert (!fqn.isEmpty());
            int i = fqn.lastIndexOf(".");
            if (i != -1) {
                Pair pair = Pair.create((Object)fqn.substring(0, i), (Object)fqn.substring(i + 1));
                if (pair == null) {
                    Builder.$$$reportNull$$$0(16);
                }
                return pair;
            }
            if (Character.isUpperCase(fqn.charAt(0)) || fqn.contains(FQN.SYMBOL_DELIMITER) || fqn.startsWith("$$")) {
                Pair pair = Pair.create((Object)fqn, null);
                if (pair == null) {
                    Builder.$$$reportNull$$$0(17);
                }
                return pair;
            }
            Pair pair = Pair.create(null, (Object)fqn);
            if (pair == null) {
                Builder.$$$reportNull$$$0(18);
            }
            return pair;
        }

        @NotNull
        public static FQN concat(@NotNull FQN fqn1, @NotNull FQN fqn2) {
            if (fqn1 == null) {
                Builder.$$$reportNull$$$0(19);
            }
            if (fqn2 == null) {
                Builder.$$$reportNull$$$0(20);
            }
            if (fqn1 instanceof MethodFQN) {
                Logger.getInstance(Builder.class).warn("Cannot append anything to method fqn: " + String.valueOf(fqn1) + "+" + String.valueOf(fqn2) + ". Check caller code.");
                FQN fQN = INVALID;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(21);
                }
                return fQN;
            }
            if (fqn2.isToplevel()) {
                FQN fQN = fqn2;
                if (fQN == null) {
                    Builder.$$$reportNull$$$0(22);
                }
                return fQN;
            }
            return Builder.forceConcat(fqn1, fqn2);
        }

        @NotNull
        private static List<String> splitIncomingFQN(@NotNull String fqnAsString) {
            if (fqnAsString == null) {
                Builder.$$$reportNull$$$0(23);
            }
            if (fqnAsString.isBlank()) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    Builder.$$$reportNull$$$0(24);
                }
                return list;
            }
            if (!fqnAsString.contains(FQN.SYMBOL_DELIMITER)) {
                List<String> list = List.of((String)FQNBase.INTERNER.intern((Object)fqnAsString.trim()));
                if (list == null) {
                    Builder.$$$reportNull$$$0(25);
                }
                return list;
            }
            List list = ContainerUtil.map((Collection)StringUtil.split((String)fqnAsString, (String)FQN.SYMBOL_DELIMITER), it -> (String)FQNBase.INTERNER.intern((Object)it.trim()));
            if (list == null) {
                Builder.$$$reportNull$$$0(26);
            }
            return list;
        }

        @NotNull
        private static List<String> getRawPath(@NotNull FQN fqn) {
            if (fqn == null) {
                Builder.$$$reportNull$$$0(27);
            }
            if (fqn instanceof ConstantFQN) {
                List<String> list = ((ConstantFQN)fqn).getRawPath();
                if (list == null) {
                    Builder.$$$reportNull$$$0(28);
                }
                return list;
            }
            List<String> list = Collections.emptyList();
            if (list == null) {
                Builder.$$$reportNull$$$0(29);
            }
            return list;
        }

        private static byte @NotNull [] concatColors(@NotNull FQN fqn1, @NotNull FQN fqn2) {
            if (fqn1 == null) {
                Builder.$$$reportNull$$$0(30);
            }
            if (fqn2 == null) {
                Builder.$$$reportNull$$$0(31);
            }
            byte[] c1 = ((FQNBase)fqn1).getPathColors();
            byte[] c2 = ((FQNBase)fqn2).getPathColors();
            int L1 = c1.length;
            byte[] result = new byte[L1 + c2.length];
            System.arraycopy(c1, 0, result, 0, L1);
            byte delta = L1 == 0 ? (byte)0 : c1[L1 - 1];
            for (int i = 0; i < c2.length; ++i) {
                result[L1 + i] = (byte)(c2[i] + 1 + delta);
            }
            if (result == null) {
                Builder.$$$reportNull$$$0(32);
            }
            return result;
        }

        @NotNull
        public static FQN appendConstant(@NotNull FQN origin, @NotNull FQN constant) {
            if (origin == null) {
                Builder.$$$reportNull$$$0(33);
            }
            if (constant == null) {
                Builder.$$$reportNull$$$0(34);
            }
            if (origin instanceof MethodFQN) {
                MethodFQN methodFQN = (MethodFQN)origin;
                return Builder.concat(Builder.concat(methodFQN.getCallerFQN(), constant), methodFQN.getShortName());
            }
            return Builder.concat(origin, constant);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4, 5, 8, 9, 13, 14, 16, 17, 18, 21, 22, 24, 25, 26, 28, 29, 32 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqns";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN$Builder";
                    break;
                }
                case 2: 
                case 12: 
                case 15: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 6: 
                case 10: 
                case 19: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn1";
                    break;
                }
                case 7: 
                case 20: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn2";
                    break;
                }
                case 11: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqnAsString";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origin";
                    break;
                }
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forceConcat";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkLeadingDelimiter";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "checkMethodPresence";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "concat";
                    break;
                }
                case 24: 
                case 25: 
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "splitIncomingFQN";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRawPath";
                    break;
                }
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "concatColors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 13: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 22: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 32: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "forceConcat";
                    break;
                }
                case 10: 
                case 11: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "concat";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "checkLeadingDelimiter";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "checkMethodPresence";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "splitIncomingFQN";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "getRawPath";
                    break;
                }
                case 30: 
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "concatColors";
                    break;
                }
                case 33: 
                case 34: {
                    objectArray = objectArray;
                    objectArray[2] = "appendConstant";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4, 5, 8, 9, 13, 14, 16, 17, 18, 21, 22, 24, 25, 26, 28, 29, 32 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Serialization {
        private static final FQNBase.SerializationFactory[] FACTORIES = new FQNBase.SerializationFactory[]{ConstantFQN.SerializationFactory.INSTANCE, MethodFQN.SerializationFactory.INSTANCE};
        private static final Map<FQNBase.SerializationFactory, Integer> FACTORY_TO_ID = new HashMap<FQNBase.SerializationFactory, Integer>();

        public static void serialize(@NotNull FQN fqn, @NotNull DataOutput output) throws IOException {
            if (fqn == null) {
                Serialization.$$$reportNull$$$0(0);
            }
            if (output == null) {
                Serialization.$$$reportNull$$$0(1);
            }
            if (fqn == INVALID) {
                output.writeByte(-1);
                return;
            }
            FQNBase.SerializationFactory factory = ((FQNBase)fqn).getSerializationFactory();
            output.writeByte(FACTORY_TO_ID.get(factory));
            factory.serialize(fqn, output);
        }

        public static void serialize(@NotNull FQN fqn, @NotNull StubOutputStream stream) throws IOException {
            if (fqn == null) {
                Serialization.$$$reportNull$$$0(2);
            }
            if (stream == null) {
                Serialization.$$$reportNull$$$0(3);
            }
            if (fqn == INVALID) {
                stream.writeByte(-1);
                return;
            }
            FQNBase.SerializationFactory serializationFactory = ((FQNBase)fqn).getSerializationFactory();
            stream.writeByte(FACTORY_TO_ID.get(serializationFactory).intValue());
            serializationFactory.serialize(fqn, stream);
        }

        @NotNull
        public static FQN deserialize(@NotNull DataInput input) throws IOException {
            byte b;
            if (input == null) {
                Serialization.$$$reportNull$$$0(4);
            }
            if ((b = input.readByte()) == -1) {
                FQN fQN = INVALID;
                if (fQN == null) {
                    Serialization.$$$reportNull$$$0(5);
                }
                return fQN;
            }
            FQN fQN = FACTORIES[b].deserialize(input);
            if (fQN == null) {
                Serialization.$$$reportNull$$$0(6);
            }
            return fQN;
        }

        @NotNull
        public static FQN deserialize(@NotNull StubInputStream stream) throws IOException {
            byte b;
            if (stream == null) {
                Serialization.$$$reportNull$$$0(7);
            }
            if ((b = stream.readByte()) == -1) {
                FQN fQN = INVALID;
                if (fQN == null) {
                    Serialization.$$$reportNull$$$0(8);
                }
                return fQN;
            }
            FQN fQN = FACTORIES[b].deserialize(stream);
            if (fQN == null) {
                Serialization.$$$reportNull$$$0(9);
            }
            return fQN;
        }

        static {
            for (int i = 0; i < FACTORIES.length; ++i) {
                FACTORY_TO_ID.put(FACTORIES[i], i);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 8, 9 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN$Serialization";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/fqn/FQN$Serialization";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "deserialize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "serialize";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "deserialize";
                    break;
                }
                case 5: 
                case 6: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 8, 9 -> new IllegalStateException(string);
            };
        }
    }
}

