/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;

public class TypeSet {
    public static final TypeSet EMPTY = new TypeSet(new Type[0]);
    private long myMask;

    public TypeSet(Type ... types) {
        for (Type type : types) {
            this.myMask |= 1L << type.getId();
        }
    }

    public boolean contains(@Nullable Type type) {
        return type != null && (this.myMask & 1L << type.getId()) != 0L;
    }

    @NotNull
    public TypeSet difference(TypeSet typeSet) {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask & (typeSet.myMask ^ 0xFFFFFFFFFFFFFFFFL);
        TypeSet typeSet2 = result;
        if (typeSet2 == null) {
            TypeSet.$$$reportNull$$$0(0);
        }
        return typeSet2;
    }

    @NotNull
    public TypeSet invert() {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask ^ 0xFFFFFFFFFFFFFFFFL;
        TypeSet typeSet = result;
        if (typeSet == null) {
            TypeSet.$$$reportNull$$$0(1);
        }
        return typeSet;
    }

    public TypeSet union(Type ... types) {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask;
        for (Type type : types) {
            result.myMask |= 1L << type.getId();
        }
        return result;
    }

    public TypeSet union(TypeSet typeSet) {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask | typeSet.myMask;
        return result;
    }

    public TypeSet intersect(TypeSet typeSet) {
        TypeSet result = new TypeSet(new Type[0]);
        result.myMask = this.myMask & typeSet.myMask;
        return result;
    }

    public boolean isEmpty() {
        return this.myMask == 0L;
    }

    public String toString() {
        @NonNls StringBuilder result = new StringBuilder("TypeSet(");
        boolean first = true;
        for (int bit = 0; bit < 63; ++bit) {
            long mask = 1L << bit;
            if ((this.myMask & mask) == 0L) continue;
            if (first) {
                first = false;
            } else {
                result.append(",");
            }
            result.append(((Type)Type.ourIdToTypeMap.get(bit)).getDebugName());
        }
        result.append(")");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSet typeSet = (TypeSet)o;
        return this.myMask == typeSet.myMask;
    }

    public int hashCode() {
        return Long.hashCode(this.myMask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/TypeSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "difference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "invert";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

