/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.xml.XmlTagDelegate;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.CharTable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.psi.SlimElementTypes;
import org.jetbrains.plugins.slim.psi.impl.SlimClassOrIdImpl;

public final class SlimTagImpl
extends XmlTagImpl
implements HtmlTag {
    public SlimTagImpl() {
        super(SlimElementTypes.SLIM_TAG);
    }

    @NotNull
    public String getName() {
        String name = super.getName();
        return !StringUtil.isEmpty((String)name) ? name : "div";
    }

    public String toString() {
        return "SlimTag:" + this.getName();
    }

    public XmlAttribute getAttribute(String qname) {
        if (qname == null) {
            return null;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)this);
        XmlAttribute[] attributes = this.getAttributes();
        CharSequence charTableIndex = charTableByTree.intern((CharSequence)qname);
        boolean caseSensitive = this.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            CharSequence name;
            ASTNode attrNameElement = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            CharSequence charSequence = attrNameElement instanceof SlimClassOrIdImpl ? charTableByTree.intern((CharSequence)attribute.getLocalName()) : (name = attrNameElement != null ? attrNameElement.getChars() : null);
            if (name == null || (!caseSensitive || !name.equals(charTableIndex)) && (caseSensitive || !Comparing.equal((CharSequence)name, (CharSequence)charTableIndex, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    @NotNull
    protected XmlTagDelegate createDelegate() {
        return new SlimTagImplDelegate();
    }

    private final class SlimTagImplDelegate
    extends XmlTagImpl.XmlTagImplDelegate {
        private SlimTagImplDelegate() {
            super((XmlTagImpl)SlimTagImpl.this);
        }

        protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
            if (name.equals("class")) {
                XmlAttribute[] attributes = SlimTagImpl.this.getAttributes();
                StringBuilder attributeValue = new StringBuilder();
                for (XmlAttribute attribute : attributes) {
                    if (!attribute.getName().equals("class")) continue;
                    attributeValue.append(attribute.getValue()).append(' ');
                }
                attributesValueMap.put(name, attributeValue.toString().trim());
            } else {
                super.cacheOneAttributeValue(name, value, attributesValueMap);
            }
        }
    }
}

