/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.xml.XmlDoctypeImpl;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;

public final class SlimDoctypeImpl
extends XmlDoctypeImpl
implements XmlProlog {
    private static final Map<String, String> DOCTYPE_TO_DTD;

    public String getDtdUri() {
        ASTNode type = this.findChildByType(SlimTokenTypes.DOCTYPE);
        return type == null ? null : DOCTYPE_TO_DTD.get(StringUtil.toLowerCase((String)type.getText()));
    }

    protected PsiReference createUrlReference(PsiElement dtdUrlElement) {
        return new PsiReferenceBase.Immediate<PsiElement>(this, dtdUrlElement, TextRange.from((int)0, (int)dtdUrlElement.getTextLength()), (PsiElement)this){

            public Object @NotNull [] getVariants() {
                Object[] objectArray = ArrayUtil.toObjectArray(DOCTYPE_TO_DTD.keySet());
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/slim/psi/impl/SlimDoctypeImpl$1", "getVariants"));
            }
        };
    }

    public PsiElement getDtdUrlElement() {
        return this.findPsiChildByType(SlimTokenTypes.DOCTYPE);
    }

    public XmlElement getNameElement() {
        return this;
    }

    public XmlDoctype getDoctype() {
        return this;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("html", null);
        map.put("5", null);
        map.put("1.1", "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
        map.put("strict", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        map.put("frameset", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
        map.put("mobile", "http://www.openmobilealliance.org/tech/DTD/xhtml-mobile12.dtd");
        map.put("basic", "http://www.w3.org/TR/xhtml-basic/xhtml-basic11.dtd");
        map.put("transitional", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        DOCTYPE_TO_DTD = Collections.unmodifiableMap(map);
    }
}

