/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ParsingDiagnostics;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.SlimLanguage;
import org.jetbrains.plugins.slim.SlimOuterLanguageProvider;
import org.jetbrains.plugins.slim.SlimParserDefinition;
import org.jetbrains.plugins.slim.lexer.SlimLexer;
import org.jetbrains.plugins.slim.parser.SlimParser;
import org.jetbrains.plugins.slim.parser.SlimPsiBuilder;
import org.jetbrains.plugins.slim.psi.SlimLanguageLevel;

public class SlimFileElementType
extends IStubFileElementType {
    public static final IFileElementType SLIM_FILE = new SlimFileElementType();

    public SlimFileElementType() {
        super((Language)SlimLanguage.INSTANCE);
    }

    private static SlimLanguageLevel detectLanguageLevel(@NotNull PsiElement psiElement) {
        PsiFile psiFile;
        VirtualFile virtualFile;
        if (psiElement == null) {
            SlimFileElementType.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile2 = virtualFile = (psiFile = psiElement.getContainingFile()) != null ? psiFile.getVirtualFile() : null;
        if (virtualFile != null) {
            for (SlimOuterLanguageProvider outerLanguageProvider : SlimOuterLanguageProvider.getProviders()) {
                SlimLanguageLevel result = outerLanguageProvider.detectLanguageLevel(psiElement.getProject(), virtualFile);
                if (result == null) continue;
                return result;
            }
        }
        return SlimLanguageLevel.DEFAULT;
    }

    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            SlimFileElementType.$$$reportNull$$$0(1);
        }
        if (psi == null) {
            SlimFileElementType.$$$reportNull$$$0(2);
        }
        Project project = psi.getProject();
        SlimLanguageLevel languageLevel = SlimFileElementType.detectLanguageLevel(psi);
        SlimLexer lexer = new SlimLexer(languageLevel, true);
        SlimParserDefinition parserDefinition = new SlimParserDefinition();
        SlimPsiBuilder builder = new SlimPsiBuilder(project, parserDefinition, (Lexer)lexer, chameleon, chameleon.getChars());
        long startTime = System.nanoTime();
        SlimParser parser = (SlimParser)parserDefinition.createParser(project);
        ASTNode result = parser.parse((IElementType)this, (PsiBuilder)builder).getFirstChildNode();
        ParsingDiagnostics.registerParse((PsiBuilder)builder, (Language)this.getLanguage(), (long)(System.nanoTime() - startTime));
        return result;
    }

    @NotNull
    public String getExternalId() {
        String string = this.getLanguage().getID() + ".file";
        if (string == null) {
            SlimFileElementType.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chameleon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/slim/psi/SlimFileElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/slim/psi/SlimFileElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectLanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doParseContents";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

