/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.SlimHighlighter;
import org.jetbrains.plugins.slim.SlimLanguage;
import org.jetbrains.plugins.slim.lexer.SlimLexer;
import org.jetbrains.plugins.slim.psi.SlimLanguageLevel;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;

public class SlimSyntaxHighlighter
extends SyntaxHighlighterBase
implements SlimTokenTypes {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    private static final Map<Language, SyntaxHighlighter> ourEmbeddedLanguageToHighlighterMap = new ConcurrentHashMap<Language, SyntaxHighlighter>();

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey ownResult = ATTRIBUTES.get(tokenType);
        if (tokenType.getLanguage() == SlimLanguage.INSTANCE || ownResult != null) {
            TextAttributesKey[] textAttributesKeyArray = SlimSyntaxHighlighter.pack((TextAttributesKey)ownResult);
            if (textAttributesKeyArray == null) {
                SlimSyntaxHighlighter.$$$reportNull$$$0(0);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = SlimSyntaxHighlighter.getHighlighterForLanguage(tokenType.getLanguage()).getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            SlimSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    private static SyntaxHighlighter getHighlighterForLanguage(@NotNull Language language) {
        SyntaxHighlighter result;
        if (language == null) {
            SlimSyntaxHighlighter.$$$reportNull$$$0(2);
        }
        if ((result = ourEmbeddedLanguageToHighlighterMap.get(language)) == null) {
            result = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, null, null);
            ourEmbeddedLanguageToHighlighterMap.put(language, result);
        }
        SyntaxHighlighter syntaxHighlighter = result;
        if (syntaxHighlighter == null) {
            SlimSyntaxHighlighter.$$$reportNull$$$0(3);
        }
        return syntaxHighlighter;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new SlimLexer(SlimLanguageLevel.DEFAULT, false);
    }

    static {
        ATTRIBUTES.put(SlimTokenTypes.TAG, SlimHighlighter.TAG);
        ATTRIBUTES.put(SlimTokenTypes.CLASS, SlimHighlighter.CLASS);
        ATTRIBUTES.put(SlimTokenTypes.CLASS_START, SlimHighlighter.CLASS);
        ATTRIBUTES.put(SlimTokenTypes.ID, SlimHighlighter.ID);
        ATTRIBUTES.put(SlimTokenTypes.ID_START, SlimHighlighter.ID);
        ATTRIBUTES.put(SlimTokenTypes.CODE_COMMENT, SlimHighlighter.COMMENT);
        ATTRIBUTES.put(SlimTokenTypes.HTML_COMMENT, SlimHighlighter.COMMENT);
        ATTRIBUTES.put(SlimTokenTypes.CONDITIONAL_COMMENT, SlimHighlighter.COMMENT);
        ATTRIBUTES.put(SlimTokenTypes.DOCTYPE_KWD, SlimHighlighter.DOCTYPE_KWD);
        ATTRIBUTES.put(SlimTokenTypes.INTERPOLATION_START, SlimHighlighter.INTERPOLATION);
        ATTRIBUTES.put(SlimTokenTypes.INTERPOLATION_END, SlimHighlighter.INTERPOLATION);
        ATTRIBUTES.put(SlimTokenTypes.UNESCAPED_INTERPOLATION_START, SlimHighlighter.INTERPOLATION);
        ATTRIBUTES.put(SlimTokenTypes.UNESCAPED_INTERPOLATION_END, SlimHighlighter.INTERPOLATION);
        ATTRIBUTES.put(SlimTokenTypes.STATIC_CONTENT_START, SlimHighlighter.STATIC_CONTENT);
        ATTRIBUTES.put(SlimTokenTypes.ESCAPED_CALL, SlimHighlighter.CALL);
        ATTRIBUTES.put(SlimTokenTypes.UNESCAPED_CALL, SlimHighlighter.CALL);
        ATTRIBUTES.put(SlimTokenTypes.CONTROL_CODE_START, SlimHighlighter.CALL);
        ATTRIBUTES.put(SlimTokenTypes.RUBY_CODE, SlimHighlighter.INJECTED_CODE);
        ATTRIBUTES.put(SlimTokenTypes.BAD_CHARACTER, SlimHighlighter.BAD_CHARACTER);
        ATTRIBUTES.put(SlimTokenTypes.OPEN_BRACE, SlimHighlighter.PARENTHS);
        ATTRIBUTES.put(SlimTokenTypes.CLOSE_BRACE, SlimHighlighter.PARENTHS);
        ATTRIBUTES.put(SlimTokenTypes.FILTER, SlimHighlighter.FILTER);
        ATTRIBUTES.put(SlimTokenTypes.FILTER_CONTENT, SlimHighlighter.FILTER_CONTENT);
        ATTRIBUTES.put(SlimTokenTypes.STRING_LITERAL, SlimHighlighter.STRING_INTERPOLATED);
        ATTRIBUTES.put(SlimTokenTypes.STATIC_CONTENT, SlimHighlighter.STATIC_CONTENT);
        ATTRIBUTES.put(DOCTYPE, DefaultLanguageHighlighterColors.IDENTIFIER);
        ATTRIBUTES.put(ATTR_NAME, DefaultLanguageHighlighterColors.IDENTIFIER);
        ATTRIBUTES.put(EQUALS, DefaultLanguageHighlighterColors.OPERATION_SIGN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/slim/SlimSyntaxHighlighter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/slim/SlimSyntaxHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighterForLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighterForLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

