/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.javascript.rails.stimulus;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.ruby.javascript.rails.stimulus.StimulusControllerUtil;
import com.intellij.ruby.javascript.rails.stimulus.StimulusJSReference;
import com.intellij.ruby.javascript.rails.stimulus.StimulusReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;

public final class StimulusReferenceSearch
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public static final short SEARCH_CONTEXT = 4;

    public StimulusReferenceSearch() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters params, @NotNull Processor<? super PsiReference> consumer) {
        String searchWord;
        PsiElement element;
        PsiFile containingFile;
        if (params == null) {
            StimulusReferenceSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            StimulusReferenceSearch.$$$reportNull$$$0(1);
        }
        if ((containingFile = (element = params.getElementToSearch()).getContainingFile()) == null || !(containingFile.getLanguage() instanceof JSLanguageDialect) || !StimulusControllerUtil.isInStimulusControllerFiles(containingFile)) {
            return;
        }
        if (element instanceof JSFile) {
            JSFile jsFile = (JSFile)element;
            searchWord = StimulusControllerUtil.getControllerNameFromFile(jsFile.getName());
        } else if (element instanceof JSFunction) {
            JSFunction jsFunction = (JSFunction)element;
            searchWord = jsFunction.getName();
        } else if (element instanceof JSProperty) {
            JSProperty jsProperty = (JSProperty)element;
            searchWord = jsProperty.getName();
        } else if (element instanceof JSLiteralExpression) {
            JSLiteralExpression jsLiteral = (JSLiteralExpression)element;
            searchWord = jsLiteral.getStringValue();
        } else {
            return;
        }
        if (searchWord == null) {
            return;
        }
        RailsApp railsApp = RailsApp.fromPsiElement((PsiElement)element);
        if (railsApp == null) {
            return;
        }
        GlobalSearchScope searchScope = GlobalSearchScopesCore.directoriesScope((Project)element.getProject(), (boolean)true, (VirtualFile[])railsApp.getPaths().findFiles("app").toArray(VirtualFile.EMPTY_ARRAY));
        String searchText = StimulusControllerUtil.dasherize(searchWord);
        params.getOptimizer().searchWord(searchText, (SearchScope)searchScope, (short)4, true, element, (RequestResultProcessor)new MyRequestResultProcessor(element, searchText));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "params";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceSearch";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyRequestResultProcessor
    extends RequestResultProcessor {
        private final PsiElement myElement;
        private final String myText;

        private MyRequestResultProcessor(@NotNull PsiElement element, @NotNull String text) {
            if (element == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(0);
            }
            if (text == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(1);
            }
            super(new Object[]{element});
            this.myElement = element;
            this.myText = text;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            RStringLiteral literal;
            if (element == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(3);
            }
            if (element instanceof RStringLiteral && (literal = (RStringLiteral)element).getText().contains(this.myText)) {
                return this.processReferences((PsiElement)literal, consumer);
            }
            if (element instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element).getStringValue() != null && literal.getStringValue().equals(this.myText)) {
                return this.processReferences((PsiElement)literal, consumer);
            }
            return true;
        }

        private boolean processReferences(@NotNull PsiElement element, @NotNull Processor<? super PsiReference> processor) {
            if (element == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(4);
            }
            if (processor == null) {
                MyRequestResultProcessor.$$$reportNull$$$0(5);
            }
            List references = PsiReferenceService.getService().getReferences(element, PsiReferenceService.Hints.NO_HINTS);
            for (PsiReference reference : ContainerUtil.filter((Collection)references, ref -> ref instanceof StimulusReference || ref instanceof StimulusJSReference)) {
                if (!reference.isReferenceTo(this.myElement) || processor.process((Object)reference)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusReferenceSearch$MyRequestResultProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTextOccurrence";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processReferences";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

