/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.javascript.rails.stimulus;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.ruby.javascript.rails.stimulus.StimulusControllerUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StimulusJSReference
extends PsiPolyVariantReferenceBase<PsiElement> {
    public StimulusJSReference(@NotNull PsiElement element, @NotNull TextRange rangeInElement, boolean soft) {
        if (element == null) {
            StimulusJSReference.$$$reportNull$$$0(0);
        }
        if (rangeInElement == null) {
            StimulusJSReference.$$$reportNull$$$0(1);
        }
        super(element, rangeInElement, soft);
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        String newControllerName;
        if (newElementName == null) {
            StimulusJSReference.$$$reportNull$$$0(2);
        }
        if ((newControllerName = StimulusControllerUtil.getControllerNameFromFile(newElementName)) == null) {
            return null;
        }
        String newElementText = StringUtil.wrapWithDoubleQuote((String)newControllerName);
        JSExpression newElement = JSPsiElementFactory.createJSExpression((String)newElementText, (PsiElement)this.myElement);
        this.myElement.replace((PsiElement)newElement);
        return newElement;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                StimulusJSReference.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        JSLiteralExpression literal = (JSLiteralExpression)this.myElement;
        String controllerName = literal.getStringValue();
        if (controllerName == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                StimulusJSReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = StimulusControllerUtil.getControllerClassByName(controllerName, module, this.myElement.getResolveScope()).stream().map(PsiElement::getContainingFile).map(PsiElementResolveResult::new).toList().toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            StimulusJSReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/javascript/rails/stimulus/StimulusJSReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusJSReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

