/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ruby.javascript.rails.stimulus;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.javascript.rails.stimulus.StimulusControllerNameIndex;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class StimulusControllerUtil {
    public static final ElementPattern<? extends PsiElement> DATA_PATTERN = PlatformPatterns.psiElement(RAssoc.class).with((PatternCondition)new PatternCondition<RAssoc>("dataAssoc"){

        public boolean accepts(@NotNull RAssoc assoc, @Nullable ProcessingContext context) {
            if (assoc == null) {
                1.$$$reportNull$$$0(0);
            }
            return assoc.getKeyText().equals("data") && assoc.getValue() instanceof RAssocList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assoc", "com/intellij/ruby/javascript/rails/stimulus/StimulusControllerUtil$1", "accepts"));
        }
    });
    public static final ElementPattern<? extends PsiFile> TEMPLATE_FILE_PATTERN = PlatformPatterns.psiFile().with((PatternCondition)new PatternCondition<PsiFile>("templateFile"){

        public boolean accepts(@NotNull PsiFile psiFile, @Nullable ProcessingContext context) {
            if (psiFile == null) {
                2.$$$reportNull$$$0(0);
            }
            return psiFile.getViewProvider() instanceof TemplateLanguageFileViewProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ruby/javascript/rails/stimulus/StimulusControllerUtil$2", "accepts"));
        }
    });
    public static final ElementPattern<? extends PsiElement> JS_REGISTER_CALL_PATTERN = PlatformPatterns.psiElement(JSCallExpression.class).with((PatternCondition)new PatternCondition<JSCallExpression>("registerCall"){

        public boolean accepts(@NotNull JSCallExpression expression, @Nullable ProcessingContext context) {
            JSReferenceExpression referenceExpression;
            JSExpression jSExpression;
            if (expression == null) {
                3.$$$reportNull$$$0(0);
            }
            return (jSExpression = expression.getMethodExpression()) instanceof JSReferenceExpression && (referenceExpression = (JSReferenceExpression)jSExpression).getReferenceName() != null && referenceExpression.getReferenceName().contains("register");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/ruby/javascript/rails/stimulus/StimulusControllerUtil$3", "accepts"));
        }
    });
    private static final String CONTROLLERS_PATH = "javascript/controllers";
    private static final Set<String> CONTROLLER_FILE_SUFFIXES = Set.of("_controller.js", "-controller.js", "_controller.ts", "-controller.ts");

    private StimulusControllerUtil() {
    }

    @NotNull
    public static List<JSClass> getControllerClassByName(@NotNull String name, @NotNull Module module, @NotNull GlobalSearchScope searchScope) {
        if (name == null) {
            StimulusControllerUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            StimulusControllerUtil.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            StimulusControllerUtil.$$$reportNull$$$0(2);
        }
        Project project = module.getProject();
        List<VirtualFile> directories = StimulusControllerUtil.getControllerDirectories(module);
        List<JSClass> controllersFromIndex = StimulusControllerUtil.getControllerIndexFiles(module).stream().flatMap(file -> FileBasedIndex.getInstance().getFileData(StimulusControllerNameIndex.KEY, file, project).entrySet().stream()).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals(name)).map(entry -> (String)entry.getValue()).flatMap(filename -> directories.stream().map(dir -> dir.findChild(filename))).filter(Objects::nonNull).filter(file -> searchScope.contains(file)).map(file -> PsiManager.getInstance((Project)project).findFile(file)).flatMap(file -> PsiTreeUtil.findChildrenOfType((PsiElement)file, JSClass.class).stream()).toList();
        if (!controllersFromIndex.isEmpty()) {
            List<JSClass> list = controllersFromIndex;
            if (list == null) {
                StimulusControllerUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        GlobalSearchScope controllersScope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)true, (VirtualFile[])directories.toArray(VirtualFile.EMPTY_ARRAY));
        List<JSClass> list = CONTROLLER_FILE_SUFFIXES.stream().flatMap(suffix -> FilenameIndex.getVirtualFilesByName((String)(name + suffix), (GlobalSearchScope)controllersScope).stream()).flatMap(file -> PsiTreeUtil.findChildrenOfType((PsiElement)PsiManager.getInstance((Project)project).findFile(file), JSClass.class).stream()).mapMulti(StreamUtil.select(JSClass.class, (Class[])new Class[0])).toList();
        if (list == null) {
            StimulusControllerUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static String getControllerNameFromFile(@NotNull String fileName) {
        String suffix;
        if (fileName == null) {
            StimulusControllerUtil.$$$reportNull$$$0(5);
        }
        return (suffix = (String)ContainerUtil.find(CONTROLLER_FILE_SUFFIXES, s -> fileName.endsWith((String)s))) != null ? StimulusControllerUtil.dasherize(fileName.substring(0, fileName.indexOf(suffix))) : null;
    }

    @NotNull
    public static String dasherize(@NotNull String name) {
        if (name == null) {
            StimulusControllerUtil.$$$reportNull$$$0(6);
        }
        String string = JSStringUtil.toKebabCase((String)name, (boolean)true, (boolean)true, (boolean)false);
        if (string == null) {
            StimulusControllerUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String camelizeValueName(@NotNull String dasherizedValueName) {
        if (dasherizedValueName == null) {
            StimulusControllerUtil.$$$reportNull$$$0(8);
        }
        String string = StringUtil.decapitalize((String)NamingConventions.toCamelCase((String)dasherizedValueName.replaceAll("-", "_")));
        if (string == null) {
            StimulusControllerUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static List<JSObjectLiteralExpression> getControllerValuesObjects(@NotNull String controllerName, @NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (controllerName == null) {
            StimulusControllerUtil.$$$reportNull$$$0(10);
        }
        if (module == null) {
            StimulusControllerUtil.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            StimulusControllerUtil.$$$reportNull$$$0(12);
        }
        List<JSObjectLiteralExpression> list = StimulusControllerUtil.getControllerClassByName(controllerName, module, scope).stream().map(controller -> controller.findFieldByName("values")).filter(Objects::nonNull).filter(it -> it.hasModifier(JSAttributeList.ModifierType.STATIC)).map(JSField::getInitializer).mapMulti(StreamUtil.select(JSObjectLiteralExpression.class, (Class[])new Class[0])).toList();
        if (list == null) {
            StimulusControllerUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    public static boolean isStimulusTarget(@NotNull PsiElement element) {
        if (element == null) {
            StimulusControllerUtil.$$$reportNull$$$0(14);
        }
        if (!(element instanceof JSLiteralExpression)) {
            return false;
        }
        JSLiteralExpression literal = (JSLiteralExpression)element;
        if (!StimulusControllerUtil.isInStimulusControllerFiles(element.getContainingFile())) {
            return false;
        }
        JSArrayLiteralExpression parentArray = (JSArrayLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)literal, JSArrayLiteralExpression.class);
        if (parentArray == null) {
            return false;
        }
        JSField parentField = (JSField)PsiTreeUtil.getParentOfType((PsiElement)parentArray, JSField.class);
        return parentField != null && "targets".equals(parentField.getName()) && parentField.hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    @NotNull
    public static List<String> getControllerNames(@NotNull Module module, @NotNull GlobalSearchScope searchScope) {
        List<String> controllersFromIndex;
        if (module == null) {
            StimulusControllerUtil.$$$reportNull$$$0(15);
        }
        if (searchScope == null) {
            StimulusControllerUtil.$$$reportNull$$$0(16);
        }
        if (!(controllersFromIndex = StimulusControllerUtil.getControllerIdentifiers(module).stream().filter(controller -> searchScope.contains(controller.getContainingFile().getVirtualFile())).map(JSLiteralExpression::getStringValue).filter(Objects::nonNull).toList()).isEmpty()) {
            List<String> list = controllersFromIndex;
            if (list == null) {
                StimulusControllerUtil.$$$reportNull$$$0(17);
            }
            return list;
        }
        List<String> list = StimulusControllerUtil.getControllerDirectories(module).stream().flatMap(file -> Arrays.stream(file.getChildren())).map(VirtualFile::getName).map(filename -> {
            String suffix = (String)ContainerUtil.find(CONTROLLER_FILE_SUFFIXES, it -> filename.endsWith((String)it));
            return suffix != null ? filename.substring(0, filename.lastIndexOf(suffix)) : null;
        }).filter(Objects::nonNull).toList();
        if (list == null) {
            StimulusControllerUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    public static boolean isInStimulusControllerFiles(@NotNull PsiFile file) {
        VirtualFile virtualFile;
        if (file == null) {
            StimulusControllerUtil.$$$reportNull$$$0(19);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file)) == null || !virtualFile.getPath().contains("javascript/controllers/")) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return false;
        }
        return VfsUtilCore.isUnderFiles((VirtualFile)virtualFile, StimulusControllerUtil.getControllerDirectories(module));
    }

    @NotNull
    private static List<VirtualFile> getControllerDirectories(@NotNull Module module) {
        if (module == null) {
            StimulusControllerUtil.$$$reportNull$$$0(20);
        }
        RailsApp app = RailsApp.fromModule((Module)module);
        List list = (List)ObjectUtils.coalesce((Object)((List)ObjectUtils.doIfNotNull((Object)app, it -> it.getPaths().findFiles("app", new String[]{CONTROLLERS_PATH}))), Collections.emptyList());
        if (list == null) {
            StimulusControllerUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static List<VirtualFile> getControllerIndexFiles(@NotNull Module module) {
        if (module == null) {
            StimulusControllerUtil.$$$reportNull$$$0(22);
        }
        List<VirtualFile> list = StimulusControllerUtil.getControllerDirectories(module).stream().flatMap(it -> Arrays.stream(it.getChildren())).filter(file -> file.getName().equals("index.js")).toList();
        if (list == null) {
            StimulusControllerUtil.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private static List<JSLiteralExpression> getControllerIdentifiers(@NotNull Module module) {
        if (module == null) {
            StimulusControllerUtil.$$$reportNull$$$0(24);
        }
        List<JSLiteralExpression> list = StimulusControllerUtil.getControllerIndexFiles(module).stream().map(file -> PsiManager.getInstance((Project)module.getProject()).findFile(file)).filter(Objects::nonNull).flatMap(file -> PsiTreeUtil.findChildrenOfType((PsiElement)file, JSCallExpression.class).stream()).mapMulti(StreamUtil.select(JSCallExpression.class, (Class[])new Class[0])).filter(arg_0 -> JS_REGISTER_CALL_PATTERN.accepts(arg_0)).map(call -> (JSExpression)ContainerUtil.getFirstItem(Arrays.asList(call.getArguments()))).mapMulti(StreamUtil.select(JSLiteralExpression.class, (Class[])new Class[0])).toList();
        if (list == null) {
            StimulusControllerUtil.$$$reportNull$$$0(25);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 9, 13, 17, 18, 21, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 11: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ruby/javascript/rails/stimulus/StimulusControllerUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasherizedValueName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ruby/javascript/rails/stimulus/StimulusControllerUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerClassByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dasherize";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "camelizeValueName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerValuesObjects";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerDirectories";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerIndexFiles";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerIdentifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControllerClassByName";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getControllerNameFromFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dasherize";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "camelizeValueName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getControllerValuesObjects";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isStimulusTarget";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getControllerNames";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInStimulusControllerFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getControllerDirectories";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getControllerIndexFiles";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getControllerIdentifiers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 9, 13, 17, 18, 21, 23, 25 -> new IllegalStateException(string);
        };
    }
}

