/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.DbExpertOptionsEditor;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DriverPropertiesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.ide.macro.EditorMacro;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinder;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.CurrentJavaVersion;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class AdvancedPropertiesPanel {
    @NlsSafe
    static final String DEFAULT = "Default";
    private JPanel myRoot;
    private RawCommandLineEditor myVMParameters;
    private JBLabel myVMParametersLabel;
    private EnvironmentVariablesTextFieldWithBrowseButton myVMEnv;
    private JBLabel myVMEnvLabel;
    private ComboBox<String> myJreCombo;
    private JPanel myDriverPanel;
    private JPanel myDataSourcePanel;
    private JPanel myPropertiesPanel;
    private TextFieldWithBrowseButton myWorkingDir;
    private JBLabel myWorkingDirLabel;
    private ActionLink myExpertOptions;
    private final DbExpertOptionsEditor<Object> myExpertOptionsEditor;
    private final DriverPropertiesComponent myDriverPropertiesComponent;

    public AdvancedPropertiesPanel(final @NotNull Project project, @NotNull Map<String, String> properties, final @NotNull AbstractDatabaseConfigurable<?> owner, @NotNull DatabaseConfigEditor controller) {
        if (project == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(0);
        }
        if (properties == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(1);
        }
        if (owner == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(2);
        }
        if (controller == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(3);
        }
        this.myDriverPropertiesComponent = new DriverPropertiesComponent(project, properties, owner, controller);
        this.$$$setupUI$$$();
        this.myDriverPanel.setVisible(owner instanceof DatabaseDriverConfigurable);
        this.myDataSourcePanel.setVisible(owner instanceof DataSourceConfigurable);
        this.myWorkingDir.addBrowseFolderListener(new TextBrowseFolderListener(this, FileChooserDescriptorFactory.createSingleFolderDescriptor(), project){

            @NotNull
            @NonNls
            protected String expandPath(@NotNull @NonNls String path) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = super.expandPath(JdbcConsoleRunContext.expand((Project)project, (String)path));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/view/ui/AdvancedPropertiesPanel$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expandPath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "expandPath";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
        this.myExpertOptionsEditor = new DbExpertOptionsEditor<Object>(project, owner.getTarget().getClass(), () -> owner.getTempTarget(), owner.getDataContext());
        this.myExpertOptionsEditor.reset(owner.getTarget());
        this.myExpertOptions.setDropDownLinkIcon();
        this.myExpertOptions.addActionListener(e -> JBPopupFactory.getInstance().createComponentPopupBuilder(this.myExpertOptionsEditor.getComponent(), this.myExpertOptionsEditor.getComponent()).setFocusable(true).setRequestFocus(true).setMovable(true).setResizable(true).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                owner.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/view/ui/AdvancedPropertiesPanel$2", "onClosed"));
            }
        }).setLocateWithinScreenBounds(true).createPopup().showUnderneathOf((Component)this.myExpertOptions));
        MacrosDialog.addMacroSupport((ExtendableTextField)((ExtendableTextField)this.myWorkingDir.getTextField()), MacrosDialog.Filters.DIRECTORY_PATH.and(macro -> !(macro instanceof EditorMacro)), () -> false);
        this.myVMEnvLabel.setLabelFor((Component)this.myVMEnv);
        this.myVMParametersLabel.setLabelFor((Component)this.myVMParameters.getTextField());
        this.myWorkingDirLabel.setLabelFor((Component)this.myWorkingDir.getTextField());
    }

    private void createUIComponents() {
        this.myPropertiesPanel = this.myDriverPropertiesComponent.getComponent();
        this.myVMParameters = new RawCommandLineEditor();
        this.myVMEnv = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myJreCombo = new MyJreComboBox();
    }

    public JPanel getComponent() {
        return this.myRoot;
    }

    @Nullable
    public String getWorkingDir() {
        return StringUtil.nullize((String)this.myWorkingDir.getText());
    }

    public void setWorkingDir(@Nullable String dir) {
        this.myWorkingDir.setText(StringUtil.notNullize((String)dir));
    }

    @Nullable
    public String getJrePath() {
        String item = (String)this.myJreCombo.getEditor().getItem();
        return item == null ? null : StringUtil.nullize((String)item.trim(), (String)DEFAULT);
    }

    public void setJrePath(@NlsSafe @Nullable String path) {
        this.myJreCombo.setSelectedItem((Object)StringUtil.notNullize((String)path, (String)DEFAULT));
    }

    public String getVmOptions() {
        return this.myVMParameters.getText().trim();
    }

    public void setVmOptions(String options) {
        this.myVMParameters.setText(options);
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map map2 = this.myVMEnv.getEnvs();
        if (map2 == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(4);
        }
        return map2;
    }

    public void setVmEnv(@NotNull Map<String, String> env) {
        if (env == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(5);
        }
        this.myVMEnv.setEnvs(env);
    }

    public void saveDriver(DatabaseDriverImpl driver) {
        this.myDriverPropertiesComponent.saveProperties(driver.getDriverProperties());
        driver.setJrePath(this.getJrePath());
        driver.setVmOptions(this.getVmOptions());
        driver.setVmEnv(this.getVmEnv());
        this.myExpertOptionsEditor.apply(driver);
    }

    public void resetDriver(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(6);
        }
        this.myDriverPropertiesComponent.setProperties(driver.getDriverProperties());
        this.setVmOptions(driver.getVmOptions());
        this.setVmEnv(driver.getVmEnv());
        this.setJrePath(driver.getJrePath());
        this.myExpertOptionsEditor.reset(driver);
    }

    public void saveDataSource(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(7);
        }
        this.myDriverPropertiesComponent.saveProperties(dataSource.getDriverProperties());
        dataSource.setVmOptions(StringUtil.nullize((String)this.getVmOptions()));
        dataSource.setVmEnv(this.getVmEnv());
        dataSource.setWorkingDir(this.getWorkingDir());
        this.myExpertOptionsEditor.apply(dataSource);
    }

    public void resetDataSource(@NotNull LocalDataSource o) {
        if (o == null) {
            AdvancedPropertiesPanel.$$$reportNull$$$0(8);
        }
        this.myDriverPropertiesComponent.setProperties(o.getDriverProperties());
        this.setVmOptions(o.getVmOptions());
        this.setVmEnv(o.getVmEnv());
        this.setWorkingDir(o.getWorkingDir());
        this.myExpertOptionsEditor.reset(o);
    }

    public void migrateDriver(@Nullable DatabaseDriver prevDriver, @Nullable DatabaseDriver newDriver) {
        this.myDriverPropertiesComponent.migrateDriver(prevDriver, newDriver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/AdvancedPropertiesPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/AdvancedPropertiesPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmEnv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVmEnv";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetDriver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveDataSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resetDataSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ActionLink actionLink;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPanel jPanel3;
        this.createUIComponents();
        this.myRoot = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 4, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 12, 8, 12), null, 0, 0, null, null));
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton = this.myVMEnv;
        jPanel4.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myVMEnvLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AdvancedPropertiesPanel.class).getString("data.source.vm.env.label"));
        jPanel4.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMParametersLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AdvancedPropertiesPanel.class).getString("data.source.vm.options.label"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        RawCommandLineEditor rawCommandLineEditor = this.myVMParameters;
        jPanel4.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myDriverPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AdvancedPropertiesPanel.class).getString("data.source.vm.home.label"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        ComboBox<String> comboBox = this.myJreCombo;
        comboBox.setEditable(true);
        jPanel2.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDataSourcePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myWorkingDirLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ExecutionBundle", AdvancedPropertiesPanel.class).getString("run.configuration.working.directory.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myWorkingDir = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myExpertOptions = actionLink = new ActionLink();
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AdvancedPropertiesPanel.class).getString("expert.properties"));
        jPanel4.add((Component)actionLink, new GridConstraints(4, 0, 1, 2, 4, 0, 0, 0, null, null, null));
        JPanel jPanel5 = this.myPropertiesPanel;
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        jBLabel4.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyJreComboBox
    extends ComboBox<String> {
        private Map<String, String> runtimeVersions = null;

        MyJreComboBox() {
            super(100);
            ((DefaultComboBoxModel)this.getModel()).addElement(AdvancedPropertiesPanel.DEFAULT);
            this.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    this.ensureModelLoaded();
                }
            });
            this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

                protected void customizeCellRenderer(@NotNull JList<? extends String> list, @NlsSafe String value, int index, boolean selected, boolean hasFocus) {
                    if (list == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    String version = Strings.areSameInstance((String)value, (String)AdvancedPropertiesPanel.DEFAULT) ? CurrentJavaVersion.currentJavaVersion().toString() : (runtimeVersions == null ? null : runtimeVersions.get(value));
                    this.append(SdkListPresenter.presentDetectedSdkPath((String)value));
                    if (version != null) {
                        this.append(" " + DatabaseBundle.message((String)"jdbc.properties.java.version", (Object[])new Object[]{version}), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/view/ui/AdvancedPropertiesPanel$MyJreComboBox$2", "customizeCellRenderer"));
                }
            });
            this.setEditor(new BasicComboBoxEditor(){

                @Override
                protected JTextField createEditorComponent() {
                    ExtendableTextField field = new ExtendableTextField().addBrowseExtension(this::showDialog, null, false);
                    field.setTextToTriggerEmptyTextStatus(AdvancedPropertiesPanel.DEFAULT);
                    field.getEmptyText().appendText(AdvancedPropertiesPanel.DEFAULT, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    field.getEmptyText().appendText(" " + DatabaseBundle.message((String)"jdbc.properties.java.version", (Object[])new Object[]{CurrentJavaVersion.currentJavaVersion()}), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    field.setBorder(null);
                    field.addFocusListener(new FocusListener(this){

                        @Override
                        public void focusGained(FocusEvent e) {
                            1.update(e);
                        }

                        @Override
                        public void focusLost(FocusEvent e) {
                            1.update(e);
                        }

                        private static void update(FocusEvent e) {
                            Container c2 = e.getComponent().getParent();
                            if (c2 != null) {
                                c2.revalidate();
                                c2.repaint();
                            }
                        }
                    });
                    InsertPathAction.addTo((JTextComponent)field);
                    return field;
                }
            });
        }

        private void showDialog() {
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), null, null);
            if (file != null) {
                this.setSelectedItem(FileUtil.toSystemDependentName((String)file.getPath()));
            }
        }

        private void ensureModelLoaded() {
            if (this.runtimeVersions != null) {
                return;
            }
            new Task.Backgroundable(null, DatabaseBundle.message((String)"jdbc.properties.updating.jre.list", (Object[])new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    LinkedHashMap<String, String> versions = new LinkedHashMap<String, String>();
                    JdkVersionDetector versionDetector = JdkVersionDetector.getInstance();
                    for (String path : JavaHomeFinder.suggestHomePaths()) {
                        indicator.checkCanceled();
                        JdkVersionDetector.JdkVersionInfo versionInfo = versionDetector.detectJdkVersionInfo(path);
                        if (versionInfo == null) continue;
                        versions.put(path, versionInfo.version.toString());
                    }
                    ComboBoxModel model = this.getModel();
                    String item = (String)((DefaultComboBoxModel)model).getSelectedItem();
                    UIUtil.invokeLaterIfNeeded(() -> this.lambda$run$0((DefaultComboBoxModel)model, versions, item));
                }

                private /* synthetic */ void lambda$run$0(DefaultComboBoxModel model, Map versions, String item) {
                    model.removeAllElements();
                    model.addElement(AdvancedPropertiesPanel.DEFAULT);
                    for (String path : versions.keySet()) {
                        model.addElement(path);
                    }
                    model.setSelectedItem(item);
                    runtimeVersions = versions;
                    if (this.isPopupVisible()) {
                        this.hidePopup();
                        this.showPopup();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/AdvancedPropertiesPanel$MyJreComboBox$4", "run"));
                }
            }.queue();
        }

        public DefaultComboBoxModel<String> getModel() {
            return (DefaultComboBoxModel)super.getModel();
        }
    }
}

