/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.terminal;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

final class RubyLocalTerminalCustomizer
extends LocalTerminalCustomizer {
    private static final Logger LOG = Logger.getInstance(RubyLocalTerminalCustomizer.class);

    RubyLocalTerminalCustomizer() {
    }

    public String[] customizeCommandAndEnvironment(@NotNull Project project, @Nullable String workingDirectory, String[] command, @NotNull Map<String, String> envs) {
        Sdk rubySdk;
        if (project == null) {
            RubyLocalTerminalCustomizer.$$$reportNull$$$0(0);
        }
        if (envs == null) {
            RubyLocalTerminalCustomizer.$$$reportNull$$$0(1);
        }
        if ((rubySdk = (Sdk)ReadAction.compute(() -> RubySdkUtil.findRubySdk((Project)project))) == null) {
            return command;
        }
        RubySdkAdditionalData sdkAdditionalData = RubySdkAdditionalData.from((Sdk)rubySdk);
        if (sdkAdditionalData instanceof RubyRemoteSdkAdditionalData) {
            LOG.info("Do not initialise terminal for remote sdk: " + String.valueOf(rubySdk));
            return command;
        }
        RubyVersionManagerHandler versionManagerHandler = RubyVersionManagerHandler.from((Sdk)rubySdk);
        if (versionManagerHandler != null) {
            LOG.info("Running terminal in the context of " + String.valueOf(rubySdk));
            return versionManagerHandler.customizeTerminalExecution(project, rubySdk, command, envs);
        }
        return super.customizeCommandAndEnvironment(project, workingDirectory, command, envs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "envs";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/terminal/RubyLocalTerminalCustomizer";
        objectArray[2] = "customizeCommandAndEnvironment";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

