/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class StreamUtil {
    private StreamUtil() {
    }

    @SafeVarargs
    @NotNull
    public static <T> Stream<? extends T> concatLazy(@NotNull Stream<? extends T> first, Stream<? extends T> ... rest) {
        if (first == null) {
            StreamUtil.$$$reportNull$$$0(0);
        }
        if (rest == null) {
            StreamUtil.$$$reportNull$$$0(1);
        }
        if (rest.length == 0) {
            Stream<? extends T> stream = first;
            if (stream == null) {
                StreamUtil.$$$reportNull$$$0(2);
            }
            return stream;
        }
        ArrayList<Stream<? extends T>> streams = new ArrayList<Stream<? extends T>>();
        streams.add(first);
        streams.addAll(List.of(rest));
        Stream stream = streams.stream().flatMap(Function.identity());
        if (stream == null) {
            StreamUtil.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @SafeVarargs
    @NotNull
    public static <T> Stream<? extends T> concatLazy(@NotNull Supplier<Optional<? extends T>> first, Supplier<Optional<? extends T>> ... rest) {
        if (first == null) {
            StreamUtil.$$$reportNull$$$0(4);
        }
        if (rest == null) {
            StreamUtil.$$$reportNull$$$0(5);
        }
        if (rest.length == 0) {
            Stream stream = Stream.of(first).flatMap(it -> ((Optional)it.get()).stream());
            if (stream == null) {
                StreamUtil.$$$reportNull$$$0(6);
            }
            return stream;
        }
        ArrayList<Supplier<Optional<? extends T>>> suppliers = new ArrayList<Supplier<Optional<? extends T>>>();
        suppliers.add(first);
        suppliers.addAll(List.of(rest));
        Stream stream = suppliers.stream().flatMap(it -> ((Optional)it.get()).stream());
        if (stream == null) {
            StreamUtil.$$$reportNull$$$0(7);
        }
        return stream;
    }

    @SafeVarargs
    @NotNull
    public static <T, R> BiConsumer<T, Consumer<R>> select(@NotNull Class<? extends R> first, Class<? extends R> ... rest) {
        if (first == null) {
            StreamUtil.$$$reportNull$$$0(8);
        }
        if (rest == null) {
            StreamUtil.$$$reportNull$$$0(9);
        }
        BiConsumer<Object, Consumer> biConsumer = (t, consumer) -> {
            if (first.isInstance(t)) {
                consumer.accept(first.cast(t));
                return;
            }
            for (Class clazz : rest) {
                if (!clazz.isInstance(t)) continue;
                consumer.accept(clazz.cast(t));
                return;
            }
        };
        if (biConsumer == null) {
            StreamUtil.$$$reportNull$$$0(10);
        }
        return biConsumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/util/StreamUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/util/StreamUtil";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "concatLazy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "concatLazy";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7, 10 -> new IllegalStateException(string);
        };
    }
}

