/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsUtils;
import com.intellij.testFramework.LightVirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ContextPsiFile;
import org.jetbrains.plugins.ruby.settings.RubyBinaryExpressionAlignmentOptions;

public class RubyCodeStyleSettings
extends CustomCodeStyleSettings {
    private static final int CURRENT_VERSION = 1;
    private int myVersion = 1;
    @Nls
    public String SELECTED_EXTERNAL_FORMATTER = null;
    public boolean USE_EXTERNAL_FORMATTER = false;
    public boolean SPACE_WITHIN_PIPES = false;
    public boolean SPACE_WITHIN_ARRAY_LITERALS = false;
    public boolean SPACE_AROUND_RANGE_OPERATORS = false;
    public boolean SPACE_AROUND_HASHROCKET = true;
    public boolean SPACE_AROUND_POW_OPERATORS = true;
    public boolean SPACE_AROUND_OTHER_OPERATORS = true;
    public boolean INDENT_VISIBILITY_MODIFIERS = true;
    public boolean INDENT_PRIVATE_METHODS = false;
    public boolean INDENT_PROTECTED_METHODS = false;
    public boolean INDENT_PUBLIC_METHODS = false;
    public boolean INDENT_WHEN_CASES = false;
    public boolean PARENTHESES_AROUND_METHOD_ARGUMENTS = true;
    public boolean CONVERT_BRACE_BLOCK_BY_ENTER = true;
    public int CHAIN_CALLS_ALIGNMENT = 2;
    public int EMPTY_DECLARATIONS_STYLE = 1;
    public boolean FORCE_NEWLINES_AROUND_VISIBILITY_MODS = true;
    public int BINARY_EXPRESSIONS_ALIGNMENT = RubyBinaryExpressionAlignmentOptions.ALIGN.ordinal();

    public RubyCodeStyleSettings(CodeStyleSettings container) {
        super("Ruby", container);
    }

    @NotNull
    public static RubyCodeStyleSettings getInstance(@NotNull CommonCodeStyleSettings commonCodeStyleSettings) {
        if (commonCodeStyleSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(0);
        }
        return RubyCodeStyleSettings.getInstance(commonCodeStyleSettings.getRootSettings());
    }

    @NotNull
    public static RubyCodeStyleSettings getInstance(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(1);
        }
        RubyCodeStyleSettings rubyCodeStyleSettings = (RubyCodeStyleSettings)codeStyleSettings.getCustomSettings(RubyCodeStyleSettings.class);
        if (rubyCodeStyleSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(2);
        }
        return rubyCodeStyleSettings;
    }

    @NotNull
    public static RubyCodeStyleSettings getInstance(@NotNull PsiElement psiElement) {
        PsiFile contextFile;
        PsiFile containingFile;
        VirtualFile virtualFile;
        if (psiElement == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(3);
        }
        if (((virtualFile = (containingFile = psiElement.getContainingFile()).getVirtualFile()) == null || virtualFile instanceof LightVirtualFile) && (contextFile = ContextPsiFile.get(psiElement)) != null) {
            RubyCodeStyleSettings rubyCodeStyleSettings = (RubyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)contextFile, RubyCodeStyleSettings.class);
            if (rubyCodeStyleSettings == null) {
                RubyCodeStyleSettings.$$$reportNull$$$0(4);
            }
            return rubyCodeStyleSettings;
        }
        RubyCodeStyleSettings rubyCodeStyleSettings = (RubyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)containingFile, RubyCodeStyleSettings.class);
        if (rubyCodeStyleSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(5);
        }
        return rubyCodeStyleSettings;
    }

    @NotNull
    public static RubyCodeStyleSettings getInstance(@NotNull Editor editor) {
        if (editor == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(6);
        }
        RubyCodeStyleSettings rubyCodeStyleSettings = (RubyCodeStyleSettings)CodeStyle.getSettings((Editor)editor).getCustomSettings(RubyCodeStyleSettings.class);
        if (rubyCodeStyleSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(7);
        }
        return rubyCodeStyleSettings;
    }

    @TestOnly
    @NotNull
    public static RubyCodeStyleSettings getInstance(@NotNull Project project) {
        if (project == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(8);
        }
        RubyCodeStyleSettings rubyCodeStyleSettings = (RubyCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(RubyCodeStyleSettings.class);
        if (rubyCodeStyleSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(9);
        }
        return rubyCodeStyleSettings;
    }

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(10);
        }
        this.PARENTHESES_AROUND_METHOD_ARGUMENTS = rootSettings.PARENTHESES_AROUND_METHOD_ARGUMENTS;
    }

    protected void afterLoaded() {
        if (this.myVersion < 1) {
            this.migrateFromVersion0();
        }
        this.myVersion = 1;
    }

    private void migrateFromVersion0() {
        CommonCodeStyleSettings commonSettings = this.getCommonSettings();
        if (!commonSettings.ALIGN_MULTILINE_BINARY_OPERATION) {
            this.BINARY_EXPRESSIONS_ALIGNMENT = RubyBinaryExpressionAlignmentOptions.NONE.ordinal();
        }
    }

    @NotNull
    private CommonCodeStyleSettings getCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = this.getContainer().getCommonSettings((Language)RubyLanguage.INSTANCE);
        if (commonCodeStyleSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(11);
        }
        return commonCodeStyleSettings;
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        this.myVersion = CustomCodeStyleSettingsUtils.readVersion((Element)parentElement.getChild(this.getTagName()));
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            RubyCodeStyleSettings.$$$reportNull$$$0(12);
        }
        super.writeExternal(parentElement, parentSettings);
        CustomCodeStyleSettingsUtils.writeVersion((Element)parentElement.getChild(this.getTagName()), (int)this.myVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCodeStyleSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/settings/RubyCodeStyleSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/settings/RubyCodeStyleSettings";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importLegacySettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 9, 11 -> new IllegalStateException(string);
        };
    }
}

