/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;

public final class RubySpaceUtil {
    public static final TokenSet SOFT_WHITESPACES = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tWHITE_SPACE, RubyTokenTypes.tWHITE_SPACE_WITH_NEWLINE});
    public static final TokenSet HARD_WHITESPACES = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tEOL});
    public static final TokenSet ALL_WHITESPACES = TokenSet.orSet((TokenSet[])new TokenSet[]{SOFT_WHITESPACES, HARD_WHITESPACES});

    private RubySpaceUtil() {
    }

    public static boolean isNonMultilineSoftNewLine(@Nullable PsiElement psiElement) {
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)psiElement);
        return elementType == RubyTokenTypes.tWHITE_SPACE || elementType == RubyTokenTypes.tWHITE_SPACE_WITH_NEWLINE && !RubySpaceUtil.hasMultipleNewLines(psiElement.getText());
    }

    @Contract(value="null->false")
    public static boolean isSoftSpace(@Nullable IElementType elementType) {
        return elementType == RubyTokenTypes.tWHITE_SPACE_WITH_NEWLINE || elementType == RubyTokenTypes.tWHITE_SPACE;
    }

    @Contract(value="null->false")
    public static boolean isSoftNewLine(@Nullable PsiElement psiElement) {
        return psiElement != null && RubySpaceUtil.isSoftNewLine(psiElement.getNode());
    }

    @Contract(value="null->false")
    public static boolean isSoftNewLine(@Nullable ASTNode node) {
        return RubySpaceUtil.isSoftNewLine(PsiUtilCore.getElementType((ASTNode)node));
    }

    @Contract(value="null->false")
    public static boolean isSoftNewLine(@Nullable IElementType elementType) {
        return elementType == RubyTokenTypes.tWHITE_SPACE_WITH_NEWLINE;
    }

    @Contract(value="null->false")
    public static boolean isMultiLineEol(@Nullable ASTNode node) {
        return RubySpaceUtil.isEol(node) && RubySpaceUtil.hasMultipleNewLines(node);
    }

    @Contract(value="null->false")
    public static boolean isMultiLineSoftNewLine(@Nullable PsiElement psiElement) {
        return psiElement != null && RubySpaceUtil.isMultiLineSoftNewLine(psiElement.getNode());
    }

    @Contract(value="null->false")
    public static boolean isMultiLineSoftNewLine(@Nullable ASTNode node) {
        return RubySpaceUtil.isSoftNewLine(node) && RubySpaceUtil.hasMultipleNewLines(node);
    }

    @Contract(value="null->false")
    public static boolean isAnyNewLine(@Nullable PsiElement psiElement) {
        return psiElement != null && RubySpaceUtil.isAnyNewLine(psiElement.getNode());
    }

    @Contract(value="null->false")
    public static boolean isAnyNewLine(@Nullable ASTNode astNode) {
        return RubySpaceUtil.isAnyNewLine(PsiUtilCore.getElementType((ASTNode)astNode));
    }

    @Contract(value="null->false")
    public static boolean isAnyNewLine(@Nullable IElementType elementType) {
        return elementType == RubyTokenTypes.tEOL || elementType == RubyTokenTypes.tWHITE_SPACE_WITH_NEWLINE;
    }

    @Contract(value="null->false")
    public static boolean hasMultipleNewLines(@Nullable ASTNode astNode) {
        return astNode != null && RubySpaceUtil.hasMultipleNewLines(astNode.getChars());
    }

    @Contract(value="null->false")
    public static boolean hasMultipleNewLines(@Nullable PsiElement psiElement) {
        return psiElement != null && RubySpaceUtil.hasMultipleNewLines(psiElement.getNode());
    }

    @Contract(value="null->false")
    public static boolean isEol(@Nullable PsiElement psiElement) {
        return psiElement != null && RubySpaceUtil.isEol(psiElement.getNode());
    }

    @Contract(value="null->false")
    public static boolean isEol(@Nullable ASTNode astNode) {
        return RubySpaceUtil.isEol(PsiUtilCore.getElementType((ASTNode)astNode));
    }

    @Contract(value="null->false")
    public static boolean isEol(@Nullable IElementType elementType) {
        return elementType == RubyTokenTypes.tEOL;
    }

    @Contract(value="null->false")
    public static boolean isAnySpace(@Nullable PsiElement psiElement) {
        return psiElement != null && RubySpaceUtil.isAnySpace(psiElement.getNode());
    }

    @Contract(value="null->false")
    public static boolean isAnySpace(@Nullable ASTNode astNode) {
        return RubySpaceUtil.isAnySpace(PsiUtilCore.getElementType((ASTNode)astNode));
    }

    @Contract(value="null->false")
    public static boolean isAnySpace(@Nullable IElementType elementType) {
        return elementType != null && (RubySpaceUtil.isSoftSpace(elementType) || RubySpaceUtil.isEol(elementType));
    }

    private static boolean hasMultipleNewLines(@NotNull CharSequence charSequence) {
        if (charSequence == null) {
            RubySpaceUtil.$$$reportNull$$$0(0);
        }
        int newLinesCount = 0;
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '\n' || ++newLinesCount <= 1) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null->false")
    public static boolean isSingleSoftNewLine(@Nullable PsiElement element) {
        return RubySpaceUtil.isSoftNewLine(element) && !RubySpaceUtil.hasMultipleNewLines(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charSequence", "org/jetbrains/plugins/ruby/ruby/lang/psi/RubySpaceUtil", "hasMultipleNewLines"));
    }
}

