/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;

public final class RubyCommentsUtilRt {
    private RubyCommentsUtilRt() {
    }

    @NotNull
    public static TextRange getLineCommentsRange(PsiElement lineComment) {
        TextRange lineCommentRange = lineComment.getTextRange();
        int start = lineCommentRange.getStartOffset();
        int end = lineCommentRange.getEndOffset();
        PsiElement element = lineComment;
        while (RubySpaceUtil.isSingleSoftNewLine(element = element.getPrevSibling()) && PsiUtilCore.getElementType((PsiElement)(element = element.getPrevSibling())) == RubyTokenTypes.TLINE_COMMENT) {
            start = element.getTextRange().getStartOffset();
        }
        element = lineComment;
        while (true) {
            if ((element = element.getNextSibling()) != null) {
                ++end;
            }
            if (!RubySpaceUtil.isSingleSoftNewLine(element)) break;
            end = element.getTextRange().getEndOffset();
            if (PsiUtilCore.getElementType((PsiElement)(element = element.getNextSibling())) != RubyTokenTypes.TLINE_COMMENT) break;
            end = element.getTextRange().getEndOffset();
        }
        return new TextRange(start, end);
    }
}

