/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.lexer;

import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyFlexAdapter;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyReparseableTokenType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;

public class RubyLexer
extends MergingLexerAdapter {
    public static final TokenSet OPENING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.kDEF, RubyTokenTypes.kIF, RubyTokenTypes.kUNLESS, RubyTokenTypes.kWHILE, RubyTokenTypes.kUNTIL, RubyTokenTypes.kFOR, RubyTokenTypes.kMODULE, RubyTokenTypes.kCLASS, RubyTokenTypes.kCASE, RubyTokenTypes.kDO, RubyTokenTypes.kBEGIN});
    private static final Logger LOG = Logger.getInstance(RubyLexer.class);
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.orSet((TokenSet[])new TokenSet[]{RubySpaceUtil.SOFT_WHITESPACES, TokenSet.create((IElementType[])new IElementType[]{Ruby19TokenTypes.tSYMBOLS_CONTENT, RubyTokenTypes.tWORDS_CONTENT, RubyTokenTypes.tREGEXP_CONTENT, RubyTokenTypes.tSTRING_CONTENT, RubyTokenTypes.tHEREDOC_ID, RubyTokenTypes.tHEREDOC_CONTENT, RubyTokenTypes.tREGEXP_END})});
    private static final AtomicNotNullLazyValue<Map<IElementType, IElementType>> BRACES_MAP_PROVIDER = AtomicNotNullLazyValue.createValue(() -> {
        HashMap<IElementType, IElementType> resultBuilder = new HashMap<IElementType, IElementType>();
        for (PairedBraceMatcher braceMatcher : LanguageBraceMatching.INSTANCE.allForLanguage((Language)RubyLanguage.INSTANCE)) {
            for (BracePair pair : braceMatcher.getPairs()) {
                resultBuilder.put(pair.getLeftBraceType(), pair.getRightBraceType());
            }
        }
        resultBuilder.put(RubyTokenTypes.tDOUBLE_QUOTED_STRING_BEG, RubyTokenTypes.tSTRING_END);
        resultBuilder.put(RubyTokenTypes.tSINGLE_QUOTED_STRING_BEG, RubyTokenTypes.tSTRING_END);
        resultBuilder.put(RubyTokenTypes.tXSTRING_BEG, RubyTokenTypes.tSTRING_END);
        resultBuilder.put(RubyTokenTypes.tREGEXP_BEG, RubyTokenTypes.tREGEXP_END);
        for (IElementType openerElementType : OPENING_TOKENS.getTypes()) {
            resultBuilder.put(openerElementType, RubyTokenTypes.kEND);
        }
        return Map.copyOf(resultBuilder);
    });
    private static final AtomicNotNullLazyValue<Set<IElementType>> RIGHT_BRACES_PROVIDER = AtomicNotNullLazyValue.createValue(() -> Set.copyOf(((Map)BRACES_MAP_PROVIDER.getValue()).values()));

    public RubyLexer() {
        super((Lexer)new RubyFlexAdapter(), TOKENS_TO_MERGE);
    }

    public static boolean confirmWithLexer(@NotNull CharSequence sequence, @NotNull RubyReparseableTokenType tokenType) {
        if (sequence == null) {
            RubyLexer.$$$reportNull$$$0(0);
        }
        if (tokenType == null) {
            RubyLexer.$$$reportNull$$$0(1);
        }
        RubyLexer lexer = new RubyLexer();
        lexer.start(sequence);
        if (lexer.getTokenType() != tokenType) {
            return false;
        }
        return lexer.getTokenEnd() == sequence.length();
    }

    public static boolean confirmBalanceWithLexer(@NotNull CharSequence sequence, @NotNull IElementType startToken) {
        if (sequence == null) {
            RubyLexer.$$$reportNull$$$0(2);
        }
        if (startToken == null) {
            RubyLexer.$$$reportNull$$$0(3);
        }
        return RubyLexer.checkBalanceWithLexer(sequence, startToken);
    }

    private static boolean checkBalanceWithLexer(@NotNull CharSequence sequence, @NotNull IElementType startToken) {
        if (sequence == null) {
            RubyLexer.$$$reportNull$$$0(4);
        }
        if (startToken == null) {
            RubyLexer.$$$reportNull$$$0(5);
        }
        RubyLexer lexer = new RubyLexer();
        lexer.start(sequence);
        if (lexer.getTokenType() != startToken) {
            LOG.debug("Wrong starting token: ", new Object[]{lexer.getTokenType(), "; expected: ", startToken});
            return false;
        }
        Map bracesMap = (Map)BRACES_MAP_PROVIDER.getValue();
        Set rightBracesSet = (Set)RIGHT_BRACES_PROVIDER.getValue();
        IElementType lastBraceElement = (IElementType)bracesMap.get(startToken);
        IElementType lastTokenType = null;
        ArrayDeque<IElementType> bracesStack = new ArrayDeque<IElementType>();
        int cancellationDebounceCounter = 0;
        while (lexer.getTokenType() != null) {
            if (cancellationDebounceCounter % 100 == 0) {
                ProgressManager.checkCanceled();
            }
            ++cancellationDebounceCounter;
            lastTokenType = lexer.getTokenType();
            if (rightBracesSet.contains(lastTokenType)) {
                if (bracesStack.isEmpty() || bracesStack.removeLast() != lastTokenType) {
                    LOG.debug("Unexpected right brace: ", new Object[]{lastBraceElement});
                    return false;
                }
            } else {
                IElementType rightBrace;
                IElementType iElementType = rightBrace = lastTokenType == null ? null : (IElementType)bracesMap.get(lastTokenType);
                if (rightBrace != null) {
                    bracesStack.add(rightBrace);
                }
            }
            lexer.advance();
        }
        if (lastTokenType == lastBraceElement && bracesStack.isEmpty() && RubyLexer.isLexerAfterExpressionOrStatement(lexer)) {
            return true;
        }
        LOG.debug("Can't reparse: ", new Object[]{"lastToken=", lastTokenType, "; bracesStack=", bracesStack, "; lexerState=", lexer.getState(), "; text=", sequence});
        return false;
    }

    public static boolean isLexerAfterExpressionOrStatement(@NotNull RubyLexer lexer) {
        int lexerState;
        if (lexer == null) {
            RubyLexer.$$$reportNull$$$0(6);
        }
        return (lexerState = lexer.getState()) == 0 || lexerState == 8;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startToken";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/RubyLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "confirmWithLexer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "confirmBalanceWithLexer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBalanceWithLexer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isLexerAfterExpressionOrStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

