/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.lexer;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RubyHeredocUtil {
    @NonNls
    public static final String INDENTED_PREFIX = "<<-";
    @NonNls
    public static final String SQUIGGLY_PREFIX = "<<~";
    @NonNls
    public static final String PREFIX = "<<";
    @NonNls
    private static final Pattern REPLACE_REGEX = Pattern.compile("<<|-|~|\"|'|`");

    private RubyHeredocUtil() {
    }

    @NotNull
    public static String getName(@NotNull String id) {
        if (id == null) {
            RubyHeredocUtil.$$$reportNull$$$0(0);
        }
        String string = REPLACE_REGEX.matcher(id).replaceAll("");
        if (string == null) {
            RubyHeredocUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isIndented(@NotNull String id) {
        if (id == null) {
            RubyHeredocUtil.$$$reportNull$$$0(2);
        }
        return id.startsWith(INDENTED_PREFIX);
    }

    public static boolean isSquiggly(@NotNull String id) {
        if (id == null) {
            RubyHeredocUtil.$$$reportNull$$$0(3);
        }
        return id.startsWith(SQUIGGLY_PREFIX);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/RubyHeredocUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/lexer/RubyHeredocUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIndented";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSquiggly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

