/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlightingLexerAdapter;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;

public final class RubySyntaxHighlighter
extends SyntaxHighlighterBase
implements RubyTokenTypes {
    public static final RubyElementType SYMBOL = new RubyElementType("RUBY_SYMBOL_FOR_HIGHLIGHTING");
    private static final TokenSet tBRACKETS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tLBRACKS, TokenSet.create((IElementType[])new IElementType[]{tRBRACK})});
    private static final TokenSet tBRACES = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tLBRACES, TokenSet.create((IElementType[])new IElementType[]{tRBRACE})});
    private static final TokenSet tPARENTHESES = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tLPARENS, TokenSet.create((IElementType[])new IElementType[]{tRPAREN})});
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = RubySyntaxHighlighter.createAttributes();

    @NotNull
    public Lexer getHighlightingLexer() {
        return new RubyHighlightingLexerAdapter((Lexer)new RubyLexer());
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = RubySyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            RubySyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    private static Map<IElementType, TextAttributesKey> createAttributes() {
        HashMap map = new HashMap();
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.kALL_KEYWORDS, (TextAttributesKey)RubyHighlighter.KEYWORD);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tOPS, (TextAttributesKey)RubyHighlighter.OPERATION_SIGN);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tOP_ASGNS, (TextAttributesKey)RubyHighlighter.OPERATION_SIGN);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tEXCLAMATION, (TextAttributesKey)RubyHighlighter.OPERATION_SIGN);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tQUESTION, (TextAttributesKey)RubyHighlighter.OPERATION_SIGN);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenSet.andNot((TokenSet)TokenBNF.tBINARY_OPS, (TokenSet)TokenBNF.kBOOL_OPS), (TextAttributesKey)RubyHighlighter.OPERATION_SIGN);
        RubySyntaxHighlighter.safeMap(map, (IElementType)Ruby19TokenTypes.tARROW, (TextAttributesKey)RubyHighlighter.OPERATION_SIGN);
        RubySyntaxHighlighter.safeMap(map, (IElementType)Ruby19TokenTypes.tDOUBLE_STAR, (TextAttributesKey)RubyHighlighter.OPERATION_SIGN);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tCOMMENTS, (TextAttributesKey)RubyHighlighter.COMMENT);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tNUMBERS, (TextAttributesKey)RubyHighlighter.NUMBER);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)tBRACKETS, (TextAttributesKey)RubyHighlighter.BRACKETS);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)tBRACES, (TextAttributesKey)RubyHighlighter.BRACES);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)tPARENTHESES, (TextAttributesKey)RubyHighlighter.PARENTHESES);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tREGEXP_DELIMITERS, (TextAttributesKey)RubyHighlighter.REGEXPS);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tWORDS_CONTENT, (TextAttributesKey)RubyHighlighter.WORDS);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tWORDS_DELIMITERS, (TextAttributesKey)RubyHighlighter.WORDS);
        RubySyntaxHighlighter.safeMap(map, (IElementType)Ruby19TokenTypes.tSYMBOLS_CONTENT, (TextAttributesKey)RubyHighlighter.SYMBOL);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tSYMBOLS_DELIMITERS, (TextAttributesKey)RubyHighlighter.SYMBOL);
        RubySyntaxHighlighter.safeMap(map, (IElementType)SYMBOL, (TextAttributesKey)RubyHighlighter.SYMBOL);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tHEREDOC_CONTENT, (TextAttributesKey)RubyHighlighter.HEREDOC_CONTENT);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tHEREDOC_ALL_IDS, (TextAttributesKey)RubyHighlighter.HEREDOC_ID);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tEXPR_SUBT_TOKENS, (TextAttributesKey)RubyHighlighter.EXPR_SUBST_MARKS);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tCOMMA, (TextAttributesKey)RubyHighlighter.COMMA);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tCALL, (TextAttributesKey)RubyHighlighter.DOT);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tCOLON, (TextAttributesKey)RubyHighlighter.COLON);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tCOLON2, (TextAttributesKey)RubyHighlighter.COLON);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tCOLON3, (TextAttributesKey)RubyHighlighter.COLON);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tSEMICOLON, (TextAttributesKey)RubyHighlighter.SEMICOLON);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tLINE_CONTINUATION, (TextAttributesKey)RubyHighlighter.LINE_CONTINUATION);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tIDENTIFIER, (TextAttributesKey)RubyHighlighter.IDENTIFIER);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tFID, (TextAttributesKey)RubyHighlighter.IDENTIFIER);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tCONSTANT, (TextAttributesKey)RubyHighlighter.CONSTANT);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tCVAR, (TextAttributesKey)RubyHighlighter.CVAR);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tGVAR, (TextAttributesKey)RubyHighlighter.GVAR);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tIVAR, (TextAttributesKey)RubyHighlighter.IVAR);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tESCAPE_SEQUENCE, (TextAttributesKey)RubyHighlighter.ESCAPE_SEQUENCE);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tASSOC, (TextAttributesKey)RubyHighlighter.HASH_ASSOC);
        RubySyntaxHighlighter.safeMap(map, (TokenSet)TokenBNF.tSTRING_DELIMITERS, (TextAttributesKey)RubyHighlighter.SIMPLE_STRING);
        RubySyntaxHighlighter.safeMap(map, (IElementType)tSTRING_CONTENT, (TextAttributesKey)RubyHighlighter.SIMPLE_STRING);
        Map<IElementType, TextAttributesKey> map2 = Collections.unmodifiableMap(map);
        if (map2 == null) {
            RubySyntaxHighlighter.$$$reportNull$$$0(1);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/lang/highlighter/RubySyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

