/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter.processors;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyRubocopCommentDetector;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyWrappingUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;

public class RubyWrapProcessor
extends RubyFormattingProcessor {
    public RubyWrapProcessor(CommonCodeStyleSettings settings) {
        super(settings);
    }

    @Nullable
    public Wrap getChildWrap(@NotNull RubyBlock parent, @Nullable ASTNode prevChild, @NotNull ASTNode child) {
        if (parent == null) {
            RubyWrapProcessor.$$$reportNull$$$0(0);
        }
        if (child == null) {
            RubyWrapProcessor.$$$reportNull$$$0(1);
        }
        if (!this.mySettings.KEEP_LINE_BREAKS) {
            return null;
        }
        PsiElement psiParent = parent.getNode().getPsi();
        IElementType parentElementType = parent.getNode().getElementType();
        PsiElement grandPa = psiParent.getParent();
        if (grandPa != null && grandPa.getNode() != null && grandPa.getNode().getElementType() == RubyElementTypes.EMBEDDED_RUBY_CODE) {
            return null;
        }
        PsiElement psiChild = child.getPsi();
        IElementType childType = child.getElementType();
        if (RubyWrappingUtil.isNotWrapped(childType)) {
            if (prevChild != null && prevChild.getPsi() instanceof PsiComment) {
                return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
            }
            return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
        }
        if (RubyWrappingUtil.isWrappedAlways(childType)) {
            if (RubyWrappingUtil.getFORMAT_STRUCTURE_TYPES().contains(childType)) {
                if ((parentElementType == RubyElementTypes.COMPOUND_STATEMENT || parentElementType == RubyElementTypes.BODY_STATEMENT || RubyCommonPsiUtil.isContainer(psiParent)) && !RubyCommonPsiUtil.isEndlessMethod(psiParent)) {
                    return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
                }
            } else {
                return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
            }
        }
        if (RubyWrappingUtil.isWrappedCOMPSTMT(parentElementType)) {
            ASTNode grandparent = parent.getNode().getTreeParent();
            IElementType grandparentType = (IElementType)ObjectUtils.doIfNotNull((Object)grandparent, ASTNode::getElementType);
            if (!(childType != RubyElementTypes.COMPOUND_STATEMENT || parentElementType == RubyElementTypes.BODY_STATEMENT && RubyCommonPsiUtil.isEndlessMethod(grandPa))) {
                if (RubyRubocopCommentDetector.firstChildIsRubocopComment(psiChild)) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                if (prevChild != null && (prevChild.getElementType() == RubyTokenTypes.kTHEN && parent.getParentBlock() != null && parent.getParentBlock().getNode().getElementType() == RubyElementTypes.CASE_STATEMENT || prevChild.getElementType() == RubyTokenTypes.kELSE && parentElementType == RubyElementTypes.ELSE_BLOCK && grandparentType == RubyElementTypes.CASE_STATEMENT && RubyWrapProcessor.allWhenCasesContainsThenKeyword(grandPa.getChildren()))) {
                    return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)true);
                }
                return Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
            }
        }
        return null;
    }

    private static boolean allWhenCasesContainsThenKeyword(PsiElement @NotNull [] childElements) {
        if (childElements == null) {
            RubyWrapProcessor.$$$reportNull$$$0(2);
        }
        boolean hasWhenCases = false;
        for (PsiElement element : childElements) {
            if (!RubyCommonPsiUtil.isWhenCase(element)) continue;
            hasWhenCases = true;
            if (element.getNode().findChildByType(RubyTokenTypes.kTHEN) != null) continue;
            return false;
        }
        return hasWhenCases;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElements";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyWrapProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildWrap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "allWhenCasesContainsThenKeyword";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

