/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter.processors;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyRubocopCommentDetector;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubySpacingUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.Ruby19ElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.RubyTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;

public class RubySpacingProcessor
extends RubyFormattingProcessor
implements TokenBNF,
Ruby19TokenTypes {
    private static final TokenSet RUBY_WHITE_SPACE = RubySpaceUtil.SOFT_WHITESPACES;
    private static final TokenSet P_REF = TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.P_VAR_REF, RubyElementTypes.P_EXPR_REF});
    public static final NotNullLazyValue<TokenSet> POSSIBLE_SINGLE_LINERS = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.CLASS, RubyElementTypes.OBJECT_CLASS, RubyElementTypes.METHOD, RubyElementTypes.SINGLETON_METHOD}));
    public static final TokenSet NO_SPACING_BEFORE = TokenSet.create((IElementType[])new IElementType[]{tSEMICOLON, tCOMMA, tCOLON2, tDOT, tDOTQ});
    private final SpacingBuilder mySpacingBuilder = this.createSpacingBuilder();

    public RubySpacingProcessor(CommonCodeStyleSettings settings) {
        super(settings);
    }

    @Nullable
    public Spacing getSpacing(@NotNull Block parentBlock, @Nullable Block leftBlock, @NotNull Block rightBlock) {
        PsiElement lastLeaf;
        if (parentBlock == null) {
            RubySpacingProcessor.$$$reportNull$$$0(0);
        }
        if (rightBlock == null) {
            RubySpacingProcessor.$$$reportNull$$$0(1);
        }
        ASTNode leftChild = RubySpacingUtil.extractNode(leftBlock);
        ASTNode rightChild = RubySpacingUtil.extractNode(rightBlock);
        if (leftChild == null || rightChild == null) {
            return null;
        }
        ASTNode parent = leftChild.getTreeParent();
        IElementType leftType = leftChild.getElementType();
        IElementType rightType = rightChild.getElementType();
        IElementType parentType = parent.getElementType();
        if (rightType == kEND && (leftType == tSEMICOLON || leftType == tRPAREN) && ((TokenSet)POSSIBLE_SINGLE_LINERS.get()).contains(parentType)) {
            boolean isSingleLine = this.myRubySettings.EMPTY_DECLARATIONS_STYLE == 1;
            boolean isMultiLine = this.myRubySettings.EMPTY_DECLARATIONS_STYLE == 2;
            boolean isAsIs = this.myRubySettings.EMPTY_DECLARATIONS_STYLE == 0;
            return Spacing.createSpacing((int)1, (int)1, (int)(isMultiLine ? 1 : 0), (!isSingleLine && (isAsIs || this.mySettings.KEEP_LINE_BREAKS) ? 1 : 0) != 0, (int)(isSingleLine ? 0 : this.mySettings.KEEP_BLANK_LINES_IN_CODE));
        }
        if (!(leftType != tASSGN && rightType != tASSGN || parentType != RubyElementTypes.METHOD && parentType != RubyElementTypes.SINGLETON_METHOD)) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        Spacing spacingFromBuilder = this.mySpacingBuilder.getSpacing(parentBlock, leftBlock, rightBlock);
        if (spacingFromBuilder != null) {
            return spacingFromBuilder;
        }
        if (tNUMBERS.contains(leftType) && rightType == tIDENTIFIER && (parentType == RubyElementTypes.INTEGER || parentType == RubyElementTypes.FLOAT)) {
            return null;
        }
        boolean keepLineBreaks = this.mySettings.KEEP_LINE_BREAKS;
        if (!keepLineBreaks && RubySpaceUtil.isEol(lastLeaf = RubyCommonPsiUtil.getSignificantLeafToTheLeft(PsiTreeUtil.prevLeaf((PsiElement)rightChild.getPsi()), RUBY_WHITE_SPACE))) {
            keepLineBreaks = true;
        }
        if (!(leftType != RubyElementTypes.METHOD && leftType != RubyElementTypes.SINGLETON_METHOD || RubyTokenSets.getTMOD_KEYWORDS().contains(rightChild.getElementType()))) {
            int blankLines = this.mySettings.BLANK_LINES_AROUND_METHOD + 1;
            return Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
        if (leftType == tPIPE && tPIPES.contains(rightType)) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
        if (!(rightType != RubyElementTypes.METHOD && rightType != RubyElementTypes.SINGLETON_METHOD || leftChild instanceof PsiComment || !this.myRubySettings.FORCE_NEWLINES_AROUND_VISIBILITY_MODS && RubySpacingProcessor.isAccessModifier(leftBlock))) {
            return Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AROUND_METHOD + 1), (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
        if (!(leftType != RubyElementTypes.CLASS && leftType != RubyElementTypes.OBJECT_CLASS || RubyTokenSets.getTMOD_KEYWORDS().contains(rightType))) {
            int blankLines = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
            return Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
        if (!(rightType != RubyElementTypes.CLASS && rightType != RubyElementTypes.OBJECT_CLASS || leftChild instanceof PsiComment)) {
            int blankLines = this.mySettings.BLANK_LINES_AROUND_CLASS + 1;
            return Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
        if (this.myRubySettings.FORCE_NEWLINES_AROUND_VISIBILITY_MODS && (leftType == RubyElementTypes.IDENTIFIER && RubySpacingProcessor.isAccessModifier(leftBlock) || rightType == RubyElementTypes.IDENTIFIER && RubySpacingProcessor.isAccessModifier(rightBlock))) {
            int blankLines = Math.max(2, this.mySettings.BLANK_LINES_AROUND_METHOD + 1);
            return Spacing.createSpacing((int)0, (int)0, (int)blankLines, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_DECLARATIONS);
        }
        if (leftType == tCOMMA) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (NO_SPACING_BEFORE.contains(rightType)) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLineBreaks, (int)0);
        }
        if (rightChild.getElementType() == RubyElementTypes.CONDITION) {
            if (leftType == TLINE_COMMENT) {
                return null;
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (RubySpacingProcessor.isInString(leftChild, rightChild) || RubySpacingProcessor.isInHeredoc(leftType, rightType) || RubySpacingProcessor.isInRegexp(leftType, rightType) || RubySpacingProcessor.isInWords(leftType, rightType) || RubySpacingProcessor.isInSymbols(leftType, rightType)) {
            return null;
        }
        if (leftType == RubyElementTypes.HEREDOC_VALUE) {
            return null;
        }
        if (tEXPR_SUBT_TOKENS.contains(leftType) || leftType == RubyElementTypes.EXPR_SUBTITUTION || tEXPR_SUBT_TOKENS.contains(rightType) || rightType == RubyElementTypes.EXPR_SUBTITUTION) {
            return null;
        }
        if (rightType == tCOLON && leftType == RubyElementTypes.IDENTIFIER && parent.getElementType() == RubyElementTypes.NAMED_ARGUMENT) {
            return null;
        }
        if (tLBRACES.contains(leftType) && (RubyElementTypes.COMPOUND_STATEMENT == rightType || tPIPES.contains(rightType)) || tRBRACE == rightType && RubyElementTypes.COMPOUND_STATEMENT == leftType) {
            int spaces = this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (parentType == RubyElementTypes.ARRAY && (leftType == tLBRACK && rightType == RubyElementTypes.LIST_OF_EXPRESSIONS || leftType == RubyElementTypes.LIST_OF_EXPRESSIONS && rightType == tRBRACK)) {
            int spaces = this.myRubySettings.SPACE_WITHIN_ARRAY_LITERALS ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (tLBRACKS.contains(leftType) || tRBRACK == rightType || tLPARENS.contains(leftType) || tRPAREN == rightType) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (parentType == RubyElementTypes.BRACE_CODE_BLOCK && (tLBRACES.contains(leftType) || tRBRACE == rightType)) {
            int spaces = this.mySettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES && !RubySpacingProcessor.isEmptyHash(leftType, rightType) ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (tLBRACES.contains(leftType) || tRBRACE == rightType) {
            int spaces = this.mySettings.SPACE_WITHIN_BRACES && !RubySpacingProcessor.isEmptyHash(leftType, rightType) ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (tPIPE == leftType && RubyElementTypes.BLOCK_ARGUMENT_LIST == rightType || tPIPES.contains(rightType) && RubyElementTypes.BLOCK_ARGUMENT_LIST == leftType) {
            int spaces = this.myRubySettings.SPACE_WITHIN_PIPES ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (tLBRACES.contains(rightType) || tLBRACKS.contains(rightType) || tLPARENS.contains(rightType)) {
            return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (leftType == tCOLON3) {
            return null;
        }
        if (tDOT_OR_COLON.contains(leftType)) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (tRANGE_TOKENS.contains(leftType) || tRANGE_TOKENS.contains(rightType)) {
            int spaces = this.myRubySettings.SPACE_AROUND_RANGE_OPERATORS ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (tMATCH_OPS.contains(leftType) || tMATCH_OPS.contains(rightType)) {
            int spaces = this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (OTHER_BINARY_OPERATORS.contains(leftType) || OTHER_BINARY_OPERATORS.contains(rightType) || List.of(leftType, rightType).contains(tASSOC) && parentType == RubyElementTypes.IN_MATCH) {
            int spaces = this.myRubySettings.SPACE_AROUND_OTHER_OPERATORS ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (leftType == tASSOC || rightType == tASSOC) {
            int spaces = this.myRubySettings.SPACE_AROUND_HASHROCKET ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (tASSGNS.contains(leftType) || tASSGNS.contains(rightType)) {
            int spaces = this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS ? 1 : 0;
            return Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (tUNARY_OPS.contains(leftType) && leftType != kNOT) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (leftType == tSYMBEG || leftType == tSTAR || leftType == tAMPER || leftType == tDOUBLE_STAR || leftType == Ruby19ElementTypes.ASSOC_KEY && rightType == tCOLON) {
            return null;
        }
        if (rightType == RubyElementTypes.BODY_STATEMENT) {
            PsiElement compoundStatement = rightChild.getPsi();
            if (compoundStatement != null && RubyRubocopCommentDetector.firstChildIsRubocopComment(compoundStatement.getFirstChild())) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (leftType == tSEMICOLON) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (RubySpacingUtil.isEolFollowing(leftChild) || leftType == TLINE_COMMENT) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (leftType == RubyElementTypes.NAME && rightType == kEND) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)keepLineBreaks, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    @NotNull
    private SpacingBuilder createSpacingBuilder() {
        SpacingBuilder spacingBuilder = new SpacingBuilder(this.mySettings).beforeInside(tCOLON, Ruby19ElementTypes.ASSOC_KEY).spaces(0).afterInside((IElementType)RubyElementTypes.CONSTANT, RubyElementTypes.P_ARRAY_PATTERN).spaces(0).afterInside((IElementType)RubyElementTypes.CONSTANT, RubyElementTypes.P_HASH_PATTERN).spaces(0).afterInside(tXOR, P_REF).spaces(0).around(tPOW).spaceIf(this.myRubySettings.SPACE_AROUND_POW_OPERATORS).before(kEND).lineBreakInCode();
        if (spacingBuilder == null) {
            RubySpacingProcessor.$$$reportNull$$$0(2);
        }
        return spacingBuilder;
    }

    private static boolean isInSymbols(IElementType leftType, IElementType rightType) {
        return !(!tSYMBOLS_TOKENS.contains(leftType) && leftType != RubyElementTypes.EXPR_SUBTITUTION || !tSYMBOLS_TOKENS.contains(rightType) && rightType != RubyElementTypes.EXPR_SUBTITUTION);
    }

    private static boolean isInWords(IElementType leftType, IElementType rightType) {
        return !(!tWORDS_TOKENS.contains(leftType) && leftType != RubyElementTypes.EXPR_SUBTITUTION || !tWORDS_TOKENS.contains(rightType) && rightType != RubyElementTypes.EXPR_SUBTITUTION);
    }

    private static boolean isInRegexp(IElementType leftType, IElementType rightType) {
        return !(!tREGEXP_TOKENS.contains(leftType) && leftType != RubyElementTypes.EXPR_SUBTITUTION || !tREGEXP_TOKENS.contains(rightType) && rightType != RubyElementTypes.EXPR_SUBTITUTION);
    }

    private static boolean isInHeredoc(IElementType leftType, IElementType rightType) {
        if (leftType == RubyElementTypes.HEREDOC_ID && (rightType == tHEREDOC_END || rightType == tHEREDOC_INDENTED_END)) {
            return true;
        }
        return !(!tSTRING_TOKENS.contains(leftType) && leftType != tHEREDOC_CONTENT || !tSTRING_TOKENS.contains(rightType) && rightType != tHEREDOC_CONTENT);
    }

    private static boolean isInString(@NotNull ASTNode leftChild, @NotNull ASTNode rightChild) {
        if (leftChild == null) {
            RubySpacingProcessor.$$$reportNull$$$0(3);
        }
        if (rightChild == null) {
            RubySpacingProcessor.$$$reportNull$$$0(4);
        }
        IElementType leftType = leftChild.getElementType();
        IElementType rightType = rightChild.getElementType();
        return !(!tSTRING_TOKENS.contains(leftType) && leftType != RubyElementTypes.EXPR_SUBTITUTION || !tSTRING_TOKENS.contains(rightType) && rightType != RubyElementTypes.EXPR_SUBTITUTION);
    }

    private static boolean isEmptyHash(@Nullable IElementType leftType, @Nullable IElementType rightType) {
        return leftType == tLBRACE && rightType == tRBRACE;
    }

    private static boolean isAccessModifier(@NotNull Block leftBlock) {
        if (leftBlock == null) {
            RubySpacingProcessor.$$$reportNull$$$0(5);
        }
        return RubySpacingUtil.isVisibilityCall(leftBlock, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubySpacingProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftChild";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightChild";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubySpacingProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpacingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAccessModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

