/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter.processors;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyCompositeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyFormattingTokenSets;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.Ruby19ElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.LexicalBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementPatterns;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.settings.RubyBinaryExpressionAlignmentOptions;

public final class RubyAlignmentProcessor
extends RubyFormattingProcessor {
    public static final IElementType MULTILINE_PARAMS = new IElementType("MULTILINE_PARAMS", null);
    public static final IElementType ASSIGN_OR_ASSOC_RIGHT = new IElementType("ASSIGN_OR_ASSOC_RIGHT", null);
    public static final IElementType ALIGN_MULTILINE_COMMENTS = new IElementType("ALIGN_MULTILINE_COMMENTS", null);
    public static final IElementType ALIGN_CONTROL_STATEMENTS = new IElementType("ALIGN_CONTROL_STRUCTURES_ETC", null);
    public static final IElementType ALIGN_MULTILINE_BINARY_OPERATION = new IElementType("ALIGN_MULTILINE_BINARY_OPERATION", null);
    private static final NotNullLazyValue<TokenSet> CHAIN_CALL_ELEMENTS = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.BRACE_BLOCK_CALL, RubyElementTypes.DO_BLOCK_CALL, RubyElementTypes.DOT_REFERENCE}));
    private static final NotNullLazyValue<TokenSet> VISIBILITY_MODIFIERS_ALIGN_PARENTS = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])((IElementType[])ArrayUtil.append((Object[])RubyElementPatterns.getCLASS_LIKE_CONTAINERS().getTypes(), (Object)RubyElementTypes.DO_BLOCK_CALL))));
    @NotNull
    private final FormattingMode myFormattingMode;
    @NotNull
    private final Map<ASTNode, Alignment> myBaseAlignmentsMap;

    public RubyAlignmentProcessor(CommonCodeStyleSettings settings, @NotNull FormattingMode formattingMode) {
        if (formattingMode == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(0);
        }
        super(settings);
        this.myBaseAlignmentsMap = new HashMap<ASTNode, Alignment>();
        this.myFormattingMode = formattingMode;
    }

    public AlignmentStrategy createChildrenAlignmentStrategy(@NotNull ASTNode node) {
        IElementType parentType;
        ASTNode parent;
        if (node == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(1);
        }
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        HashMap<IElementType, Boolean> params = new HashMap<IElementType, Boolean>();
        IElementType type = node.getElementType();
        if (this.mySettings.ALIGN_MULTILINE_PARAMETERS) {
            if (type == RubyElementTypes.ASSOC_LIST) {
                types.add(MULTILINE_PARAMS);
            }
            if ((type == RubyElementTypes.FUNCTION_ARGUMENT_LIST || type == RubyElementTypes.COMMAND_ARGUMENT_LIST) && (parent = node.getTreeParent()) != null && RubyElementTypes.METHOD == parent.getElementType()) {
                types.add(MULTILINE_PARAMS);
            }
            if (type == RubyElementTypes.METHOD) {
                types.add(RubyElementTypes.FUNCTION_ARGUMENT_LIST);
            }
            if (type == RubyElementTypes.CALL) {
                types.add(RubyElementTypes.LIST_OF_EXPRESSIONS);
            }
            if (type == RubyElementTypes.LIST_OF_EXPRESSIONS && (parent = node.getTreeParent()) != null && ((parentType = parent.getElementType()) == RubyElementTypes.CALL || parentType == RubyElementTypes.ARRAY || parentType == RubyElementTypes.ARRAY_REFERENCE)) {
                types.add(MULTILINE_PARAMS);
            }
        }
        if (this.mySettings.ALIGN_GROUP_FIELD_DECLARATIONS) {
            if (type == RubyElementTypes.ASSOC_LIST || type == RubyElementTypes.COMPOUND_STATEMENT) {
                params.put(ASSIGN_OR_ASSOC_RIGHT, true);
            }
            if (type == RubyElementTypes.LIST_OF_EXPRESSIONS && (parent = node.getTreeParent()) != null && ((parentType = parent.getElementType()) == RubyElementTypes.CALL || parentType == RubyElementTypes.ARRAY || parentType == RubyElementTypes.ARRAY_REFERENCE)) {
                params.put(ASSIGN_OR_ASSOC_RIGHT, true);
            }
        }
        if (type == RubyElementTypes.IF_STATEMENT || type == RubyElementTypes.UNLESS_STATEMENT || type == RubyElementTypes.WHILE_STATEMENT || type == RubyElementTypes.UNTIL_STATEMENT || type == RubyElementTypes.CASE_STATEMENT) {
            types.add(ALIGN_CONTROL_STATEMENTS);
        }
        if (this.myRubySettings.BINARY_EXPRESSIONS_ALIGNMENT == RubyBinaryExpressionAlignmentOptions.ALIGN.ordinal() && ((TokenSet)RubyFormattingTokenSets.BINARY_EXPRESSION_ELEMENTS.get()).contains(type) && (parent = node.getTreeParent()) != null) {
            IElementType grandParentType;
            parentType = parent.getElementType();
            if (parentType == RubyElementTypes.CONDITION || RubyAlignmentProcessor.isAssignmentExpr(parentType)) {
                types.add(ALIGN_MULTILINE_BINARY_OPERATION);
            }
            ASTNode grandParent = parent.getTreeParent();
            if (parentType == RubyElementTypes.LIST_OF_EXPRESSIONS && grandParent != null && ((grandParentType = grandParent.getElementType()) == RubyElementTypes.CALL || grandParentType == RubyElementTypes.RETURN_STATEMENT)) {
                types.add(ALIGN_MULTILINE_BINARY_OPERATION);
            }
        }
        types.add(ALIGN_MULTILINE_COMMENTS);
        for (IElementType elementType : types) {
            params.put(elementType, false);
        }
        return new AlignmentPerTypeStrategy(params, false, Alignment.Anchor.LEFT);
    }

    @Nullable
    public Alignment getChildAlignment(@NotNull RubyBlock block, ASTNode parent, ASTNode child, @Nullable ASTNode prevChildNode, @Nullable AlignmentStrategy alignmentStrategy) {
        RubyBlock parentBlock;
        ASTNode dotReference;
        if (block == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(2);
        }
        IElementType parentType = parent.getElementType();
        IElementType childType = child.getElementType();
        if (RubyBlock.isNonIndentableNode(child)) {
            return null;
        }
        if (!this.myRubySettings.INDENT_VISIBILITY_MODIFIERS) {
            Alignment alignment;
            if (((TokenSet)VISIBILITY_MODIFIERS_ALIGN_PARENTS.get()).contains(childType)) {
                return this.getNodeBaseAlignment(child);
            }
            PsiElement childPsi = child.getPsi();
            if (RubyCommonPsiUtil.isNonInlinedVisibilityModifier(childPsi) && (alignment = this.getNodeBaseAlignment(TreeUtil.findParent((ASTNode)child, (TokenSet)((TokenSet)VISIBILITY_MODIFIERS_ALIGN_PARENTS.get())))) != null) {
                return alignment;
            }
        }
        if (RubyElementTypes.DO_BLOCK_CALL != parentType && ((TokenSet)CHAIN_CALL_ELEMENTS.get()).contains(parentType) && (childType == RubyTokenTypes.tDOT && this.myRubySettings.CHAIN_CALLS_ALIGNMENT == 2 || this.myRubySettings.CHAIN_CALLS_ALIGNMENT == 1) && (dotReference = RubyAlignmentProcessor.getTopmostChainCallElement(child)) != null) {
            return this.getNodeBaseAlignment(dotReference);
        }
        if (this.mySettings.ALIGN_MULTILINE_PARAMETERS) {
            Alignment alignment;
            if (parentType == RubyElementTypes.FUNCTION_ARGUMENT_LIST) {
                return this.getNodeBaseAlignment(parent);
            }
            if (!TokenBNF.tLBRACES.contains(childType) && childType != RubyElementTypes.METHOD && childType != RubyElementTypes.SINGLETON_METHOD && childType != RubyTokenTypes.tRBRACE && childType != RubyTokenTypes.tCOMMA && (alignment = alignmentStrategy.getAlignment(MULTILINE_PARAMS)) != null) {
                return alignment;
            }
            IElementType prevNodeType = PsiUtilCore.getElementType((ASTNode)prevChildNode);
            if (parentType == RubyElementTypes.METHOD && (childType == RubyElementTypes.FUNCTION_ARGUMENT_LIST || this.myFormattingMode != FormattingMode.REFORMAT && childType == RubyTokenTypes.tRPAREN && prevNodeType == RubyElementTypes.FUNCTION_ARGUMENT_LIST && RubyBlock.isIncomplete(prevChildNode))) {
                return alignmentStrategy.getAlignment(RubyElementTypes.FUNCTION_ARGUMENT_LIST);
            }
            if (parentType == RubyElementTypes.CALL && (childType == RubyElementTypes.LIST_OF_EXPRESSIONS && prevNodeType == RubyTokenTypes.tfLPAREN || this.myFormattingMode != FormattingMode.REFORMAT && childType == RubyTokenTypes.tRPAREN && prevNodeType == RubyElementTypes.LIST_OF_EXPRESSIONS && RubyBlock.isIncomplete(prevChildNode))) {
                return alignmentStrategy.getAlignment(RubyElementTypes.LIST_OF_EXPRESSIONS);
            }
        }
        if (this.mySettings.ALIGN_GROUP_FIELD_DECLARATIONS && (parentBlock = RubyAlignmentProcessor.getBlockWithAlignment(block, childType)) != null) {
            if (RubyAlignmentProcessor.isAssignmentExpr(parentType) || parentType == RubyElementTypes.ASSOC) {
                if (TokenBNF.tASSGNS.contains(childType) || childType == RubyTokenTypes.tASSGN || childType == RubyTokenTypes.tASSOC || parentType == RubyElementTypes.ASSOC && RubyAlignmentProcessor.isRuby19Assoc(parent) && child.getTreeNext() == null) {
                    if (!RubyAlignmentProcessor.isSingleLineDistance(parent)) {
                        RubyAlignmentProcessor.renewAlignment(parentBlock);
                    }
                    if (childType != RubyElementTypes.ASSOC_LIST && childType != RubyTokenTypes.tCOLON) {
                        return parentBlock.getChildrenAlignmentStrategy().getAlignment(ASSIGN_OR_ASSOC_RIGHT);
                    }
                }
            } else {
                if (parentType == RubyElementTypes.ASSOC_LIST && childType == RubyTokenTypes.tLBRACE && parent.getTreeParent() != null && parent.getTreeParent().getElementType() == RubyElementTypes.ASSOC && RubyAlignmentProcessor.isRuby19Assoc(parent)) {
                    return parentBlock.getParentBlock().getChildrenAlignmentStrategy().getAlignment(ASSIGN_OR_ASSOC_RIGHT);
                }
                if (!(!(parentType instanceof RubyElementType) && !RubyElementTypes.STUB_ELEMENT_TYPES.contains(parentType) || LexicalBNF.MOD_STATEMENTS.contains(parentType) && RubyAlignmentProcessor.isAssignmentExpr(parent.getFirstChildNode().getElementType()))) {
                    RubyAlignmentProcessor.renewAlignment(parentBlock);
                }
            }
        }
        if (this.mySettings.getIndentOptions().USE_RELATIVE_INDENTS) {
            if (!(parentType != RubyElementTypes.IF_STATEMENT && parentType != RubyElementTypes.UNLESS_STATEMENT && parentType != RubyElementTypes.WHILE_STATEMENT && parentType != RubyElementTypes.UNTIL_STATEMENT || childType != RubyTokenTypes.kIF && childType != RubyTokenTypes.kUNLESS && childType != RubyTokenTypes.kWHILE && childType != RubyTokenTypes.kUNTIL && childType != RubyTokenTypes.kEND && childType != RubyElementTypes.ELSE_BLOCK && childType != RubyElementTypes.ELSIF_BLOCK)) {
                return alignmentStrategy.getAlignment(ALIGN_CONTROL_STATEMENTS);
            }
            if (parentType == RubyElementTypes.CASE_STATEMENT) {
                if (childType == RubyTokenTypes.kCASE || childType == RubyTokenTypes.kEND) {
                    return alignmentStrategy.getAlignment(ALIGN_CONTROL_STATEMENTS);
                }
                if (!(this.myRubySettings.INDENT_WHEN_CASES || childType != RubyElementTypes.WHEN_CASE && childType != RubyElementTypes.ELSE_BLOCK)) {
                    return alignmentStrategy.getAlignment(ALIGN_CONTROL_STATEMENTS);
                }
            }
        }
        if (childType == RubyTokenTypes.TLINE_COMMENT) {
            if (RubyAlignmentProcessor.isTrailingComment(child) || RubyAlignmentProcessor.isFirstCommentInBlockOnSameLine(child)) {
                return null;
            }
            if (!RubyAlignmentProcessor.isSingleLineDistance(child) && alignmentStrategy instanceof AlignmentStrategy.AlignmentPerTypeStrategy) {
                ((AlignmentStrategy.AlignmentPerTypeStrategy)alignmentStrategy).renewAlignment(ALIGN_MULTILINE_COMMENTS);
            }
            return alignmentStrategy.getAlignment(ALIGN_MULTILINE_COMMENTS);
        }
        if (this.myRubySettings.BINARY_EXPRESSIONS_ALIGNMENT == RubyBinaryExpressionAlignmentOptions.ALIGN.ordinal() && ((TokenSet)RubyFormattingTokenSets.BINARY_EXPRESSION_ELEMENTS.get()).contains(parentType)) {
            RubyBlock topmostBlock = RubyFormattingUtil.findTopmostBinaryExpressionBlock(block);
            return Objects.requireNonNull(topmostBlock.getChildrenAlignmentStrategy()).getAlignment(ALIGN_MULTILINE_BINARY_OPERATION);
        }
        return null;
    }

    private static boolean isRuby19Assoc(@NotNull ASTNode node) {
        if (node == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(3);
        }
        if (node.getElementType() == RubyElementTypes.ASSOC) {
            return node.findChildByType(Ruby19ElementTypes.ASSOC_KEY) != null;
        }
        return PsiTreeUtil.findSiblingBackward((PsiElement)node.getPsi(), (IElementType)Ruby19ElementTypes.ASSOC_KEY, null) != null;
    }

    @Contract(value="null->null;!null->!null")
    private Alignment getNodeBaseAlignment(@Nullable ASTNode astNode) {
        return astNode == null ? null : this.myBaseAlignmentsMap.computeIfAbsent(astNode, it -> Alignment.createAlignment());
    }

    @Nullable
    public Alignment getNewChildAlignment(@NotNull RubyCompositeBlock rubyBlock) {
        ASTNode firstNode;
        if (rubyBlock == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(4);
        }
        if (PsiUtilCore.getElementType((ASTNode)(firstNode = rubyBlock.getFirstNode()).getTreeParent()) == RubyElementTypes.DOT_REFERENCE && this.myRubySettings.CHAIN_CALLS_ALIGNMENT == 1) {
            return this.getNodeBaseAlignment(RubyAlignmentProcessor.getTopmostChainCallElement(firstNode));
        }
        return null;
    }

    @Nullable
    public Alignment getNewChildAlignment(@NotNull RubyBlock rubyBlock, int newChildIndex) {
        if (rubyBlock == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(5);
        }
        IElementType blockNodeType = ASTBlock.getElementType((Block)rubyBlock);
        if (this.mySettings.ALIGN_MULTILINE_PARAMETERS) {
            PsiElement lastLeaf;
            if (blockNodeType == RubyElementTypes.FUNCTION_ARGUMENT_LIST) {
                return this.getNodeBaseAlignment(ASTBlock.getNode((Block)rubyBlock));
            }
            List<Block> subBlocks = rubyBlock.getSubBlocks();
            if (0 < newChildIndex && newChildIndex <= subBlocks.size() && (lastLeaf = RubyBlock.getLastSignificantLeaf(subBlocks.get(newChildIndex - 1))) != null && lastLeaf.getNode().getElementType() == RubyTokenTypes.tCOMMA) {
                PsiElement parent = lastLeaf.getParent();
                IElementType parentType = PsiUtilCore.getElementType((PsiElement)parent);
                IElementType grandparentType = (IElementType)ObjectUtils.doIfNotNull((Object)parent.getParent(), PsiUtilCore::getElementType);
                if (parentType == RubyElementTypes.LIST_OF_EXPRESSIONS && (grandparentType == RubyElementTypes.CALL || grandparentType == RubyElementTypes.ARRAY) || parentType == RubyElementTypes.ASSOC_LIST || parentType == RubyElementTypes.FUNCTION_ARGUMENT_LIST) {
                    RubyBlock block = RubyAlignmentProcessor.findBlockForElement((Block)rubyBlock, newChildIndex - 1, parent);
                    assert (block != null);
                    return Objects.requireNonNull(block.getChildrenAlignmentStrategy()).getAlignment(MULTILINE_PARAMS);
                }
            }
        }
        if (this.myRubySettings.BINARY_EXPRESSIONS_ALIGNMENT == RubyBinaryExpressionAlignmentOptions.ALIGN.ordinal() && ((TokenSet)RubyFormattingTokenSets.BINARY_EXPRESSION_ELEMENTS.get()).contains(blockNodeType)) {
            RubyBlock topmostBlock = RubyFormattingUtil.findTopmostBinaryExpressionBlock(rubyBlock);
            return Objects.requireNonNull(topmostBlock.getChildrenAlignmentStrategy()).getAlignment(ALIGN_MULTILINE_BINARY_OPERATION);
        }
        return null;
    }

    private static boolean isAssignmentExpr(@NotNull IElementType parentType) {
        if (parentType == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(6);
        }
        return parentType == RubyElementTypes.ASSIGNMENT_EXPRESSION || parentType == RubyElementTypes.SELF_ASSIGNMENT_EXPRESSION || parentType == RubyElementTypes.MULTI_ASSIGNMENT_EXPRESSION;
    }

    @Nullable
    private static RubyBlock getBlockWithAlignment(@NotNull RubyBlock block, @NotNull IElementType childType) {
        RubyBlock parentBlock;
        if (block == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(7);
        }
        if (childType == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(8);
        }
        if ((parentBlock = block.getParentBlock()) == null) {
            return null;
        }
        if (TokenBNF.tASSGNS.contains(childType) && LexicalBNF.MOD_STATEMENTS.contains(parentBlock.getNode().getElementType())) {
            return parentBlock.getParentBlock();
        }
        return parentBlock;
    }

    private static void renewAlignment(RubyBlock block) {
        AlignmentStrategy strategy = block.getChildrenAlignmentStrategy();
        if (strategy instanceof AlignmentPerTypeStrategy) {
            ((AlignmentPerTypeStrategy)strategy).renewAlignment(ASSIGN_OR_ASSOC_RIGHT);
        }
    }

    private static boolean isTrailingComment(@NotNull ASTNode comment) {
        ASTNode node;
        if (comment == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(9);
        }
        for (node = comment.getTreePrev(); node != null && node.getElementType() == RubyTokenTypes.tWHITE_SPACE; node = node.getTreePrev()) {
        }
        return node != null && !RubySpaceUtil.isAnyNewLine(node);
    }

    private static boolean isFirstCommentInBlockOnSameLine(@NotNull ASTNode comment) {
        ASTNode parentPrevNode;
        if (comment == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(10);
        }
        if (comment != comment.getTreeParent().getFirstChildNode()) {
            return false;
        }
        ASTNode parentNode = comment.getTreeParent();
        while ((parentPrevNode = parentNode.getTreePrev()) == null) {
            if ((parentNode = parentNode.getTreeParent()) != null) continue;
            return false;
        }
        return !parentPrevNode.textContains('\n');
    }

    private static boolean isSingleLineDistance(ASTNode child) {
        ASTNode node = child.getTreePrev();
        while (node != null) {
            if (RubyFormattingTokenSets.SINGLE_LINE_CHECK_ALLOWED_PREFIXES.contains(node.getElementType())) {
                ASTNode prevNode = node.getTreePrev();
                if (RubySpaceUtil.isMultiLineEol(node)) {
                    return false;
                }
                if (RubySpaceUtil.isSoftNewLine(node) && prevNode != null && prevNode.getElementType() != RubyTokenTypes.tCOMMA) {
                    return false;
                }
                node = prevNode;
                continue;
            }
            return true;
        }
        return true;
    }

    @Nullable
    private static RubyBlock findBlockForElement(@NotNull Block block, int anchorIndex, @NotNull PsiElement element) {
        int childIndex;
        if (block == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(11);
        }
        if (element == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(12);
        }
        if (block instanceof RubyBlock && ((RubyBlock)block).getNode().getPsi() == element) {
            return (RubyBlock)block;
        }
        List subBlocks = block.getSubBlocks();
        int n = childIndex = anchorIndex != -1 ? anchorIndex : subBlocks.size() - 1;
        while (childIndex >= 0) {
            RubyBlock result = RubyAlignmentProcessor.findBlockForElement((Block)subBlocks.get(childIndex), -1, element);
            if (result != null) {
                return result;
            }
            --childIndex;
        }
        return null;
    }

    @Nullable
    private static ASTNode getTopmostChainCallElement(@NotNull ASTNode node) {
        if (node == null) {
            RubyAlignmentProcessor.$$$reportNull$$$0(13);
        }
        ASTNode result = null;
        while (true) {
            ASTNode parent = node.getTreeParent();
            IElementType parentType = PsiUtilCore.getElementType((ASTNode)parent);
            if (!((TokenSet)CHAIN_CALL_ELEMENTS.get()).contains(parentType) && (parentType != RubyElementTypes.CALL && parentType != RubyElementTypes.ARRAY_REFERENCE || PsiUtilCore.getElementType((ASTNode)parent.getTreeParent()) != RubyElementTypes.DOT_REFERENCE)) break;
            node = parent;
            result = parent;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/processors/RubyAlignmentProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createChildrenAlignmentStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildAlignment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isRuby19Assoc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getNewChildAlignment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignmentExpr";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockWithAlignment";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isTrailingComment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isFirstCommentInBlockOnSameLine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "findBlockForElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopmostChainCallElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AlignmentPerTypeStrategy
    extends AlignmentStrategy {
        private final Map<IElementType, Alignment> myAlignments = new HashMap<IElementType, Alignment>();
        private final Map<IElementType, Boolean> myParams;
        private final boolean myAllowBackwardShifts;

        AlignmentPerTypeStrategy(Map<IElementType, Boolean> params, boolean allowBackwardShifts, Alignment.Anchor anchor) {
            this.myParams = params;
            this.myAllowBackwardShifts = allowBackwardShifts;
            for (Map.Entry<IElementType, Boolean> param : params.entrySet()) {
                this.myAlignments.put(param.getKey(), Alignment.createAlignment((boolean)param.getValue(), (Alignment.Anchor)anchor));
            }
        }

        public Alignment getAlignment(@Nullable IElementType parentType, @Nullable IElementType childType) {
            return this.myAlignments.get(childType);
        }

        public void renewAlignment(IElementType elementType) {
            Boolean allowBackwardShift = this.myParams.getOrDefault(elementType, this.myAllowBackwardShifts);
            this.myAlignments.put(elementType, Alignment.createAlignment((boolean)allowBackwardShift));
        }
    }
}

