/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.LazyInitializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyCaseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingHelper;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;

public final class RubyFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            RubyFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
        RubyBlock rootBlock = RubyFormattingModelBuilder.buildBlockFor(null, formattingContext.getNode(), (LazyInitializer.LazyValue<Indent>)LazyInitializer.create(Indent::getAbsoluteNoneIndent), null, null, new RubyFormattingHelper(settings, formattingContext), null);
        PsiFile file = formattingContext.getContainingFile();
        return new DocumentBasedFormattingModel((Block)rootBlock, file.getProject(), settings, file.getFileType(), file);
    }

    @Nullable
    public TextRange getRangeAffectingIndent(PsiFile file, int offset, ASTNode elementAtOffset) {
        PsiElement element = elementAtOffset.getPsi();
        if (element == null) {
            return null;
        }
        TextRange elementAtOffsetTextRange = elementAtOffset.getTextRange();
        TextRange chainCallsExtendedTextRange = RubyFormattingModelBuilder.handleSpaceAroundChainCalls(element, elementAtOffsetTextRange);
        if (chainCallsExtendedTextRange != null) {
            return chainCallsExtendedTextRange;
        }
        return null;
    }

    public static RubyBlock buildBlockFor(@Nullable RubyBlock parentBlock, @NotNull ASTNode node, @NotNull LazyInitializer.LazyValue<Indent> indent, @Nullable LazyInitializer.LazyValue<Wrap> wrap, @Nullable LazyInitializer.LazyValue<Alignment> alignment, @NotNull RubyFormattingHelper helper, @Nullable TextRange patchedTextRange) {
        if (node == null) {
            RubyFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        if (indent == null) {
            RubyFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        if (helper == null) {
            RubyFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        if (node.getElementType() == RubyElementTypes.CASE_STATEMENT) {
            return new RubyCaseBlock(parentBlock, node, indent, wrap, alignment, helper, patchedTextRange);
        }
        return new RubyBlock(parentBlock, node, indent, wrap, alignment, helper, patchedTextRange);
    }

    @Nullable
    private static TextRange handleSpaceAroundChainCalls(@NotNull PsiElement element, @NotNull TextRange elementTextRange) {
        PsiElement parentDotReference;
        if (element == null) {
            RubyFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        if (elementTextRange == null) {
            RubyFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        if ((parentDotReference = PsiTreeUtil.findFirstParent((PsiElement)element, elem -> PsiUtilCore.getElementType((PsiElement)elem) == RubyElementTypes.DOT_REFERENCE)) != null) {
            return parentDotReference.getTextRange();
        }
        PsiElement prevLeaf = RubyCommonPsiUtil.getPrevSignificantLeaf(element);
        PsiElement prevDotReference = PsiTreeUtil.findFirstParent((PsiElement)prevLeaf, elem -> PsiUtilCore.getElementType((PsiElement)elem) == RubyElementTypes.DOT_REFERENCE);
        if (prevDotReference != null) {
            return elementTextRange.union(prevDotReference.getTextRange());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTextRange";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyFormattingModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "buildBlockFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleSpaceAroundChainCalls";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

