/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.LazyChildAttributes;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyCompositeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.RubyFormattingModelBuilder;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyAdditionalSpacingProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubyFormattingHelper;
import org.jetbrains.plugins.ruby.ruby.lang.formatter.processors.RubySpacingUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementPatterns;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public class RubyBlock
implements ASTBlock {
    private static final TokenSet COMPOSITE_CALL_DELIMITERS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenBNF.tCALL, TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.tCOLON2})});
    private static final NotNullLazyValue<TokenSet> CONTAINERS_TO_LINEARISE = NotNullLazyValue.lazy(() -> TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.DOT_REFERENCE, RubyElementTypes.COLON_REFERENCE, RubyElementTypes.CALL, RubyElementTypes.BRACE_BLOCK_CALL}));
    @NotNull
    private final ASTNode myNode;
    @NotNull
    private final RubyFormattingHelper myHelper;
    @Nullable
    private final TextRange myPatchedTextRange;
    @NotNull
    private final LazyInitializer.LazyValue<Indent> myIndent;
    @Nullable
    private final LazyInitializer.LazyValue<Wrap> myWrap;
    @NotNull
    private final LazyInitializer.LazyValue<AlignmentStrategy> myChildrenAlignmentStrategy;
    @NotNull
    private final LazyInitializer.LazyValue<List<Block>> mySubBlocks;
    @Nullable
    private LazyInitializer.LazyValue<Alignment> myAlignment;
    @Nullable
    private RubyBlock myParentBlock;
    @NotNull
    private TextRange myTextRange;

    public RubyBlock(@Nullable RubyBlock parentBlock, @NotNull ASTNode node, @NotNull LazyInitializer.LazyValue<Indent> indent, @Nullable LazyInitializer.LazyValue<Wrap> wrap, @Nullable LazyInitializer.LazyValue<Alignment> alignment, @NotNull RubyFormattingHelper helper, @Nullable TextRange patchedTextRange) {
        if (node == null) {
            RubyBlock.$$$reportNull$$$0(0);
        }
        if (indent == null) {
            RubyBlock.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            RubyBlock.$$$reportNull$$$0(2);
        }
        this.myParentBlock = parentBlock;
        this.myNode = node;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.myAlignment = alignment;
        this.myHelper = helper;
        TextRange nodeTextRange = node.getTextRange();
        IElementType elementType = node.getElementType();
        if (elementType == RubyTokenTypes.tBLOCK_COMMENT && StringUtil.endsWith((CharSequence)node.getChars(), (CharSequence)"\n")) {
            nodeTextRange = TextRange.create((int)nodeTextRange.getStartOffset(), (int)(nodeTextRange.getEndOffset() - 1));
        }
        this.myPatchedTextRange = patchedTextRange;
        this.myTextRange = this.myPatchedTextRange != null ? nodeTextRange.intersection(patchedTextRange) : nodeTextRange;
        if (this.myTextRange == null) {
            this.myTextRange = new TextRange(0, -1);
        }
        this.mySubBlocks = LazyInitializer.create(this::generateSubBlocks);
        this.myChildrenAlignmentStrategy = LazyInitializer.create(() -> helper.getAlignmentProcessor().createChildrenAlignmentStrategy(this.myNode));
    }

    @Nullable
    public RubyBlock getParentBlock() {
        return this.myParentBlock;
    }

    public void setParentBlock(@Nullable RubyBlock parentBlock) {
        this.myParentBlock = parentBlock;
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            RubyBlock.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            RubyBlock.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List list = (List)this.mySubBlocks.get();
        if (list == null) {
            RubyBlock.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap != null ? (Wrap)this.myWrap.get() : null;
    }

    @Nullable
    public Indent getIndent() {
        return (Indent)this.myIndent.get();
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment != null ? (Alignment)this.myAlignment.get() : null;
    }

    @Nullable
    public AlignmentStrategy getChildrenAlignmentStrategy() {
        return (AlignmentStrategy)this.myChildrenAlignmentStrategy.get();
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            RubyBlock.$$$reportNull$$$0(6);
        }
        for (RubyAdditionalSpacingProcessor processor : RubyAdditionalSpacingProcessor.EP_NAME.getExtensionList()) {
            Spacing spacing = processor.getSpacing((Block)this, child1, child2);
            if (spacing == null) continue;
            return spacing;
        }
        return this.myHelper.getSpacingProcessor().getSpacing((Block)this, child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new LazyChildAttributes((LazyInitializer.LazyValue<Indent>)LazyInitializer.create(() -> this.myHelper.getIndentProcessor().getNewChildIndent(this, newChildIndex)), (LazyInitializer.LazyValue<Alignment>)LazyInitializer.create(() -> this.myHelper.getAlignmentProcessor().getNewChildAlignment(this, newChildIndex)));
    }

    public boolean isIncomplete() {
        return RubyBlock.isIncomplete(this.myNode);
    }

    public boolean isLeaf() {
        return RubyBlock.isLeaf(this.myNode);
    }

    private List<Block> generateSubBlocks() {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        ASTNode[] nodeChildren = this.myNode.getChildren(null);
        if (nodeChildren.length == 0) {
            return subBlocks;
        }
        int patchedEndOffset = this.myPatchedTextRange == null ? -1 : this.myPatchedTextRange.getEndOffset();
        ASTNode prevChildNode = null;
        for (ASTNode childNode : nodeChildren) {
            if (RubyBlock.isOuterElement(childNode)) {
                Block outerBlock = this.createOuterBlock(childNode);
                if (outerBlock == null) continue;
                subBlocks.add(outerBlock);
                continue;
            }
            if (!RubyBlock.canBeCorrectBlock(childNode)) continue;
            if (this.myPatchedTextRange != null && childNode.getStartOffset() >= patchedEndOffset) {
                return this.processSubBlocks(subBlocks);
            }
            this.processChildNode(subBlocks, prevChildNode, childNode);
            if (childNode.getElementType() == RubyTokenTypes.TLINE_COMMENT) continue;
            prevChildNode = childNode;
        }
        return this.processSubBlocks(subBlocks);
    }

    private List<Block> processSubBlocks(@NotNull List<Block> blocks) {
        if (blocks == null) {
            RubyBlock.$$$reportNull$$$0(7);
        }
        if (this.isInternalMethodWrappingNecessary()) {
            ArrayList<Block> newBlocks = new ArrayList<Block>();
            ArrayList<Block> blocksToWrap = null;
            for (Block block : blocks) {
                PsiElement blockPsi = ASTBlock.getPsiElement((Block)block);
                if (blocksToWrap != null) {
                    if (RubyCommonPsiUtil.isVisibilityModifier(blockPsi)) {
                        this.wrapToIncompleteCompositeBlock(newBlocks, (List<Block>)blocksToWrap);
                        blocksToWrap = null;
                    } else {
                        blocksToWrap.add(block);
                        continue;
                    }
                }
                if (this.myHelper.getIndentProcessor().isIndentAffectedVisibilityModifier(blockPsi)) {
                    blocksToWrap = new ArrayList<Block>();
                }
                newBlocks.add(block);
            }
            this.wrapToIncompleteCompositeBlock(newBlocks, blocksToWrap);
            blocks = newBlocks;
        }
        return blocks;
    }

    private boolean isInternalMethodWrappingNecessary() {
        RubyCodeStyleSettings settings = this.myHelper.getCustomSettings();
        PsiElement nodePsi = this.myNode.getPsi();
        return !(!settings.INDENT_VISIBILITY_MODIFIERS || !settings.INDENT_PRIVATE_METHODS && !settings.INDENT_PROTECTED_METHODS && !settings.INDENT_PUBLIC_METHODS || !RubyElementPatterns.getCLASS_BODY_PATTERN().accepts((Object)nodePsi) && !RubyElementPatterns.getDO_BODY_PATTERN().accepts((Object)nodePsi));
    }

    private void wrapToIncompleteCompositeBlock(@NotNull List<Block> targetList, @Nullable List<Block> blocksToWrap) {
        if (targetList == null) {
            RubyBlock.$$$reportNull$$$0(8);
        }
        if (blocksToWrap == null || blocksToWrap.isEmpty()) {
            return;
        }
        for (Block block : blocksToWrap) {
            if (!(block instanceof RubyBlock)) continue;
            RubyBlock rubyBlock = (RubyBlock)block;
            Block lastTargetListBlock = (Block)ContainerUtil.getLastItem(targetList);
            ASTNode prevNode = lastTargetListBlock instanceof RubyBlock ? ((RubyBlock)lastTargetListBlock).myNode : null;
            rubyBlock.myAlignment = LazyInitializer.create(() -> this.myHelper.getAlignmentProcessor().getChildAlignment(this, this.myNode, rubyBlock.myNode, prevNode, this.myHelper.getAlignmentProcessor().createChildrenAlignmentStrategy(this.myNode)));
        }
        targetList.add(new RubyIncompleteCompositeBlock(blocksToWrap, (LazyInitializer.LazyValue<Indent>)LazyInitializer.create(Indent::getNormalIndent), null, this.myHelper, (Block)ContainerUtil.getLastItem(targetList)));
    }

    private void processChildNode(@NotNull List<Block> subBlocks, @Nullable ASTNode prevChildNode, @NotNull ASTNode childNode) {
        LazyInitializer.LazyValue alignment;
        if (subBlocks == null) {
            RubyBlock.$$$reportNull$$$0(9);
        }
        if (childNode == null) {
            RubyBlock.$$$reportNull$$$0(10);
        }
        LazyInitializer.LazyValue wrap = LazyInitializer.create(() -> this.myHelper.getWrapProcessor().getChildWrap(this, prevChildNode, childNode));
        LazyInitializer.LazyValue indent = LazyInitializer.create(() -> this.myHelper.getIndentProcessor().getChildIndent(this, prevChildNode, childNode));
        RubyBlock childBlock = RubyFormattingModelBuilder.buildBlockFor(this, childNode, (LazyInitializer.LazyValue<Indent>)indent, (LazyInitializer.LazyValue<Wrap>)wrap, (LazyInitializer.LazyValue<Alignment>)(alignment = LazyInitializer.create(() -> this.myHelper.getAlignmentProcessor().getChildAlignment(this, this.myNode, childNode, prevChildNode, this.getChildrenAlignmentStrategy()))), this.myHelper, this.myPatchedTextRange);
        if (childBlock.getTextRange().isEmpty()) {
            return;
        }
        if (((TokenSet)CONTAINERS_TO_LINEARISE.get()).contains(childNode.getElementType())) {
            List childNodeSubBlocks = childBlock.getSubBlocks();
            IElementType nodeElementType = PsiUtilCore.getElementType((ASTNode)this.myNode);
            if (((TokenSet)CONTAINERS_TO_LINEARISE.get()).contains(nodeElementType)) {
                this.updateParent(childNodeSubBlocks);
                subBlocks.addAll(childNodeSubBlocks);
                return;
            }
            if (!childNodeSubBlocks.isEmpty()) {
                ArrayList<RubyCompositeBlock> compositeBlocks = new ArrayList<RubyCompositeBlock>();
                ArrayList<Object> blocksToWrap = new ArrayList<Block>();
                for (Block childNodeSubBlock : childNodeSubBlocks) {
                    IElementType childNodeSubBlockElementType = ASTBlock.getElementType((Block)childNodeSubBlock);
                    if (COMPOSITE_CALL_DELIMITERS.contains(childNodeSubBlockElementType) && !blocksToWrap.isEmpty()) {
                        this.wrapToCompositeBlock(compositeBlocks, blocksToWrap);
                        blocksToWrap = new ArrayList();
                    }
                    blocksToWrap.add(childNodeSubBlock);
                }
                this.wrapToCompositeBlock(compositeBlocks, blocksToWrap);
                if (!compositeBlocks.isEmpty()) {
                    RubyCompositeBlock newBlock = new RubyCompositeBlock(compositeBlocks, (LazyInitializer.LazyValue<Indent>)LazyInitializer.create(() -> ((Block)childBlock).getIndent()), (LazyInitializer.LazyValue<Alignment>)alignment, this.myHelper, (Block)ContainerUtil.getLastItem(subBlocks));
                    subBlocks.add(newBlock);
                    if (nodeElementType == RubyElementTypes.COMPOUND_STATEMENT && PsiUtilCore.getElementType((ASTNode)this.myNode.getTreeParent()) == RubyElementTypes.BODY_STATEMENT) {
                        newBlock.withChildIndent(Indent.getNoneIndent());
                        if (compositeBlocks.size() == 1) {
                            ((RubyCompositeBlock)compositeBlocks.get(0)).withChildIndent(Indent.getNoneIndent());
                        }
                    }
                }
                return;
            }
        }
        subBlocks.add((Block)childBlock);
    }

    private void wrapToCompositeBlock(@NotNull List<RubyCompositeBlock> compositeBlocks, @NotNull List<Block> blocksToWrap) {
        if (compositeBlocks == null) {
            RubyBlock.$$$reportNull$$$0(11);
        }
        if (blocksToWrap == null) {
            RubyBlock.$$$reportNull$$$0(12);
        }
        this.updateParent(blocksToWrap);
        compositeBlocks.add(new RubyCompositeBlock(blocksToWrap, (LazyInitializer.LazyValue<Indent>)(compositeBlocks.isEmpty() ? null : LazyInitializer.create(() -> RubyBlock.calcIndentForCompositeBySubBlocks(blocksToWrap))), null, this.myHelper, (Block)ContainerUtil.getLastItem(compositeBlocks)));
    }

    private void updateParent(@NotNull List<Block> subBlocks) {
        if (subBlocks == null) {
            RubyBlock.$$$reportNull$$$0(13);
        }
        subBlocks.stream().filter(block -> block instanceof RubyBlock).forEach(block -> ((RubyBlock)block).setParentBlock(this));
    }

    @Nullable
    private Block createOuterBlock(@NotNull ASTNode node) {
        PsiElement childPsi;
        Language childLanguage;
        FormattingModelBuilder builder;
        if (node == null) {
            RubyBlock.$$$reportNull$$$0(14);
        }
        if ((builder = LanguageFormatting.INSTANCE.forContext(childLanguage = (childPsi = node.getPsi()).getLanguage(), childPsi)) != null) {
            FormattingModel childModel = builder.createModel(FormattingContext.create((PsiElement)childPsi, (CodeStyleSettings)this.myHelper.getRootSettings()));
            return childModel.getRootBlock();
        }
        return null;
    }

    @NonNls
    public String toString() {
        return "Block at: " + String.valueOf(this.myNode);
    }

    private static Indent calcIndentForCompositeBySubBlocks(@NotNull List<Block> subBlocks) {
        ASTNode nextNode;
        ASTNode firstNode;
        if (subBlocks == null) {
            RubyBlock.$$$reportNull$$$0(15);
        }
        if (subBlocks.size() > 1 && COMPOSITE_CALL_DELIMITERS.contains(PsiUtilCore.getElementType((ASTNode)(firstNode = RubySpacingUtil.extractNode(subBlocks.iterator().next())))) && !RubySpaceUtil.isSoftNewLine(nextNode = firstNode.getTreeNext())) {
            return null;
        }
        return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
    }

    @Nullable
    public static PsiElement getLastSignificantLeaf(@NotNull Block rubyBlock) {
        ASTNode node;
        if (rubyBlock == null) {
            RubyBlock.$$$reportNull$$$0(16);
        }
        if ((node = RubySpacingUtil.extractNode(rubyBlock)) == null) {
            return null;
        }
        PsiElement element = node.getPsi();
        PsiElement lastLeaf = RubyCommonPsiUtil.getSignificantLeafToTheLeft(PsiTreeUtil.getDeepestLast((PsiElement)element));
        if (lastLeaf instanceof PsiErrorElement) {
            return RubyCommonPsiUtil.getPrevSignificantLeaf(PsiTreeUtil.getDeepestLast((PsiElement)element));
        }
        return lastLeaf;
    }

    private static boolean isLeaf(@NotNull ASTNode node) {
        if (node == null) {
            RubyBlock.$$$reportNull$$$0(17);
        }
        return node.getFirstChildNode() == null;
    }

    public static boolean isIncomplete(@NotNull ASTNode node) {
        PsiElement lastLeaf;
        ASTNode lastChild;
        if (node == null) {
            RubyBlock.$$$reportNull$$$0(18);
        }
        for (lastChild = node.getLastChildNode(); lastChild != null && (lastChild.getPsi() instanceof PsiWhiteSpace || lastChild.getPsi() instanceof PsiComment); lastChild = lastChild.getTreePrev()) {
        }
        if (lastChild == null) {
            return false;
        }
        if (lastChild.getPsi() instanceof PsiErrorElement) {
            return true;
        }
        if (RubyBlock.isIncomplete(lastChild)) {
            return true;
        }
        IElementType nodeType = node.getElementType();
        if ((nodeType == RubyElementTypes.LIST_OF_EXPRESSIONS || nodeType == RubyElementTypes.FUNCTION_ARGUMENT_LIST) && (lastLeaf = RubyCommonPsiUtil.getSignificantLeafToTheLeft(PsiTreeUtil.getDeepestLast((PsiElement)node.getPsi()))) != null && lastLeaf.getNode().getElementType() == RubyTokenTypes.tCOMMA) {
            PsiElement parent = lastLeaf.getParent();
            PsiElement ancestor = (PsiElement)ObjectUtils.doIfNotNull((Object)parent, PsiElement::getParent);
            IElementType parentType = PsiUtilCore.getElementType((PsiElement)parent);
            if (parentType == RubyElementTypes.LIST_OF_EXPRESSIONS && (PsiUtilCore.getElementType((PsiElement)ancestor) == RubyElementTypes.CALL || PsiUtilCore.getElementType((PsiElement)ancestor) == RubyElementTypes.ARRAY) || parentType == RubyElementTypes.ASSOC_LIST || parentType == RubyElementTypes.FUNCTION_ARGUMENT_LIST) {
                return true;
            }
        }
        return false;
    }

    private static boolean canBeCorrectBlock(@NotNull ASTNode node) {
        if (node == null) {
            RubyBlock.$$$reportNull$$$0(19);
        }
        int length = node.getTextLength();
        IElementType elementType = node.getElementType();
        if (length == 0 || elementType == RubyElementTypes.HEREDOC_VALUE && length == 1 || elementType == TokenType.WHITE_SPACE) {
            return false;
        }
        while (!RubyBlock.isLeaf(node)) {
            if ((node = node.getFirstChildNode()).getTreeNext() == null) continue;
            return true;
        }
        return !RubySpaceUtil.isAnySpace(node);
    }

    private static boolean isOuterElement(@NotNull ASTNode node) {
        if (node == null) {
            RubyBlock.$$$reportNull$$$0(20);
        }
        return node.getPsi() instanceof OuterLanguageElement && node.getPsi().getContainingFile().getFileType() == RubyFileType.RUBY;
    }

    public static boolean isNonIndentableNode(ASTNode node) {
        IElementType type = node.getElementType();
        return type == RubyElementTypes.HEREDOC_VALUE || type == RubyTokenTypes.tHEREDOC_END || type == RubyTokenTypes.tBLOCK_COMMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetList";
                break;
            }
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subBlocks";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeBlocks";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocksToWrap";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processSubBlocks";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "wrapToIncompleteCompositeBlock";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processChildNode";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapToCompositeBlock";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateParent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createOuterBlock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calcIndentForCompositeBySubBlocks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLastSignificantLeaf";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isLeaf";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canBeCorrectBlock";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isOuterElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class RubyIncompleteCompositeBlock
    extends RubyCompositeBlock {
        private RubyIncompleteCompositeBlock(@NotNull List<? extends Block> childBlocks, @NotNull LazyInitializer.LazyValue<Indent> indent, @Nullable LazyInitializer.LazyValue<Alignment> alignment, @NotNull RubyFormattingHelper helper, @Nullable Block prevBlock) {
            if (childBlocks == null) {
                RubyIncompleteCompositeBlock.$$$reportNull$$$0(0);
            }
            if (indent == null) {
                RubyIncompleteCompositeBlock.$$$reportNull$$$0(1);
            }
            if (helper == null) {
                RubyIncompleteCompositeBlock.$$$reportNull$$$0(2);
            }
            super(childBlocks, indent, alignment, helper, prevBlock);
        }

        @Override
        public boolean isIncomplete() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "childBlocks";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "helper";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/lang/formatter/RubyBlock$RubyIncompleteCompositeBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

