/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RubyTextUtil {
    static final String UNICODE_RANGE = "\\x7f-\\xff\\x{001C0}-\\x{10FFFF}";
    @ApiStatus.Internal
    public static final String IDENT_PART_ANY_CASE = "[_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]";
    public static final Pattern UNICODE_EMOJI_PATTERN = Pattern.compile("\\\\u\\{[0-9a-fA-F ]+}|\\\\u[0-9a-fA-F ]+");
    public static final Pattern UNICODE_EMOJI_CODE_PATTERN = Pattern.compile("[0-9a-fA-F]+");
    @NonNls
    private static final String REGEX_SPECIAL_CHARACTERS = "[]{}()|-*.\\?+^$#\t\f\n\r";
    @ApiStatus.Internal
    public static final String IDENT_PART_LOWER_CASE = "[_a-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}&&[^\\p{Lu}]]";
    private static final Pattern FID_PATTERN = Pattern.compile("[_a-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}&&[^\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*[!?]");
    @ApiStatus.Internal
    public static final String IDENT_PART_NO_DIGIT_ANY_CASE = "[_A-Za-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]";
    public static final Pattern CID_PATTERN = Pattern.compile("[_A-Za-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*");

    @NotNull
    public static String escapeRegexSpecialCharacters(@NotNull String source, Character ... exceptions) {
        if (source == null) {
            RubyTextUtil.$$$reportNull$$$0(0);
        }
        if (exceptions == null) {
            RubyTextUtil.$$$reportNull$$$0(1);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (!List.of(exceptions).contains(Character.valueOf(c)) && REGEX_SPECIAL_CHARACTERS.indexOf(c) >= 0) {
                result.append('\\');
            }
            result.append(c);
        }
        String string = result.toString();
        if (string == null) {
            RubyTextUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isCharInArray(char c, char @NotNull [] array) {
        if (array == null) {
            RubyTextUtil.$$$reportNull$$$0(3);
        }
        for (char i : array) {
            if (c != i) continue;
            return true;
        }
        return false;
    }

    public static char getPairedCharacter(char c) {
        if (c == '(' || c == '[' || c == '{' || c == '<') {
            return (char)(c + '\u0001');
        }
        return '\uffff';
    }

    public static int getLineIndent(@NotNull CharSequence line, int tabSize) {
        if (line == null) {
            RubyTextUtil.$$$reportNull$$$0(4);
        }
        int currentIndent = 0;
        for (int pos = 0; pos < line.length(); ++pos) {
            char c = line.charAt(pos);
            if (c == ' ') {
                ++currentIndent;
                continue;
            }
            if (c != '\t') break;
            currentIndent += tabSize;
        }
        return currentIndent;
    }

    @Contract(value="null->null;!null->!null")
    @Nullable
    public static String removeEOL(@Nullable String text) {
        char prevChar;
        if (text == null) {
            return text;
        }
        int end = text.length();
        if (end == 0) {
            return text;
        }
        char lastChar = text.charAt(end - 1);
        if (lastChar == '\r') {
            --end;
        } else if (lastChar == '\n' && --end > 0 && (prevChar = text.charAt(end - 1)) == '\r') {
            --end;
        }
        return text.substring(0, end);
    }

    @NotNull
    public static String convertEmojiCodesToPics(@NotNull String text) {
        if (text == null) {
            RubyTextUtil.$$$reportNull$$$0(5);
        }
        String resultText = text;
        Matcher matcher = UNICODE_EMOJI_PATTERN.matcher(resultText);
        while (matcher.find()) {
            TextRange replaceTextRange = new TextRange(matcher.start(), matcher.end());
            String unicodeEmoji = replaceTextRange.substring(resultText);
            Matcher patternUnicodeCodeMatcher = UNICODE_EMOJI_CODE_PATTERN.matcher(unicodeEmoji);
            StringBuilder emojis = new StringBuilder();
            while (patternUnicodeCodeMatcher.find()) {
                String stringCode = unicodeEmoji.substring(patternUnicodeCodeMatcher.start(), patternUnicodeCodeMatcher.end());
                try {
                    int emojiCodePoint = Integer.parseInt(stringCode, 16);
                    emojis.append(Character.toString(emojiCodePoint));
                }
                catch (IllegalArgumentException e) {
                    String string = text;
                    if (string == null) {
                        RubyTextUtil.$$$reportNull$$$0(6);
                    }
                    return string;
                }
            }
            resultText = StringUtil.replaceSubstring((String)resultText, (TextRange)replaceTextRange, (String)emojis.toString());
            matcher = UNICODE_EMOJI_PATTERN.matcher(resultText);
        }
        String string = resultText;
        if (string == null) {
            RubyTextUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    public static boolean isCID(@Nullable String content) {
        return content != null && CID_PATTERN.matcher(content).matches();
    }

    public static boolean isFID(@Nullable String content) {
        return content != null && FID_PATTERN.matcher(content).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/RubyTextUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/RubyTextUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeRegexSpecialCharacters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertEmojiCodesToPics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escapeRegexSpecialCharacters";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCharInArray";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertEmojiCodesToPics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7 -> new IllegalStateException(string);
        };
    }
}

