/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang;

import org.jetbrains.annotations.NotNull;

public final class CommonTextUtil {
    private CommonTextUtil() {
    }

    public static char getOpenDelim(char c) {
        if (c == ')') {
            return '(';
        }
        if (c == '>') {
            return '<';
        }
        if (c == '}') {
            return '{';
        }
        if (c == ']') {
            return '[';
        }
        return c;
    }

    public static char getCloseDelim(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '<') {
            return '>';
        }
        if (c == '{') {
            return '}';
        }
        if (c == '[') {
            return ']';
        }
        return c;
    }

    public static boolean isOpenBrace(char c) {
        return c == '(' || c == '{' || c == '[';
    }

    public static boolean isCloseBrace(char c) {
        return c == ')' || c == '}' || c == ']';
    }

    public static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    public static char getCorrespondingChar(char c) {
        if (CommonTextUtil.isOpenBrace(c)) {
            return CommonTextUtil.getCloseDelim(c);
        }
        if (CommonTextUtil.isCloseBrace(c)) {
            return CommonTextUtil.getOpenDelim(c);
        }
        if (c == '/' || c == '`') {
            return c;
        }
        return '\uffff';
    }

    public static boolean isBraceLikeDelim(char c) {
        return CommonTextUtil.isOpenBrace(c) || CommonTextUtil.isCloseBrace(c) || c == '<' || c == '>';
    }

    public static int getIndentSizeForLineAtOffset(@NotNull CharSequence charSequence, int offset) {
        int i;
        if (charSequence == null) {
            CommonTextUtil.$$$reportNull$$$0(0);
        }
        int result = 0;
        for (i = offset; i < charSequence.length() && Character.isWhitespace(charSequence.charAt(i)); ++i) {
        }
        --i;
        while (i >= 0) {
            char c = charSequence.charAt(i);
            if (c == '\n') {
                return result;
            }
            result = Character.isWhitespace(c) ? ++result : 0;
            --i;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charSequence", "org/jetbrains/plugins/ruby/ruby/lang/CommonTextUtil", "getIndentSizeForLineAtOffset"));
    }
}

