/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.actions.editor.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;

public final class RubyEnterHandlerUtil {
    private static final TokenSet kEND_BRACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RubyTokenTypes.kDEF, RubyTokenTypes.kCLASS, RubyTokenTypes.kMODULE, RubyTokenTypes.kBEGIN, RubyTokenTypes.kIF, RubyTokenTypes.kUNLESS, RubyTokenTypes.kWHILE, RubyTokenTypes.kUNTIL, RubyTokenTypes.kCASE, RubyTokenTypes.kFOR, RubyTokenTypes.kDO});

    private RubyEnterHandlerUtil() {
    }

    public static boolean isEndNeeded(@NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            RubyEnterHandlerUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RubyEnterHandlerUtil.$$$reportNull$$$0(1);
        }
        if (offset == 0 || !(file.getFileType() instanceof AbstractRubyFileType)) {
            return false;
        }
        Document document = editor.getDocument();
        String suffix = document.getText(TextRange.create((int)offset, (int)document.getTextLength()));
        if (suffix.startsWith("end\n") || suffix.equals("end")) {
            return false;
        }
        return RubyEnterHandlerUtil.hasStructuralOpenerOnTheLine(editor, offset) && RubyCommonPsiUtil.getBeginEndBalance(editor, file) > 0;
    }

    private static boolean hasStructuralOpenerOnTheLine(@NotNull Editor editor, int offset) {
        if (editor == null) {
            RubyEnterHandlerUtil.$$$reportNull$$$0(2);
        }
        Document document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(document.getLineNumber(offset));
        HighlighterIterator it = editor.getHighlighter().createIterator(lineStartOffset);
        while (!it.atEnd() && it.getEnd() <= offset) {
            if (kEND_BRACE_TOKENS.contains(it.getTokenType())) {
                return true;
            }
            it.advance();
        }
        return false;
    }

    static boolean shouldHandle(Editor editor, DataContext dataContext) {
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null || psiFile.getFileType() != RubyFileType.RUBY) {
            return false;
        }
        if (editor.isViewer()) {
            return false;
        }
        Document document = editor.getDocument();
        return document.isWritable();
    }

    static int indentLine(@NotNull Project project, @NotNull Document document, int lineNumber) {
        if (project == null) {
            RubyEnterHandlerUtil.$$$reportNull$$$0(3);
        }
        if (document == null) {
            RubyEnterHandlerUtil.$$$reportNull$$$0(4);
        }
        if (0 > lineNumber || lineNumber >= document.getLineCount()) {
            return -1;
        }
        return CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, document.getLineStartOffset(lineNumber));
    }

    @ApiStatus.Internal
    public static void indentLineAndMoveCaret(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, int lineNumber, boolean isMoveCaretAtEndOfLine) {
        int offset;
        if (project == null) {
            RubyEnterHandlerUtil.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            RubyEnterHandlerUtil.$$$reportNull$$$0(6);
        }
        if (document == null) {
            RubyEnterHandlerUtil.$$$reportNull$$$0(7);
        }
        if ((offset = RubyEnterHandlerUtil.indentLine(project, document, lineNumber)) != -1) {
            if (isMoveCaretAtEndOfLine) {
                offset = document.getLineEndOffset(document.getLineNumber(offset));
            }
            editor.getCaretModel().moveToOffset(offset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/actions/editor/handlers/RubyEnterHandlerUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEndNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasStructuralOpenerOnTheLine";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "indentLine";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "indentLineAndMoveCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

