/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rdoc;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.RDocHighlighter;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.lexer.RDocLexer;

public final class RDocSyntaxHighlighter
extends SyntaxHighlighterBase
implements RDocTokenTypes {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            RDocSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new RDocLexer(true, false);
    }

    static {
        ATTRIBUTES.put(DIRECTIVE, RDocHighlighter.DIRECTIVE);
        ATTRIBUTES.put(BOLD, RDocHighlighter.BOLD);
        ATTRIBUTES.put(ITALIC, RDocHighlighter.ITALIC);
        ATTRIBUTES.put(TYPE_WRITER, RDocHighlighter.TYPE_WRITER);
        ATTRIBUTES.put(HEADINGS, RDocHighlighter.HEADINGS);
        ATTRIBUTES.put(URL, RDocHighlighter.URL);
        ATTRIBUTES.put(EMAIL, RDocHighlighter.EMAIL);
        ATTRIBUTES.put(INTEGER, RDocHighlighter.NUMBER);
        ATTRIBUTES.put(FLOAT, RDocHighlighter.NUMBER);
        ATTRIBUTES.put(STRING, RDocHighlighter.STRING);
        ATTRIBUTES.put(VAR, RDocHighlighter.IVAR);
        ATTRIBUTES.put(GVAR, RDocHighlighter.GVAR);
        ATTRIBUTES.put(SYMBOL, RDocHighlighter.SYMBOL);
        ATTRIBUTES.put(PARAM, RDocHighlighter.KEYWORD);
        ATTRIBUTES.put(RETURN, RDocHighlighter.KEYWORD);
        ATTRIBUTES.put(RAISE, RDocHighlighter.KEYWORD);
        ATTRIBUTES.put(ATTRIBUTE_DIRECTIVE, RDocHighlighter.KEYWORD);
        ATTRIBUTES.put(METHOD_DIRECTIVE, RDocHighlighter.KEYWORD);
        ATTRIBUTES.put(TYPE_TAG, RDocHighlighter.KEYWORD);
        ATTRIBUTES.put(DEPRECATED, RDocHighlighter.KEYWORD);
        ATTRIBUTES.put(TYPE, RDocHighlighter.IDENTIFIER);
        ATTRIBUTES.put(MESSAGE, RDocHighlighter.IDENTIFIER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/rdoc/RDocSyntaxHighlighter", "getTokenHighlights"));
    }
}

