/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.erb.lexer;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyLexer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementType;

public abstract class AbstractErbRubyLexer
extends Lexer {
    protected final Lexer myOtherLexer;
    protected final RubyLexer myRubyLexer;
    protected final IElementType myRubyInjectionToken;
    protected final IElementType myOuterLanguageToken;
    private RubyLexer myCurrentRubyLexer = null;
    private final boolean myInHighlightingMode;

    public AbstractErbRubyLexer(boolean inHighlightingMode, Lexer otherLexer, IElementType rubyInjectionToken, IElementType outerLanguageToken) {
        this.myInHighlightingMode = inHighlightingMode;
        this.myOtherLexer = otherLexer;
        this.myRubyInjectionToken = rubyInjectionToken;
        this.myOuterLanguageToken = outerLanguageToken;
        this.myRubyLexer = new RubyLexer();
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            AbstractErbRubyLexer.$$$reportNull$$$0(0);
        }
        this.myOtherLexer.start(buffer, startOffset, endOffset, initialState);
        this.setupRubyLexer();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myOtherLexer.getBufferSequence();
        if (charSequence == null) {
            AbstractErbRubyLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getState() {
        return this.myOtherLexer.getState();
    }

    public IElementType getTokenType() {
        IElementType tokenType = this.myOtherLexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        if (tokenType instanceof RubyElementType) {
            return tokenType;
        }
        if (tokenType == this.myRubyInjectionToken) {
            return this.myCurrentRubyLexer.getTokenType();
        }
        return !this.myInHighlightingMode ? this.myOuterLanguageToken : tokenType;
    }

    public int getTokenStart() {
        IElementType tokenType = this.myOtherLexer.getTokenType();
        if (this.myCurrentRubyLexer != null) {
            if (tokenType instanceof RubyElementType) {
                return this.myOtherLexer.getTokenStart() + this.myCurrentRubyLexer.getTokenStart();
            }
            if (tokenType == this.myRubyInjectionToken) {
                return this.myOtherLexer.getTokenStart() + this.myCurrentRubyLexer.getTokenStart();
            }
        }
        return this.myOtherLexer.getTokenStart();
    }

    public int getTokenEnd() {
        IElementType tokenType = this.myOtherLexer.getTokenType();
        if (tokenType instanceof RubyElementType) {
            return this.myOtherLexer.getTokenStart() + this.myCurrentRubyLexer.getTokenEnd();
        }
        if (tokenType == this.myRubyInjectionToken) {
            return this.myOtherLexer.getTokenStart() + this.myCurrentRubyLexer.getTokenEnd();
        }
        return this.myOtherLexer.getTokenEnd();
    }

    public void advance() {
        IElementType tokenType = this.myOtherLexer.getTokenType();
        if (tokenType == this.myRubyInjectionToken) {
            this.myCurrentRubyLexer.advance();
            if (this.myCurrentRubyLexer.getTokenType() != null) {
                return;
            }
        }
        this.myOtherLexer.advance();
        this.setupRubyLexer();
    }

    protected abstract void resetRubyLexer(@NotNull RubyLexer var1, @NotNull CharSequence var2, int var3, int var4);

    protected void setupRubyLexer() {
        IElementType tokenType = this.myOtherLexer.getTokenType();
        if (tokenType != this.myRubyInjectionToken) {
            return;
        }
        this.myCurrentRubyLexer = this.myRubyLexer;
        int length = this.myOtherLexer.getTokenEnd() - this.myOtherLexer.getTokenStart();
        CharSequenceSubSequence subSequence = new CharSequenceSubSequence(this.myOtherLexer.getBufferSequence(), this.myOtherLexer.getTokenStart(), this.myOtherLexer.getTokenEnd());
        this.resetRubyLexer(this.myCurrentRubyLexer, (CharSequence)subSequence, 0, length);
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        return new Position(this.myCurrentRubyLexer != null ? this.myCurrentRubyLexer.getCurrentPosition() : null, this.myOtherLexer.getCurrentPosition(), this.getState());
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            AbstractErbRubyLexer.$$$reportNull$$$0(2);
        }
        Position p = (Position)position;
        this.myOtherLexer.restore(p.getOtherLanguagePosition());
        LexerPosition rubyPos = p.getRubyPosition();
        if (rubyPos != null && rubyPos.getOffset() < this.myCurrentRubyLexer.getBufferEnd()) {
            this.myCurrentRubyLexer.restore(rubyPos);
        } else {
            this.myCurrentRubyLexer = null;
            this.setupRubyLexer();
        }
    }

    public int getBufferEnd() {
        return this.myOtherLexer.getBufferEnd();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/erb/lexer/AbstractErbRubyLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/erb/lexer/AbstractErbRubyLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class Position
    implements LexerPosition {
        private final LexerPosition myRubyPosition;
        private final LexerPosition myOtherLanguagePosition;
        private final int myState;

        Position(LexerPosition rubyPosition, LexerPosition otherLanguagePosition, int state) {
            this.myRubyPosition = rubyPosition;
            this.myOtherLanguagePosition = otherLanguagePosition;
            this.myState = state;
        }

        public int getOffset() {
            int otherPos = this.myOtherLanguagePosition != null ? this.myOtherLanguagePosition.getOffset() : 0;
            int rubyPos = this.myRubyPosition == null ? 0 : this.myRubyPosition.getOffset();
            return Math.max(otherPos, rubyPos);
        }

        public LexerPosition getRubyPosition() {
            return this.myRubyPosition;
        }

        public LexerPosition getOtherLanguagePosition() {
            return this.myOtherLanguagePosition;
        }

        public int getState() {
            return this.myState;
        }
    }
}

