/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.rubyforge.debugcommons.model.BreakpointSuspensionPoint;
import org.rubyforge.debugcommons.model.ExceptionSuspensionPoint;
import org.rubyforge.debugcommons.model.StepSuspensionPoint;
import org.rubyforge.debugcommons.model.SuspensionPoint;
import org.rubyforge.debugcommons.model.UnableToStepSuspensionPoint;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SuspensionReader
extends XmlStreamReader {
    private SuspensionPoint suspensionPoint;

    public SuspensionReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        String name = this.xpp.getName();
        assert (name.equals("breakpoint") || name.equals("suspended") || name.equals("exception") || name.equals("unable"));
        int line = this.getAttributeIntValue("line");
        String file = this.getAttributeValue("file");
        int threadId = this.getAttributeIntValue("threadId");
        if (name.equals("breakpoint")) {
            String conditionException = this.getAttributeValue("conditionException");
            this.suspensionPoint = new BreakpointSuspensionPoint(file, line, threadId, StringUtil.nullize((String)conditionException));
        } else if (name.equals("exception")) {
            ExceptionSuspensionPoint exceptionPoint = new ExceptionSuspensionPoint(file, line, threadId);
            exceptionPoint.setExceptionMessage(this.getAttributeValue("message"));
            exceptionPoint.setExceptionType(this.getAttributeValue("type"));
            this.suspensionPoint = exceptionPoint;
        } else {
            boolean isLocated = this.getAttributeBoolValue("located");
            StepSuspensionPoint stepPoint = name.equals("suspended") ? new StepSuspensionPoint(file, line, threadId, isLocated) : new UnableToStepSuspensionPoint(file, line, threadId, isLocated);
            String frameNoAttribute = this.getAttributeValue("frames");
            try {
                this.suspensionPoint = stepPoint;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Could not parse: " + frameNoAttribute + ", " + this.xpp.getText());
            }
        }
        this.ensureEndTag(name);
    }

    public static SuspensionPoint readSuspension(XmlPullParser xpp) throws IOException, XmlPullParserException {
        SuspensionReader reader = new SuspensionReader(xpp);
        reader.parse();
        return reader.suspensionPoint;
    }
}

