/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import java.io.IOException;
import java.util.ArrayList;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.RubyStepVariant;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;
import org.rubyforge.debugcommons.reader.ErrorReader;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class StepVariantsReader
extends XmlStreamReader {
    private RubyStepVariant[] myVariants;

    public StepVariantsReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        ArrayList<RubyStepVariant> variants = new ArrayList<RubyStepVariant>();
        assert (this.xpp.getName().equals("variants"));
        while (this.nextEvent() != 3 || !"variants".equals(this.xpp.getName())) {
            ErrorReader.flushPossibleMessage(this.xpp);
            if (Util.isEndTag(this.xpp, "variants")) break;
            assert (this.xpp.getName().equals("variant")) : this.xpp.getName() + " encountered";
            String text = this.getAttributeValue("text");
            int id = this.getAttributeIntValue("id");
            int type = this.getAttributeIntValue("type");
            assert (type == 0 || type == 1);
            variants.add(new RubyStepVariant(text, RubySuspensionLocation.Type.values()[type], id));
            this.ensureEndTag("variant");
        }
        this.myVariants = variants.toArray(new RubyStepVariant[0]);
    }

    public static RubyStepVariant[] readStepVariants(XmlPullParser xpp) throws IOException, XmlPullParserException {
        StepVariantsReader reader = new StepVariantsReader(xpp);
        reader.parse();
        return reader.myVariants;
    }
}

