/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.Nullable;

public final class ReaderUtils {
    private static final Logger LOG = Logger.getInstance(ReaderUtils.class);

    private ReaderUtils() {
    }

    public static int getAttributeIntValue(@Nullable String value) {
        if (value != null) {
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                LOG.warn(e.getMessage() + " Value=" + value);
            }
        }
        return -1;
    }

    public static long getAttributeLongValue(@Nullable String value) {
        if (value != null) {
            try {
                return Long.parseLong(value.trim());
            }
            catch (NumberFormatException e) {
                LOG.warn(e.getMessage() + " Value=" + value);
            }
        }
        return -1L;
    }
}

