/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.Message;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ErrorReader
extends XmlStreamReader {
    private static final Logger LOG = Logger.getInstance(ErrorReader.class);
    private static final String ERROR_ELEMENT = "error";
    private static final String MESSAGE_ELEMENT = "message";
    private Message message;

    public ErrorReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        String name = this.xpp.getName();
        assert (name.equals(ERROR_ELEMENT) || name.equals(MESSAGE_ELEMENT)) : "message expected, got: " + name;
        boolean debug = this.getAttributeBoolValue("debug");
        int eventType = this.xpp.next();
        assert (eventType == 4) : "text event expected";
        String text = this.xpp.getText();
        assert (text != null) : "message has text";
        this.message = new Message(text, debug);
        this.ensureEndTag(name);
        Util.logMessage(this.message);
    }

    public static Message readMessage(XmlPullParser xpp) throws IOException, XmlPullParserException {
        ErrorReader reader = new ErrorReader(xpp);
        reader.parse();
        return reader.message;
    }

    public static Message tryToReadMessageOrError(XmlPullParser xpp, String element) throws IOException, XmlPullParserException {
        Message message = null;
        if (ERROR_ELEMENT.equals(element)) {
            message = ErrorReader.readMessage(xpp);
            LOG.warn("Error occured: " + message.getText());
        } else if (MESSAGE_ELEMENT.equals(element)) {
            message = ErrorReader.readMessage(xpp);
        }
        return message;
    }

    static void flushPossibleMessage(XmlPullParser xpp) throws XmlPullParserException, IOException {
        while (ErrorReader.tryToReadMessageOrError(xpp, xpp.getName()) != null) {
            xpp.next();
        }
    }
}

