/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rubyforge.debugcommons.reader.ReaderUtils;

public class RubyVariableInfo {
    private static final Logger LOG = Logger.getInstance(RubyVariableInfo.class);
    private static final String NIL_VALUE = "nil";
    private static final String NIL_CLASS = "NilClass";
    public static final String SIZE_TAG = "size";
    public static final List<String> ADDITIONAL_TAGS = Collections.singletonList("size");
    private static final int COMPACT_VALUE_MAX_SIZE = 100;
    private final String name;
    private final String compactValue;
    private final String kind;
    @NotNull
    private final String value;
    private final long valueStringSize;
    @NotNull
    private final String type;
    private final boolean hasChildren;
    private final String objectId;
    @Nullable
    private final Map<String, String> myAdditionalTags;
    private final boolean myIsCollection;

    public RubyVariableInfo(String name, String compactValue, String kind, String value, long valueStringSize, String type, boolean hasChildren, String objectId, @Nullable Map<String, String> additionalTags) {
        this.name = name;
        this.kind = kind;
        this.value = value == null ? NIL_VALUE : value;
        this.valueStringSize = valueStringSize;
        this.compactValue = RubyVariableInfo.calcCompactValue(compactValue, this.value);
        this.type = type == null ? NIL_CLASS : type;
        this.hasChildren = hasChildren;
        this.objectId = objectId;
        this.myAdditionalTags = additionalTags;
        this.myIsCollection = this.myAdditionalTags != null && this.myAdditionalTags.containsKey(SIZE_TAG);
    }

    @Nullable
    public Map<String, String> getAdditionalTags() {
        return this.myAdditionalTags;
    }

    public boolean isCollection() {
        return this.myIsCollection;
    }

    @NotNull
    private static String calcCompactValue(@Nullable String compactValue, @NotNull String value) {
        if (value == null) {
            RubyVariableInfo.$$$reportNull$$$0(0);
        }
        if (compactValue != null) {
            return RubyVariableInfo.normalizeCompactValue(compactValue);
        }
        return RubyVariableInfo.normalizeCompactValue(value);
    }

    @NotNull
    private static String normalizeCompactValue(@NotNull String value) {
        if (value == null) {
            RubyVariableInfo.$$$reportNull$$$0(1);
        }
        Object object = value.length() > 100 ? value.substring(0, 97) + "..." : value;
        if (object == null) {
            RubyVariableInfo.$$$reportNull$$$0(2);
        }
        return object;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    @NotNull
    public String getType() {
        String string = this.type;
        if (string == null) {
            RubyVariableInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.value;
        if (string == null) {
            RubyVariableInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    public long getValueStringSize() {
        return this.valueStringSize;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getCompactValue() {
        return this.compactValue;
    }

    boolean isNil() {
        return NIL_VALUE.equals(this.getValue());
    }

    public long getSize() {
        if (this.myAdditionalTags == null) {
            return -1L;
        }
        String sizeValue = this.myAdditionalTags.get(SIZE_TAG);
        return ReaderUtils.getAttributeLongValue(sizeValue);
    }

    public String toString() {
        return "RubyVariableInfo{name='" + this.name + "', compactValue='" + this.compactValue + "', kind='" + this.kind + "', value='" + this.value + "', type='" + this.type + "', hasChildren=" + this.hasChildren + ", objectId='" + this.objectId + "', myAdditionalTags=" + String.valueOf(this.myAdditionalTags) + ", myIsCollection=" + this.myIsCollection + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/model/RubyVariableInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/model/RubyVariableInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeCompactValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcCompactValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalizeCompactValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

