/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariableInfo;

public final class RubyVariable
extends RubyEntity {
    public static final RubyVariable[] EMPTY_ARRAY = new RubyVariable[0];
    @NotNull
    private final RubyVariableInfo info;
    private final RubyFrame frame;
    private final boolean isClass;
    private final boolean isLocal;
    private final boolean isInstance;
    private final boolean isConstant;
    private final boolean isGlobal;
    private final boolean isHashValue;
    private final RubyValue value;
    @Nullable
    private final RubyVariable parent;

    private RubyVariable(RubyDebuggerProxy proxy, @NotNull RubyVariableInfo info, RubyFrame frame, @Nullable RubyVariable parent) {
        if (info == null) {
            RubyVariable.$$$reportNull$$$0(0);
        }
        super(proxy);
        this.info = info;
        this.isClass = info.getKind().equals("class");
        this.isLocal = info.getKind().equals("local");
        this.isInstance = info.getKind().equals("instance");
        this.isConstant = info.getKind().equals("constant");
        this.isGlobal = info.getKind().equals("global");
        this.isHashValue = parent != null && "Hash".equals(parent.getValue().getReferenceTypeName());
        this.value = new RubyValue(this, info.getValue(), info.getType(), info.hasChildren());
        this.frame = frame;
        this.parent = parent;
    }

    public RubyVariable(RubyDebuggerProxy proxy, RubyVariableInfo info) {
        this(proxy, info, null, null);
    }

    public RubyVariable(RubyVariableInfo info, RubyFrame frame) {
        this(info, frame, null);
    }

    public RubyVariable(RubyVariableInfo info, RubyVariable parent) {
        this(parent.getProxy(), info, parent.getFrame(), parent);
    }

    private RubyVariable(RubyVariableInfo info, RubyFrame frame, RubyVariable parent) {
        this(frame.getProxy(), info, frame, parent);
    }

    public String getName() {
        return this.info.getName();
    }

    public String getCompactValue() {
        return this.info.getCompactValue();
    }

    public String getObjectId() {
        return this.info.getObjectId();
    }

    public RubyValue getValue() {
        return this.value;
    }

    public String getReferenceTypeName() {
        return "RefTypeName";
    }

    public boolean hasValueChanged() {
        return false;
    }

    public RubyFrame getFrame() {
        return this.frame;
    }

    @Nullable
    public RubyVariable getParent() {
        return this.parent;
    }

    @NotNull
    public RubyVariableInfo getVariableInfo() {
        RubyVariableInfo rubyVariableInfo = this.info;
        if (rubyVariableInfo == null) {
            RubyVariable.$$$reportNull$$$0(1);
        }
        return rubyVariableInfo;
    }

    public String getQualifiedName() {
        if (this.parent == null) {
            return this.getName();
        }
        if (this.isHashValue()) {
            if (this.getValue().getReferenceTypeName().equals("String")) {
                return this.parent.getQualifiedName() + "[" + this.getName() + "]";
            }
            return "[ObjectSpace._id2ref(" + this.getObjectId() + ")]";
        }
        if (this.getName().startsWith("[")) {
            return this.parent.getQualifiedName() + this.getName();
        }
        return this.parent.getQualifiedName() + "." + this.getName();
    }

    public boolean isInstance() {
        return this.isInstance;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean isHashValue() {
        return this.isHashValue;
    }

    private boolean isNil() {
        return this.info.isNil();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubyVariable other = (RubyVariable)obj;
        if (this.isNil()) {
            return other.isNil();
        }
        return this.getObjectId().equals(other.getObjectId());
    }

    public int hashCode() {
        int hash = 7;
        hash = this.isNil() ? 89 * hash + (this.isNil() ? 1 : 0) : 89 * hash + (this.info.getObjectId() != null ? this.info.getObjectId().hashCode() : 0);
        return hash;
    }

    public String toString() {
        String sep = this.isHashValue() ? " => " : " = ";
        return this.getName() + sep + String.valueOf(this.getValue()) + ", INFO: (" + String.valueOf(this.info) + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/model/RubyVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/model/RubyVariable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

