/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyValue
extends RubyEntity {
    @NotNull
    private final String myValue;
    @NotNull
    private final String myReferenceTypeName;
    private final boolean myHasChildren;
    @NotNull
    private final RubyVariable myOwner;
    private RubyVariable[] myVariables;

    public RubyValue(@NotNull RubyVariable owner, @NotNull String value, @NotNull String type, boolean hasChildren) {
        if (owner == null) {
            RubyValue.$$$reportNull$$$0(0);
        }
        if (value == null) {
            RubyValue.$$$reportNull$$$0(1);
        }
        if (type == null) {
            RubyValue.$$$reportNull$$$0(2);
        }
        super(owner.getProxy());
        this.myValue = value;
        this.myOwner = owner;
        this.myHasChildren = hasChildren;
        this.myReferenceTypeName = type;
    }

    @NotNull
    public String getReferenceTypeName() {
        String string = this.myReferenceTypeName;
        if (string == null) {
            RubyValue.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getValueString() {
        String string = this.myValue;
        if (string == null) {
            RubyValue.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAllocated() {
        return false;
    }

    public RubyVariable[] getVariables() throws RubyDebuggerException {
        if (!this.myHasChildren) {
            return RubyVariable.EMPTY_ARRAY;
        }
        if (this.myVariables == null) {
            this.myVariables = this.getProxy().readInstanceVariables(this.myOwner);
        }
        return this.myVariables;
    }

    public RubyVariable[] getVariablesSubsequence(int start, int limit) throws RubyDebuggerException {
        if (!this.myHasChildren) {
            return RubyVariable.EMPTY_ARRAY;
        }
        return this.getProxy().readInstanceVariablesRange(this.myOwner, start, limit);
    }

    @NotNull
    public RubyVariable getOwner() {
        RubyVariable rubyVariable = this.myOwner;
        if (rubyVariable == null) {
            RubyValue.$$$reportNull$$$0(5);
        }
        return rubyVariable;
    }

    public boolean hasVariables() {
        return this.myHasChildren;
    }

    public String toString() {
        return this.getValueString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RubyValue)) {
            return false;
        }
        RubyValue value1 = (RubyValue)o;
        if (this.myHasChildren != value1.myHasChildren) {
            return false;
        }
        if (!this.myOwner.equals(value1.myOwner)) {
            return false;
        }
        return Objects.equals(this.myValue, value1.myValue);
    }

    public int hashCode() {
        int result = this.myValue.hashCode();
        result = 31 * result + (this.myHasChildren ? 1 : 0);
        result = 31 * result + this.myOwner.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/model/RubyValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/model/RubyValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

