/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyThread
extends RubyEntity {
    private static final Logger LOG = Logger.getInstance(RubyThread.class);
    private final SynchronizedClearableLazy<RubyFrame[]> frameProvider;
    @NotNull
    private final RubyThreadInfo myThreadInfo;
    private boolean isSuspended;
    private IRubyLineBreakpoint temporaryBreakpoint;

    public RubyThread(@NotNull RubyDebugTarget target, @NotNull RubyThreadInfo threadInfo) {
        if (target == null) {
            RubyThread.$$$reportNull$$$0(0);
        }
        if (threadInfo == null) {
            RubyThread.$$$reportNull$$$0(1);
        }
        super(target.getProxy());
        this.frameProvider = new SynchronizedClearableLazy(this::computeFrames);
        this.myThreadInfo = threadInfo;
    }

    public RubyFrame @NotNull [] getFrames() {
        RubyFrame[] rubyFrameArray = (RubyFrame[])this.frameProvider.getValue();
        if (rubyFrameArray == null) {
            RubyThread.$$$reportNull$$$0(2);
        }
        return rubyFrameArray;
    }

    private RubyFrame @NotNull [] computeFrames() {
        if (ApplicationManager.getApplication().isReadAccessAllowed() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Should not be run on EDT or under ReadAction");
        }
        if (this.supportsFrameReading()) {
            RubyFrame[] rubyFrameArray;
            try {
                rubyFrameArray = this.getProxy().readFrames(this);
            }
            catch (RubyDebuggerException e) {
                LOG.error("Error reading frames for" + String.valueOf(this), (Throwable)e);
            }
            if (rubyFrameArray == null) {
                RubyThread.$$$reportNull$$$0(3);
            }
            return rubyFrameArray;
        }
        if (RubyFrame.EMPTY_ARRAY == null) {
            RubyThread.$$$reportNull$$$0(4);
        }
        return RubyFrame.EMPTY_ARRAY;
    }

    public boolean supportsFrameReading() {
        return this.isSuspended() || this.getProxy().canReadFramesOfNonSuspendedThreads();
    }

    public RubyFrame getTopFrame() throws RubyDebuggerException {
        RubyFrame[] frames = this.getFrames();
        return frames.length == 0 ? null : frames[0];
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void resume() {
        LOG.debug("Resuming thread ", new Object[]{this});
        this.isSuspended = false;
        this.frameProvider.drop();
    }

    public void suspend(SuspensionPoint suspensionPoint) {
        if (this.temporaryBreakpoint != null) {
            LOG.debug("Removing temporary breakpoint: ", new Object[]{this.temporaryBreakpoint});
            this.getProxy().removeBreakpoint(this.temporaryBreakpoint);
            this.temporaryBreakpoint = null;
        }
        this.frameProvider.drop();
        this.isSuspended = true;
        RubyDebugEvent ev = new RubyDebugEvent(this.getProxy(), this, suspensionPoint);
        this.getProxy().fireDebugEvent(ev);
    }

    public void runTo(final String path, final int line, boolean blockBreakpointSupported) throws RubyDebuggerException {
        LOG.debug("Running to ", new Object[]{path, ":", line, ", block breakpoints supported: ", blockBreakpointSupported, " on ", Thread.currentThread().getName()});
        this.temporaryBreakpoint = new IRubyLineBreakpoint(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public String getFilePath() {
                return path;
            }

            @Override
            public int getLineNumber() {
                return line;
            }

            @Override
            public String getCondition() {
                return null;
            }

            @Override
            public boolean isAllSuspensions() {
                return false;
            }
        };
        RubyDebuggerProxy proxy = this.getProxy();
        proxy.addBreakpoint(this.temporaryBreakpoint, blockBreakpointSupported);
        proxy.resume(this);
    }

    public int getId() {
        return this.myThreadInfo.getId();
    }

    @Nullable
    @NlsSafe
    public String getStatus() {
        return this.myThreadInfo.getStatus();
    }

    public int getPid() {
        return this.myThreadInfo.getPid();
    }

    public void invalidateFrames() {
        for (RubyFrame frame : this.getFrames()) {
            frame.clearCachedVariables();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RubyThread)) {
            return false;
        }
        RubyThread thread = (RubyThread)o;
        return this.myThreadInfo.equals(thread.myThreadInfo);
    }

    public int hashCode() {
        return this.myThreadInfo.hashCode();
    }

    public String toString() {
        return "RubyThread{myThreadInfo=" + String.valueOf(this.myThreadInfo) + ", myFramesComputed=" + this.frameProvider.isInitialized() + ", isSuspended=" + this.isSuspended + ", temporaryBreakpoint=" + String.valueOf(this.temporaryBreakpoint) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/model/RubyThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/model/RubyThread";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFrames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

