/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebugTarget
extends RubyEntity {
    private static final Logger LOG = Logger.getInstance(RubyDebugTarget.class);
    private final Process process;
    private final String host;
    private final int port;
    private final String debuggedFile;
    private final File baseDir;
    private final boolean remote;
    private RubyThread[] threads;

    public RubyDebugTarget(@NotNull RubyDebuggerProxy proxy, String host, int port) {
        if (proxy == null) {
            RubyDebugTarget.$$$reportNull$$$0(0);
        }
        this(proxy, host, port, null, null, null, true);
    }

    public RubyDebugTarget(@NotNull RubyDebuggerProxy proxy, String host, int port, Process process, String debuggee, File baseDir) {
        if (proxy == null) {
            RubyDebugTarget.$$$reportNull$$$0(1);
        }
        this(proxy, host, port, process, debuggee, baseDir, false);
    }

    private RubyDebugTarget(@NotNull RubyDebuggerProxy proxy, String host, int port, Process process, String debugeee, File baseDir, boolean remote) {
        if (proxy == null) {
            RubyDebugTarget.$$$reportNull$$$0(2);
        }
        super(proxy);
        this.process = process;
        this.host = host;
        this.port = port;
        this.debuggedFile = debugeee;
        this.baseDir = baseDir;
        this.threads = new RubyThread[0];
        this.remote = remote;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDebuggedFile() {
        return this.debuggedFile;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void updateThreads() throws RubyDebuggerException {
        this.updateThreads(this.getProxy().readThreadInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThreads(RubyThreadInfo[] threadInfos) throws RubyDebuggerException {
        LOG.debug("updating threads");
        RubyThread[] updatedThreads = new RubyThread[threadInfos.length];
        int threadIndex = 0;
        RubyDebugTarget rubyDebugTarget = this;
        synchronized (rubyDebugTarget) {
            for (int i = 0; i < threadInfos.length; ++i) {
                while (threadIndex < this.threads.length && threadInfos[i].getId() != this.threads[threadIndex].getId()) {
                    ++threadIndex;
                }
                updatedThreads[i] = threadIndex == this.threads.length ? new RubyThread(this, threadInfos[i]) : this.threads[threadIndex];
            }
            this.threads = updatedThreads;
        }
    }

    public void suspensionOccurred(SuspensionPoint suspensionPoint) {
        LOG.debug("Suspension occurred at ", new Object[]{suspensionPoint});
        try {
            this.updateThreads();
        }
        catch (RubyDebuggerException e) {
            if (!this.getProxy().isReady()) {
                LOG.debug("Cannot update threads. Proxy is not ready.", (Throwable)e);
            } else {
                LOG.debug("Session has finished. Ignoring unsuccessful thread update.");
            }
            return;
        }
        RubyThread thread = this.getThreadById(suspensionPoint.getThreadId());
        if (thread == null) {
            LOG.warn("Thread with id " + suspensionPoint.getThreadId() + " was not found");
            return;
        }
        thread.suspend(suspensionPoint);
    }

    public synchronized RubyThread getThreadById(int id) {
        for (RubyThread thread : this.threads) {
            if (thread.getId() != id) continue;
            return thread;
        }
        return null;
    }

    public synchronized RubyThread[] getThreads() {
        return (RubyThread[])this.threads.clone();
    }

    public boolean isAvailable() {
        return this.isRemote() || this.isRunning();
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isRunning() {
        LOG.assertTrue(!this.isRemote(), (Object)"cannot ask remote process whether it is running");
        return this.process.isAlive();
    }

    public String toString() {
        return "RubyDebugTarget[baseDir: " + String.valueOf(this.getBaseDir()) + ", debuggedFile: " + this.getDebuggedFile() + ", port: " + this.getPort() + ", remote: " + this.remote + ", process: " + String.valueOf(this.process) + ", process alive: " + String.valueOf(this.process == null ? "n/a" : Boolean.valueOf(this.process.isAlive())) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxy", "org/rubyforge/debugcommons/model/RubyDebugTarget", "<init>"));
    }
}

