/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.net.InetAddress;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.rubyforge.debugcommons.model.Message;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class Util {
    public static final String DEBUGGER_SERVER_LOCALHOST = System.getProperty("ruby.debugger.server.localhost.ip.address", InetAddress.getLoopbackAddress().getHostAddress());
    private static Consumer<String> ourDebuggerTextProcessor;
    private static final Logger LOG;

    public static void logEvent(XmlPullParser xpp) {
        Util.logEvent(xpp, "Received:", LOG);
    }

    static void logEvent(@NotNull XmlPullParser xpp, @NotNull String prefix, @NotNull Logger logger) {
        if (xpp == null) {
            Util.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            Util.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            Util.$$$reportNull$$$0(2);
        }
        if (!logger.isDebugEnabled()) {
            return;
        }
        try {
            int eventType = xpp.getEventType();
            if (eventType == 1) {
                logger.debug(prefix + "END_DOCUMENT event");
                return;
            }
            if ("message".equals(xpp.getName())) {
                return;
            }
            if (xpp.getName() == null) {
                logger.warn(prefix + "unexpected type: (" + Util.getType(xpp) + ") encountered in logEvent");
                return;
            }
            StringBuilder toXml = new StringBuilder();
            if (eventType == 4) {
                return;
            }
            toXml.append("<");
            if (eventType == 3) {
                toXml.append('/');
            }
            toXml.append(xpp.getName());
            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                toXml.append(' ').append(xpp.getAttributeName(i)).append("='").append(xpp.getAttributeValue(i)).append("'");
            }
            toXml.append('>');
            logger.debug(prefix, new Object[]{toXml});
            if (ourDebuggerTextProcessor != null) {
                ourDebuggerTextProcessor.accept("Received: " + String.valueOf(toXml));
            }
        }
        catch (XmlPullParserException ex) {
            logger.error(prefix + ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public static void logMessage(Message message) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder messageXml = new StringBuilder("<message");
        if (message.isDebug()) {
            messageXml.append(" debug='true'");
        }
        messageXml.append('>');
        messageXml.append(message.getText());
        messageXml.append("</message>");
        LOG.debug("Received message: ", new Object[]{messageXml});
        if (ourDebuggerTextProcessor != null) {
            ourDebuggerTextProcessor.accept("Received message: " + String.valueOf(messageXml));
        }
    }

    public static String getType(XmlPullParser xpp) {
        try {
            if (xpp.getEventType() == 3) {
                return "END_TAG";
            }
            if (xpp.getEventType() == 2) {
                return "START_TAG";
            }
            if (xpp.getEventType() == 4) {
                return "TEXT";
            }
            if (xpp.getEventType() == 0) {
                return "START_DOCUMENT";
            }
            if (xpp.getEventType() == 1) {
                return "END_DOCUMENT";
            }
            return "UNKNOWN: " + xpp.getEventType();
        }
        catch (XmlPullParserException e) {
            LOG.error((Throwable)e);
            return "<Unable to find a type>";
        }
    }

    public static boolean isEndTag(XmlPullParser xpp, String name) throws XmlPullParserException {
        return 3 == xpp.getEventType() && name.equals(xpp.getName());
    }

    @TestOnly
    public static void setDebuggerTextListener(@NotNull Consumer<String> messageProcessor, @NotNull Disposable disposable) {
        if (messageProcessor == null) {
            Util.$$$reportNull$$$0(3);
        }
        if (disposable == null) {
            Util.$$$reportNull$$$0(4);
        }
        ourDebuggerTextProcessor = messageProcessor;
        Disposer.register((Disposable)disposable, () -> {
            ourDebuggerTextProcessor = null;
        });
    }

    static {
        LOG = Logger.getInstance(Util.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xpp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "org/rubyforge/debugcommons/Util";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setDebuggerTextListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

