/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import kotlinx.serialization.json.JsonArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rubyforge.debugcommons.ICommandFactory;
import org.rubyforge.debugcommons.ReadersSupport;
import org.rubyforge.debugcommons.RubyDebugCommandFactory;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.ExceptionSuspensionPoint;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.model.IRubyBlockBreakpoint;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.IRubyExceptionBreakpoint;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyFullValue;
import org.rubyforge.debugcommons.model.RubyFullValueInfo;
import org.rubyforge.debugcommons.model.RubyRenderersStatusInfo;
import org.rubyforge.debugcommons.model.RubyStepVariant;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyVariable;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;

public final class RubyDebuggerProxy {
    static final Logger LOG = Logger.getInstance(RubyDebuggerProxy.class);
    private static final int MAX_ATTEMPTS = 60;
    private static final int PAUSE_BETWEEN_ATTEMPTS_MS = 50;
    private static final int MAX_DISCONNECT_WAITING_MS = 10000;
    private final QueueProcessor<DebuggerCommand> myCommandProcessor;
    private final BoundedTaskExecutor myDebuggerRequestsExecutor;
    private final BreakpointStateChangeWatcher myBreakpointStateChangeWatcher;
    private final List<RubyDebugEventListener> listeners;
    private final Int2ObjectMap<IRubyLineBreakpoint> breakpointsIDs;
    private final int timeout;
    private final boolean supportsFrameReadingForNonSuspendedThreads;
    private RubyDebugTarget debugTarget;
    @Nullable
    private Socket commandSocket;
    private final AtomicReference<State> myState = new AtomicReference<State>(State.RUNNING);
    private PrintWriter commandWriter;
    private final ICommandFactory commandFactory;
    private final ReadersSupport readersSupport;
    private final boolean supportsCondition;
    private final Object variablesLock = new Object();
    private volatile boolean myIsPaused = false;
    private final Set<String> removedCatchpoints;
    private final boolean supportsCatchpointRemoval;
    private final boolean mySupportsLoadingFullValue;
    private final boolean mySupportsTypeRenderers;

    public RubyDebuggerProxy(int timeout, boolean supportsFrameReadingForNonSuspendedThreads, boolean supportsCondition, boolean supportsCatchpointRemoval, boolean supportsLoadingFullValue, boolean supportsTypeRenderers) {
        this.supportsFrameReadingForNonSuspendedThreads = supportsFrameReadingForNonSuspendedThreads;
        this.listeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.breakpointsIDs = new Int2ObjectOpenHashMap();
        this.supportsCatchpointRemoval = supportsCatchpointRemoval;
        this.mySupportsLoadingFullValue = supportsLoadingFullValue;
        this.mySupportsTypeRenderers = supportsTypeRenderers;
        this.removedCatchpoints = this.supportsCatchpointRemoval ? null : new HashSet();
        this.timeout = timeout;
        this.readersSupport = new ReadersSupport(timeout, this);
        this.supportsCondition = supportsCondition;
        this.commandFactory = new RubyDebugCommandFactory(this.supportsFrameReadingForNonSuspendedThreads);
        this.myDebuggerRequestsExecutor = (BoundedTaskExecutor)AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Ruby Debugger Requests Executor", (int)1);
        this.myCommandProcessor = new QueueProcessor(command -> {
            if (!this.waitForDebuggerProxyReady()) {
                LOG.debug("Dropping command because proxy is not ready: ", new Object[]{"command=", command, ", state=", this.myState.get(), ", commandWriter=", this.commandWriter == null ? "missing" : "present", ", debugTarget=", this.debugTarget});
                return;
            }
            try {
                LOG.debug("Processing ", new Object[]{command, " on ", Thread.currentThread().getName()});
                command.run(this.readersSupport);
            }
            catch (Exception e) {
                command.rejected(e);
            }
        });
        this.myBreakpointStateChangeWatcher = new BreakpointStateChangeWatcher();
    }

    public void setDebugTarget(RubyDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
        LOG.debug("Proxy target: ", new Object[]{debugTarget});
    }

    public RubyDebugTarget getDebugTarget() {
        return this.debugTarget;
    }

    ReadersSupport getReadersSupport() {
        return this.readersSupport;
    }

    public void attach(boolean enableFileFiltering, IRubyBreakpoint @NotNull [] initialBreakpoints, @NotNull Collection<String> dirsToInclude, @NotNull Collection<String> dirsToExclude, @NotNull JsonArray typeRenderers, boolean supportBlockBreakpoints) throws RubyDebuggerException {
        if (dirsToInclude == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(0);
        }
        if (dirsToExclude == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(1);
        }
        if (typeRenderers == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(2);
        }
        if (initialBreakpoints == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(3);
        }
        this.attachToRubyDebug(enableFileFiltering, initialBreakpoints, dirsToInclude, dirsToExclude, typeRenderers, supportBlockBreakpoints);
        this.startSuspensionReaderLoop();
        this.myBreakpointStateChangeWatcher.start();
    }

    private boolean isFinished() {
        return this.myState.get() == State.TERMINATED;
    }

    public boolean isReady() {
        return !this.isFinished() && this.commandWriter != null && this.debugTarget.isAvailable();
    }

    private synchronized void attachToRubyDebug(boolean enableFileFitering, IRubyBreakpoint @NotNull [] initialBreakpoints, @NotNull Collection<String> dirsToInclude, @NotNull Collection<String> dirsToExclude, @NotNull JsonArray typeRenderers, boolean supportBlockBreakpoints) throws RubyDebuggerException {
        if (dirsToInclude == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(4);
        }
        if (dirsToExclude == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(5);
        }
        if (typeRenderers == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(6);
        }
        if (initialBreakpoints == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(7);
        }
        try {
            Socket commandSocket = this.getCommandSocket();
            if (commandSocket == null) {
                throw new RubyDebuggerException("Unable to connect to a debugger, command socket is null");
            }
            if (!this.readersSupport.startCommandLoop(commandSocket.getInputStream())) {
                return;
            }
            this.commandWriter = new PrintWriter(commandSocket.getOutputStream(), true, StandardCharsets.UTF_8);
            for (IRubyBreakpoint breakpoint : initialBreakpoints) {
                this.addBreakpointImpl(breakpoint, supportBlockBreakpoints);
            }
            for (String dir : dirsToInclude) {
                this.sendCommand("include " + dir);
            }
            for (String dir : dirsToExclude) {
                this.sendCommand("exclude " + dir);
            }
            if (enableFileFitering) {
                this.sendCommand("file-filter on");
            }
            if (this.mySupportsTypeRenderers) {
                this.setTypeRenderers(typeRenderers);
            }
            this.sendCommand("start");
        }
        catch (IOException ex) {
            throw new RubyDebuggerException(ex);
        }
    }

    public void fireDebugEvent(@NotNull RubyDebugEvent e) {
        if (e == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(8);
        }
        for (RubyDebugEventListener listener : this.listeners) {
            listener.onDebugEvent(e);
        }
    }

    public void addRubyDebugEventListener(RubyDebugEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeRubyDebugEventListener(RubyDebugEventListener listener) {
        this.listeners.remove(listener);
    }

    private PrintWriter getCommandWriter() {
        assert (this.commandWriter != null) : "Proxy has to be started, before using the writer";
        return this.commandWriter;
    }

    public void addBreakpoint(final @NotNull IRubyBreakpoint breakpoint, final boolean supportBlockBreakpoints) {
        if (breakpoint == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(9);
        }
        LOG.debug("Queueing breakpoint creation: ", new Object[]{breakpoint, ", supportBlockBreakpoints: ", supportBlockBreakpoints, " on ", Thread.currentThread().getName(), "; proxy ", this});
        this.myCommandProcessor.add((Object)new DebuggerCommand("add_breakpoint"){

            @Override
            public void run(@NotNull ReadersSupport readersSupport) {
                if (readersSupport == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    RubyDebuggerProxy.this.addBreakpointImpl(breakpoint, supportBlockBreakpoints);
                } else if (!RubyDebuggerProxy.this.isFinished()) {
                    LOG.warn("Couldn't add breakpoint during timeout");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$1", "run"));
            }
        });
    }

    @Nullable
    public List<RubyStepVariant> getSmartStepIntoVariants() {
        try {
            this.sendCommand(this.commandFactory.createReadSmartStepIntoVariants());
            return Arrays.asList(this.getReadersSupport().readSmartStepIntoVariants());
        }
        catch (RubyDebuggerException e) {
            LOG.warn("Cannot read smart step into variants from: " + String.valueOf(this.getDebugTarget()), (Throwable)e);
            return null;
        }
    }

    private void addBreakpointImpl(@NotNull IRubyBreakpoint breakpoint, boolean supportBlockBreakpoints) {
        block5: {
            if (breakpoint == null) {
                RubyDebuggerProxy.$$$reportNull$$$0(10);
            }
            LOG.debug("Adding breakpoint to ", new Object[]{this.debugTarget.getHost(), ":", this.debugTarget.getPort(), ": ", breakpoint});
            try {
                if (breakpoint instanceof IRubyLineBreakpoint) {
                    this.addLineBreakpoint((IRubyLineBreakpoint)breakpoint, supportBlockBreakpoints);
                    break block5;
                }
                if (breakpoint instanceof IRubyExceptionBreakpoint) {
                    this.addExceptionalBreakpoint((IRubyExceptionBreakpoint)breakpoint);
                    break block5;
                }
                throw new IllegalArgumentException("Unknown breakpoint type: " + String.valueOf(breakpoint));
            }
            catch (RubyDebuggerException ex) {
                LOG.warn("Cannot add breakpoint to: " + String.valueOf(this.getDebugTarget()), (Throwable)ex);
            }
        }
    }

    private synchronized void addExceptionalBreakpoint(@NotNull IRubyExceptionBreakpoint breakpoint) throws RubyDebuggerException {
        if (breakpoint == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(11);
        }
        if (!this.isReady()) {
            LOG.debug("Session and/or debuggee is not ready, skipping addition of breakpoint: ", new Object[]{breakpoint});
            return;
        }
        if (this.supportsCatchpointRemoval || !this.removedCatchpoints.remove(breakpoint.getException())) {
            String command = this.commandFactory.createCatchOn(breakpoint);
            this.sendCommand(command);
            this.getReadersSupport().readCatchpointSet();
        }
    }

    private synchronized void addLineBreakpoint(@NotNull IRubyLineBreakpoint breakpoint, boolean supportBlockBreakpoints) throws RubyDebuggerException {
        if (breakpoint == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(12);
        }
        if (!this.isReady()) {
            LOG.debug("Session and/or debuggee is not ready, skipping addition of breakpoint: ", new Object[]{breakpoint});
            return;
        }
        String breakpointFile = breakpoint.getFilePath();
        int lineNumber = breakpoint.getLineNumber();
        String command = supportBlockBreakpoints ? (breakpoint instanceof IRubyBlockBreakpoint ? this.commandFactory.createAddBlockBreakpoint(breakpointFile, lineNumber, ((IRubyBlockBreakpoint)breakpoint).getBlockOrdinal()) : this.commandFactory.createAddBreakpoint(breakpointFile, lineNumber, breakpoint.isAllSuspensions())) : this.commandFactory.createAddBreakpoint(breakpointFile, lineNumber, false);
        this.sendCommand(command);
        Pair<Integer, ThreeState> data = this.getReadersSupport().readAddedBreakpointData();
        int id = (Integer)data.first;
        ThreeState valid = (ThreeState)data.second;
        String condition = breakpoint.getCondition();
        if (condition != null && this.supportsCondition) {
            command = this.commandFactory.createSetCondition(id, RubyDebuggerProxy.escapeNewlinesForDebugger(condition));
            if (command != null) {
                this.sendCommand(command);
                this.getReadersSupport().readConditionSet();
            } else {
                LOG.info("conditional breakpoints are not supported by backend");
            }
        }
        if (!breakpoint.isEnabled()) {
            this.disableLineBreakpoint(breakpoint);
        }
        this.breakpointsIDs.put(id, (Object)breakpoint);
        this.fireDebugEvent(RubyDebugEvent.createBreakpointSetEvent(this, breakpoint, valid));
    }

    public void sendSmartStepInto(final RubyFrame frame, final int id) throws RubyDebuggerException {
        LOG.debug("Queuing smartStepInto ", new Object[]{frame, ", id: ", id, " at ", Thread.currentThread().getName()});
        this.myCommandProcessor.add((Object)new DebuggerCommand("smartStepInto"){

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                if (readersSupport == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    RubyDebuggerProxy.this.sendCommand(RubyDebuggerProxy.this.commandFactory.createSmartStepInto(id));
                }
                catch (RubyDebuggerException e) {
                    throw new ExecutionException("Failed to send smart step into: " + String.valueOf(frame) + "; id: " + id, e);
                }
                finally {
                    RubyDebuggerProxy.this.resume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$2", "run"));
            }
        });
    }

    private synchronized void disableLineBreakpoint(@NotNull IRubyLineBreakpoint breakpoint) throws RubyDebuggerException {
        Integer id;
        if (breakpoint == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(13);
        }
        if ((id = this.findBreakpointId(breakpoint)) == null) {
            LOG.info("Unable to get id for a given breakpoint (" + String.valueOf(breakpoint) + ")");
            return;
        }
        String command = this.commandFactory.createDisableBreakpoint(id);
        if (command == null) {
            LOG.info("disabling breakpoints is nor supported by backend");
            return;
        }
        this.sendCommand(command);
        this.getReadersSupport().readDisabledBreakpointNo(id);
    }

    public void removeBreakpoint(final IRubyBreakpoint breakpoint) {
        LOG.debug("Queueing breakpoint removal: ", new Object[]{breakpoint, " on ", Thread.currentThread().getName()});
        this.myCommandProcessor.add((Object)new DebuggerCommand("remove_breakpoint"){

            @Override
            public void run(@NotNull ReadersSupport readersSupport) {
                if (readersSupport == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    RubyDebuggerProxy.this.removeBreakpointImpl(breakpoint);
                } else if (!RubyDebuggerProxy.this.isFinished()) {
                    LOG.warn("Couldn't remove breakpoint during timeout");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$3", "run"));
            }
        });
    }

    private void removeBreakpointImpl(@NotNull IRubyBreakpoint breakpoint) {
        if (breakpoint == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(14);
        }
        LOG.debug("Removing breakpoint on ", new Object[]{this.debugTarget.getHost(), ":", this.debugTarget.getPort(), ": ", breakpoint});
        if (breakpoint instanceof IRubyLineBreakpoint) {
            this.removeLineBreakpoint((IRubyLineBreakpoint)breakpoint);
        } else if (breakpoint instanceof IRubyExceptionBreakpoint) {
            this.removeExceptionalBreakpoint((IRubyExceptionBreakpoint)breakpoint);
        } else {
            throw new IllegalArgumentException("Unknown breakpoint type: " + String.valueOf(breakpoint));
        }
    }

    private synchronized void removeLineBreakpoint(@NotNull IRubyLineBreakpoint breakpoint) {
        if (breakpoint == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(15);
        }
        if (!this.isReady()) {
            LOG.debug("Session and/or debuggee is not ready, skipping removing of breakpoint: ", new Object[]{breakpoint});
            return;
        }
        Integer id = this.findBreakpointId(breakpoint);
        if (id == null) {
            LOG.debug("Breakpoint [", new Object[]{breakpoint, "] cannot be removed since ", "its ID cannot be found. Might have been already removed."});
            return;
        }
        String command = this.commandFactory.createRemoveBreakpoint(id);
        try {
            this.sendCommand(command);
            this.getReadersSupport().waitForRemovedBreakpoint(id);
            this.breakpointsIDs.remove((Object)id);
            LOG.debug("Breakpoint ", new Object[]{breakpoint, " with id ", id, " successfully removed"});
        }
        catch (RubyDebuggerException e) {
            LOG.warn("Exception during removing breakpoint.", (Throwable)e);
        }
    }

    private synchronized void removeExceptionalBreakpoint(@NotNull IRubyExceptionBreakpoint breakpoint) {
        if (breakpoint == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(16);
        }
        if (!this.isReady()) {
            LOG.debug("Session and/or debuggee is not ready, skipping removing of breakpoint: ", new Object[]{breakpoint});
            return;
        }
        if (!this.supportsCatchpointRemoval) {
            this.removedCatchpoints.add(breakpoint.getException());
            return;
        }
        String command = this.commandFactory.createCatchOff(breakpoint);
        try {
            this.sendCommand(command);
            this.getReadersSupport().readCatchpointDeleted();
            LOG.debug("Exceptional breakpoint for ", new Object[]{breakpoint, " is set"});
        }
        catch (RubyDebuggerException e) {
            LOG.warn("Exception during removing ecxeptional breakpoint.", (Throwable)e);
        }
    }

    public void updateBreakpoint(IRubyBreakpoint breakpoint) {
        throw new UnsupportedOperationException("not implemented");
    }

    private synchronized Integer findBreakpointId(IRubyLineBreakpoint wantedBP) {
        for (Int2ObjectMap.Entry breakpointID : Int2ObjectMaps.fastIterable(this.breakpointsIDs)) {
            IRubyLineBreakpoint bp = (IRubyLineBreakpoint)breakpointID.getValue();
            int id = breakpointID.getIntKey();
            if (!wantedBP.getFilePath().equals(bp.getFilePath()) || wantedBP.getLineNumber() != bp.getLineNumber()) continue;
            return id;
        }
        return null;
    }

    private void startSuspensionReaderLoop() {
        new SuspensionReaderLoop().start();
    }

    @Nullable
    public Socket getCommandSocket() throws RubyDebuggerException {
        if (this.commandSocket == null) {
            this.commandSocket = this.attach();
        }
        return this.commandSocket;
    }

    public void resume(final RubyThread thread) {
        LOG.debug("Queueing resume thread command for ", new Object[]{thread, " on ", Thread.currentThread().getName()});
        this.myCommandProcessor.add((Object)new DebuggerCommand("resume"){

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                if (readersSupport == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    try {
                        RubyDebuggerProxy.this.sendCommand(RubyDebuggerProxy.this.commandFactory.createResume(thread));
                    }
                    catch (RubyDebuggerException e) {
                        throw new ExecutionException("failed to resume " + String.valueOf(thread), e);
                    }
                    finally {
                        thread.resume();
                        RubyDebuggerProxy.this.resume();
                    }
                } else if (!RubyDebuggerProxy.this.isFinished()) {
                    LOG.warn("Couldn't resume during timeout");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$4", "run"));
            }
        });
    }

    private synchronized void sendCommand(String s) throws RubyDebuggerException {
        this.doSendCommand(s);
    }

    private void doSendCommand(String s) throws RubyDebuggerException {
        LOG.debug("Sending debugger command to ", new Object[]{this.debugTarget.getHost(), ":", this.debugTarget.getPort(), ": '", s, "' from thread ", Thread.currentThread().getName()});
        if (!this.isReady()) {
            throw new RubyDebuggerException("Trying to send a command [" + s + "] to non-started or finished proxy (debuggee: " + String.valueOf(this.getDebugTarget()) + ")");
        }
        this.getCommandWriter().println(s);
    }

    public void sendStepOver(final RubyFrame frame, final boolean forceNewLine) {
        LOG.debug("Queueing stepOver command on ", new Object[]{frame, ", force new line: ", forceNewLine, " on ", Thread.currentThread().getName()});
        this.myCommandProcessor.add((Object)new DebuggerCommand("sendStepOver"){

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                if (readersSupport == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    try {
                        if (forceNewLine) {
                            RubyDebuggerProxy.this.sendCommand(RubyDebuggerProxy.this.commandFactory.createForcedStepOver(frame));
                        }
                        RubyDebuggerProxy.this.sendCommand(RubyDebuggerProxy.this.commandFactory.createStepOver(frame));
                    }
                    catch (RubyDebuggerException e) {
                        throw new ExecutionException("Stepping over failed: " + String.valueOf(frame) + "; force new line: " + forceNewLine, e);
                    }
                    finally {
                        RubyDebuggerProxy.this.resume();
                    }
                } else if (!RubyDebuggerProxy.this.isFinished()) {
                    LOG.warn("Couldn't step over during timeout");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$5", "run"));
            }
        });
    }

    public void sendStepReturnEnd(final @NotNull RubyFrame frame) {
        if (frame == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(17);
        }
        LOG.debug("Queuing steppingOut command on ", new Object[]{frame, " on ", Thread.currentThread().getName()});
        this.myCommandProcessor.add((Object)new DebuggerCommand("sendStepReturnEnd"){

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                if (readersSupport == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (RubyDebuggerProxy.this.waitForDebuggerProxyReady()) {
                    try {
                        RubyDebuggerProxy.this.sendCommand(RubyDebuggerProxy.this.commandFactory.createStepReturn(frame));
                    }
                    catch (RubyDebuggerException e) {
                        throw new ExecutionException("Failed to stepReturnEnd " + String.valueOf(frame), e);
                    }
                    finally {
                        RubyDebuggerProxy.this.resume();
                    }
                } else if (!RubyDebuggerProxy.this.isFinished()) {
                    LOG.warn("Couldn't step out during timeout");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$6", "run"));
            }
        });
    }

    public void sendStepIntoEnd(final RubyFrame frame, final boolean forceNewLine) {
        LOG.debug("Queuing stepIntoEnd ", new Object[]{frame, ", force new line: ", forceNewLine, " at ", Thread.currentThread().getName()});
        this.myCommandProcessor.add((Object)new DebuggerCommand("sendStepIntoEnd"){

            @Override
            public void run(@NotNull ReadersSupport readersSupport) throws ExecutionException {
                if (readersSupport == null) {
                    7.$$$reportNull$$$0(0);
                }
                try {
                    if (forceNewLine) {
                        RubyDebuggerProxy.this.sendCommand(RubyDebuggerProxy.this.commandFactory.createForcedStepInto(frame));
                    } else {
                        RubyDebuggerProxy.this.sendCommand(RubyDebuggerProxy.this.commandFactory.createStepInto(frame));
                    }
                }
                catch (RubyDebuggerException e) {
                    throw new ExecutionException("Failed to stepIntoEnd in " + String.valueOf(frame) + "; force new line: " + forceNewLine, e);
                }
                finally {
                    RubyDebuggerProxy.this.resume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$7", "run"));
            }
        });
    }

    public RubyThreadInfo[] readThreadInfo() throws RubyDebuggerException {
        this.sendCommand(this.commandFactory.createReadThreads());
        return this.getReadersSupport().readThreads();
    }

    public RubyFrame[] readFrames(RubyThread thread) throws RubyDebuggerException {
        RubyFrameInfo[] infos;
        try {
            this.sendCommand(this.commandFactory.createReadFrames(thread));
            infos = this.getReadersSupport().readFrames();
        }
        catch (RubyDebuggerException e) {
            if (this.isReady()) {
                throw e;
            }
            LOG.debug("Session and/or debuggee is not ready, returning empty thread list.");
            infos = new RubyFrameInfo[]{};
        }
        RubyFrame[] frames = new RubyFrame[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyFrameInfo info = infos[i];
            RubyFrame newFrame = new RubyFrame(thread, info);
            if (i == 0 && info.isHasAdditionalLocation()) {
                newFrame.setLocation(this.readSuspensionLocation(newFrame));
            }
            frames[i] = newFrame;
        }
        return frames;
    }

    public RubySuspensionLocation readSuspensionLocation(RubyFrame frame) throws RubyDebuggerException {
        try {
            this.sendCommand(this.commandFactory.createSuspensionLocation(frame));
            return this.getReadersSupport().readSuspensionLocation();
        }
        catch (RubyDebuggerException e) {
            if (this.isReady()) {
                throw e;
            }
            LOG.debug("Session and/or debuggee is not ready, returning empty thread list.");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyVariable @NotNull [] readVariables(RubyFrame frame) throws RubyDebuggerException {
        RubyVariableInfo[] infos;
        Object object = this.variablesLock;
        synchronized (object) {
            this.sendCommand(this.commandFactory.createReadLocalVariables(frame));
            infos = this.getReadersSupport().readVariables();
        }
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(info, frame);
        }
        if (variables == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(18);
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RubyVariable readReceiver(@NotNull RubyFrame frame) throws RubyDebuggerException {
        RubyVariableInfo info;
        if (frame == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(19);
        }
        Object object = this.variablesLock;
        synchronized (object) {
            this.sendCommand(this.commandFactory.createReadReceiver(frame));
            info = this.getReadersSupport().readReceiver();
        }
        return new RubyVariable(info, frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RubyVariable readReturnValue(@NotNull RubyFrame frame) throws RubyDebuggerException {
        RubyVariableInfo info;
        if (frame == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(20);
        }
        Object object = this.variablesLock;
        synchronized (object) {
            this.sendCommand(this.commandFactory.createReadReturnValue(frame));
            info = this.getReadersSupport().readReturnValue();
        }
        return new RubyVariable(info, frame);
    }

    public boolean isSupportsLoadingFullValue() {
        return this.mySupportsLoadingFullValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RubyFullValue readFullValue(@NotNull RubyFrame frame, boolean unlimited, @NotNull String expression) throws RubyDebuggerException {
        RubyFullValueInfo info;
        if (frame == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(21);
        }
        if (expression == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(22);
        }
        LOG.assertTrue(this.mySupportsLoadingFullValue, (Object)"The debugger version must support evaluation of the full value on request");
        Object object = this.variablesLock;
        synchronized (object) {
            this.sendCommand(this.commandFactory.createLoadFullValue(frame, unlimited, expression));
            info = this.getReadersSupport().readFullValue();
        }
        return new RubyFullValue(frame.getProxy(), info);
    }

    public RubyVariable[] readInstanceVariables(RubyVariable variable) throws RubyDebuggerException {
        return this.doReadInstanceVariables(variable, this.commandFactory.createReadInstanceVariable(variable));
    }

    public RubyVariable[] readInstanceVariablesRange(RubyVariable variable, int start, int limit) throws RubyDebuggerException {
        return this.doReadInstanceVariables(variable, this.commandFactory.createReadInstanceVariablesRange(variable, start, limit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyVariable[] doReadInstanceVariables(RubyVariable variable, @NotNull String command) throws RubyDebuggerException {
        RubyVariableInfo[] infos;
        if (command == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(23);
        }
        Object object = this.variablesLock;
        synchronized (object) {
            this.sendCommand(command);
            infos = this.getReadersSupport().readVariables();
        }
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(info, variable);
        }
        return variables;
    }

    @Nullable
    public Future<?> submitRequest(@NotNull Runnable runnable) {
        if (runnable == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(24);
        }
        if (this.myState.get() != State.RUNNING) {
            LOG.debug("Proxy is terminating or terminated, dropping the task");
            return null;
        }
        if (this.myDebuggerRequestsExecutor.isShutdown()) {
            LOG.debug("Dropping submitted task, because executor is down already");
            return null;
        }
        try {
            return this.myDebuggerRequestsExecutor.submit(runnable);
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Was unable to schedule request: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyVariable[] readGlobalVariables() throws RubyDebuggerException {
        RubyVariableInfo[] infos;
        Object object = this.variablesLock;
        synchronized (object) {
            this.sendCommand(this.commandFactory.createReadGlobalVariables());
            infos = this.getReadersSupport().readVariables();
        }
        RubyVariable[] variables = new RubyVariable[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            RubyVariableInfo info = infos[i];
            variables[i] = new RubyVariable(this, info);
        }
        return variables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyVariable inspectExpression(RubyFrame frame, String expression) throws RubyDebuggerException {
        RubyVariableInfo[] infos;
        expression = RubyDebuggerProxy.escapeNewlinesForDebugger(expression);
        Object object = this.variablesLock;
        synchronized (object) {
            this.sendCommand(this.commandFactory.createInspect(frame, expression));
            infos = this.getReadersSupport().readVariables();
        }
        return infos.length == 0 ? null : new RubyVariable(infos[0], frame);
    }

    public ExpressionInfo getExpressionInfo(RubyFrame frame, String expression) throws RubyDebuggerException {
        expression = RubyDebuggerProxy.escapeNewlinesForDebugger(expression);
        this.sendCommand(this.commandFactory.createExpressionInfo(frame, expression));
        return this.getReadersSupport().readExpressionInfo();
    }

    public void setTypeRenderers(@NotNull JsonArray typeRenderers) throws RubyDebuggerException {
        if (typeRenderers == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(25);
        }
        LOG.assertTrue(this.mySupportsTypeRenderers, (Object)"The debugger version must support type renderers.");
        this.sendCommand(this.commandFactory.createSetRenderers(typeRenderers));
        RubyRenderersStatusInfo info = this.getReadersSupport().readRenderersStatus();
        if (info.getStatus()) {
            LOG.info("Successful set up of renderers: " + String.valueOf(typeRenderers));
        } else {
            LOG.warn("Failed to set up renderers: " + String.valueOf(typeRenderers) + ".\nWith message: " + info.getMessage());
        }
    }

    public void finish(boolean forced) {
        LOG.debug("Finishing proxy ", new Object[]{this, "; forced: ", forced});
        if (this.myState.getAndSet(State.TERMINATING) != State.RUNNING) {
            LOG.debug("Trying to finish the same proxy more than once: ", new Object[]{this});
            return;
        }
        this.myCommandProcessor.clear();
        this.myDebuggerRequestsExecutor.shutdown();
        this.myBreakpointStateChangeWatcher.stop();
        RubyDebugTarget target = this.getDebugTarget();
        if (target.isRemote()) {
            this.sendDetach();
        } else if (forced) {
            this.sendExit();
        }
        if (this.commandWriter != null) {
            this.commandWriter.flush();
        }
        try {
            long start = System.currentTimeMillis();
            while (this.commandSocket != null && !this.commandSocket.isClosed() && System.currentTimeMillis() - start < 10000L) {
                Thread.sleep(10L);
            }
            LOG.debug("Proxy socket closed in ", new Object[]{System.currentTimeMillis() - start});
            this.getReadersSupport().terminate();
            if (this.commandSocket != null && !this.commandSocket.isClosed()) {
                try {
                    this.commandWriter.close();
                    this.commandSocket.close();
                }
                catch (IOException e) {
                    LOG.debug("Error closing command socket: ", new Object[]{e.getMessage()});
                }
            }
            this.fireDebugEvent(RubyDebugEvent.createTerminateEvent(this));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.commandWriter = null;
            this.commandSocket = null;
            this.myState.set(State.TERMINATED);
        }
    }

    private void sendExit() {
        if (this.commandSocket != null && this.debugTarget.isAvailable()) {
            try {
                this.doSendCommand("exit");
            }
            catch (RubyDebuggerException ex) {
                LOG.debug("'exit' command failed. Remote process? -> ", new Object[]{this.debugTarget.isRemote()});
                if (!this.debugTarget.isRemote()) {
                    LOG.debug("'exit' command failed. Process running? -> ", new Object[]{this.debugTarget.isRunning()});
                }
            }
        } else {
            LOG.debug("Unable to send exit, because no socket or target unavailable: ", new Object[]{this.debugTarget});
        }
    }

    private void sendDetach() {
        if (this.commandSocket != null && this.debugTarget.isAvailable()) {
            try {
                this.doSendCommand("detach");
            }
            catch (RubyDebuggerException ex) {
                LOG.warn("'detach' command failed.");
            }
        } else {
            LOG.debug("Unable to send detach, because no socket or target unavailable: ", new Object[]{this.debugTarget});
        }
    }

    public synchronized void jump(int line) {
        block2: {
            try {
                this.sendCommand("jump " + line);
            }
            catch (RubyDebuggerException ex) {
                if (!this.isReady()) break block2;
                LOG.warn("Cannot jump", (Throwable)ex);
            }
        }
    }

    public synchronized void threadPause(int id) {
        block2: {
            try {
                this.sendCommand("pause " + id);
            }
            catch (RubyDebuggerException ex) {
                if (!this.isReady()) break block2;
                LOG.warn("Cannot pause", (Throwable)ex);
            }
        }
    }

    public synchronized void setType(RubyVariable var, String new_type) {
        block2: {
            try {
                this.sendCommand("set_type " + var.getName() + " " + new_type);
            }
            catch (RubyDebuggerException ex) {
                if (!this.isReady()) break block2;
                LOG.warn("Cannot set_type", (Throwable)ex);
            }
        }
    }

    @NotNull
    public static String escapeNewlinesForDebugger(@NotNull String expression) {
        if (expression == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(26);
        }
        expression = StringUtil.replace((String)expression, (String)"\\", (String)"\\\\");
        String string = expression = StringUtil.replace((String)expression, (String)"\n", (String)"\\n");
        if (string == null) {
            RubyDebuggerProxy.$$$reportNull$$$0(27);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Socket attach() throws RubyDebuggerException {
        int port = this.debugTarget.getPort();
        String host = this.debugTarget.getHost();
        Socket socket = null;
        int tryCount = this.timeout * 2;
        for (int i = 0; i < tryCount && socket == null; ++i) {
            try {
                Socket tmpSocket = new Socket(host, port);
                tmpSocket.setSoTimeout(100);
                try {
                    int tmpVal = tmpSocket.getInputStream().read();
                    if (tmpVal == -1) {
                        if (tmpSocket.isClosed()) continue;
                        tmpSocket.close();
                        TimeoutUtil.sleep((long)500L);
                        continue;
                    }
                }
                catch (SocketTimeoutException ex) {
                    socket = tmpSocket;
                    socket.setSoTimeout(0);
                }
                LOG.debug("Successfully attached to ", new Object[]{host, Character.valueOf(':'), port});
                continue;
            }
            catch (ConnectException e) {
                RubyDebuggerProxy ex = this;
                synchronized (ex) {
                    if (this.isFinished()) {
                        throw new RubyDebuggerException("Process was terminated before debugger connection was established.");
                    }
                    if (i == tryCount - 1) {
                        this.failWithInfo(e);
                    }
                }
                try {
                    if (this.debugTarget.isAvailable()) {
                        LOG.debug("Cannot connect to ", new Object[]{host, Character.valueOf(':'), port, ". Trying again...(", tryCount - i - 1, Character.valueOf(')')});
                        Thread.sleep(500L);
                        continue;
                    }
                    this.failWithInfo(e);
                }
                catch (InterruptedException e1) {
                    LOG.info("Interrupted during attaching.", (Throwable)e1);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (IOException e) {
                throw new RubyDebuggerException(e);
            }
        }
        return socket;
    }

    private void failWithInfo(ConnectException e) throws RubyDebuggerException {
        String info = this.debugTarget.isRemote() ? "[Remote Process at " + this.debugTarget.getHost() + ":" + this.debugTarget.getPort() + "]" : "Local process: " + String.valueOf(this.debugTarget);
        throw new RubyDebuggerException("Cannot connect to the debugged process at port " + this.debugTarget.getPort() + " in " + this.timeout + "s:\n\n" + info, e);
    }

    public boolean canReadFramesOfNonSuspendedThreads() {
        return this.supportsFrameReadingForNonSuspendedThreads;
    }

    public boolean waitForDebuggerProxyReady() {
        int attempt = 0;
        while (attempt++ < 60) {
            if (this.isFinished()) {
                return false;
            }
            if (this.isReady()) {
                return true;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ignored) {
                LOG.debug("Interrupted during sleep: ", (Throwable)ignored);
                return false;
            }
        }
        return false;
    }

    public boolean isPaused() {
        return this.myIsPaused;
    }

    public void pause() {
        LOG.debug("Pausing proxy ", new Object[]{this, " at ", Thread.currentThread().getName()});
        this.myIsPaused = true;
    }

    public void resume() {
        LOG.debug("Resuming proxy ", new Object[]{this, " at ", Thread.currentThread().getName()});
        this.myIsPaused = false;
    }

    @TestOnly
    public void waitForCompletionAllRequests() throws InterruptedException, TimeoutException, ExecutionException {
        this.myDebuggerRequestsExecutor.waitAllTasksExecuted(10L, TimeUnit.SECONDS);
    }

    @TestOnly
    public boolean isCommandQueueEmpty() {
        return this.myCommandProcessor.isEmpty();
    }

    public String toString() {
        return "RubyDebuggerProxy{debugTarget=" + String.valueOf(this.debugTarget) + ", timeout=" + this.timeout + ", paused=" + this.myIsPaused + ", finished=" + String.valueOf((Object)this.myState.get()) + ", supportsFrameReadingForNonSuspendedThreads=" + this.supportsFrameReadingForNonSuspendedThreads + ", supportsCondition=" + this.supportsCondition + ", supportsCatchpointRemoval=" + this.supportsCatchpointRemoval + ", supportsLoadingFullValue=" + this.mySupportsLoadingFullValue + ", removedCatchpoints=" + String.valueOf(this.removedCatchpoints) + ", commandSocket=" + String.valueOf(this.commandSocket) + ", readersSupport=" + String.valueOf(this.readersSupport) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToInclude";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToExclude";
                break;
            }
            case 2: 
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRenderers";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialBreakpoints";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/RubyDebuggerProxy";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/RubyDebuggerProxy";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readVariables";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeNewlinesForDebugger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attach";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "attachToRubyDebug";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fireDebugEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpointImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addExceptionalBreakpoint";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLineBreakpoint";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "disableLineBreakpoint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpointImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeLineBreakpoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeExceptionalBreakpoint";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sendStepReturnEnd";
                break;
            }
            case 18: 
            case 27: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "readReceiver";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readReturnValue";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readFullValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doReadInstanceVariables";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "submitRequest";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setTypeRenderers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "escapeNewlinesForDebugger";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 27 -> new IllegalStateException(string);
        };
    }

    private static enum State {
        RUNNING,
        TERMINATING,
        TERMINATED;

    }

    private class BreakpointStateChangeWatcher {
        @Nullable
        ScheduledFuture<?> myFuture;

        private BreakpointStateChangeWatcher() {
        }

        public synchronized void start() {
            if (this.myFuture != null) {
                LOG.warn("BreakpointStateChangeWatcher is already running");
                return;
            }
            ScheduledExecutorService executor = AppExecutorUtil.getAppScheduledExecutorService();
            this.myFuture = executor.scheduleWithFixedDelay(() -> {
                final Pair<Integer, ThreeState> breakpointState = RubyDebuggerProxy.this.getReadersSupport().pollBreakpointState();
                if (breakpointState == null) {
                    return;
                }
                LOG.debug("Queueing breakpoint state event ", new Object[]{breakpointState});
                RubyDebuggerProxy.this.myCommandProcessor.add((Object)new DebuggerCommand("breakpointStateChange"){

                    @Override
                    public void run(@NotNull ReadersSupport readersSupport) {
                        if (readersSupport == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!RubyDebuggerProxy.this.isReady()) {
                            LOG.info("Session and/or debuggee is not ready, ignoring backend event - breakpoint state change: " + String.valueOf(breakpointState));
                            return;
                        }
                        RubyDebuggerProxy.this.fireDebugEvent(RubyDebugEvent.createBreakpointSetEvent(RubyDebuggerProxy.this, (IRubyLineBreakpoint)RubyDebuggerProxy.this.breakpointsIDs.get(breakpointState.first), (ThreeState)breakpointState.second));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$BreakpointStateChangeWatcher$1", "run"));
                    }
                });
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }

        public synchronized void stop() {
            if (this.myFuture != null) {
                this.myFuture.cancel(false);
                this.myFuture = null;
            }
        }
    }

    private class SuspensionReaderLoop
    extends Thread {
        SuspensionReaderLoop() {
            super("RubyDebuggerLoop [" + System.currentTimeMillis() + "]");
        }

        @Override
        public void run() {
            SuspensionPoint sp;
            LOG.debug("Waiting for breakpoints.");
            while (true) {
                RubyThread thread;
                ExceptionSuspensionPoint exceptionSP;
                sp = RubyDebuggerProxy.this.getReadersSupport().readSuspension();
                LOG.debug("Suspended at: ", new Object[]{sp});
                if (sp == null || sp == SuspensionPoint.END) break;
                if (!RubyDebuggerProxy.this.supportsCatchpointRemoval && sp.isException() && RubyDebuggerProxy.this.removedCatchpoints.contains((exceptionSP = (ExceptionSuspensionPoint)sp).getExceptionType()) && (thread = RubyDebuggerProxy.this.getDebugTarget().getThreadById(sp.getThreadId())) != null) {
                    RubyDebuggerProxy.this.resume(thread);
                    continue;
                }
                LOG.debug("Queueing suspension event at ", new Object[]{sp});
                RubyDebuggerProxy.this.myCommandProcessor.add((Object)new DebuggerCommand("suspension"){

                    @Override
                    public void run(@NotNull ReadersSupport readersSupport) {
                        if (readersSupport == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!RubyDebuggerProxy.this.isReady()) {
                            LOG.info("Session and/or debuggee is not ready, ignoring backend event - suspension point: " + String.valueOf(sp));
                        } else {
                            RubyDebuggerProxy.this.debugTarget.suspensionOccurred(sp);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readersSupport", "org/rubyforge/debugcommons/RubyDebuggerProxy$SuspensionReaderLoop$1", "run"));
                    }
                });
            }
            LOG.debug("Stopping suspension loop: ", new Object[]{sp});
            boolean unexpectedFail = RubyDebuggerProxy.this.getReadersSupport().isUnexpectedFail();
            if (unexpectedFail) {
                LOG.warn("Unexpected fail. Debuggee: " + String.valueOf(RubyDebuggerProxy.this.getDebugTarget()));
            }
            RubyDebuggerProxy.this.finish(unexpectedFail);
            LOG.debug("Socket reader loop finished.");
        }
    }

    private static abstract class DebuggerCommand {
        @NotNull
        private final String myName;

        protected DebuggerCommand(@NotNull String name) {
            if (name == null) {
                DebuggerCommand.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        public abstract void run(@NotNull ReadersSupport var1) throws ExecutionException;

        public void rejected(@NotNull Exception reason) {
            if (reason == null) {
                DebuggerCommand.$$$reportNull$$$0(1);
            }
            if (reason instanceof ExecutionException) {
                LOG.warn(reason.getLocalizedMessage());
            } else {
                LOG.error((Throwable)reason);
            }
        }

        public String toString() {
            return "DebuggerCommand{myName='" + this.myName + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            objectArray2[1] = "org/rubyforge/debugcommons/RubyDebuggerProxy$DebuggerCommand";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "rejected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

